/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.protocols.wmi;

import java.util.ArrayList;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.protocols.wmi.IWmiClient;
import org.opennms.protocols.wmi.WmiClient;
import org.opennms.protocols.wmi.WmiException;
import org.opennms.protocols.wmi.WmiMgrOperation;
import org.opennms.protocols.wmi.WmiParams;
import org.opennms.protocols.wmi.WmiResult;
import org.opennms.protocols.wmi.wbem.OnmsWbemObjectSet;

public class WmiManager {
    public static int DEFAULT_SOCKET_TIMEOUT = 5000;
    private String m_HostName = null;
    private String m_Domain = null;
    private String m_Username = null;
    private String m_Password = null;
    private IWmiClient m_WmiClient = null;
    private String m_MatchType = null;
    private int m_Timeout = DEFAULT_SOCKET_TIMEOUT;

    private ThreadCategory log() {
        return ThreadCategory.getInstance(this.getClass());
    }

    public void setPassword(String pass) {
        this.m_Password = pass;
    }

    public void setHostName(String host) {
        this.m_HostName = host;
    }

    public String getHostName() {
        return this.m_HostName;
    }

    public void setTimeout(int timeout) {
        this.m_Timeout = timeout;
    }

    public int getTimeout() {
        return this.m_Timeout;
    }

    public WmiManager(String host, String user, String pass) {
        this.m_HostName = host;
        this.m_Username = user;
        this.m_Password = pass;
        this.m_Domain = host;
        this.m_MatchType = "all";
    }

    public WmiManager(String host, String user, String pass, String domain) {
        this.m_HostName = host;
        this.m_Username = user;
        this.m_Password = pass;
        this.m_MatchType = "all";
        this.m_Domain = domain.equals("") ? host : domain;
    }

    public WmiManager(String host, String user, String pass, String domain, String matchType) {
        this.m_HostName = host;
        this.m_Username = user;
        this.m_Password = pass;
        this.m_MatchType = WmiManager.isValidMatchType(matchType) ? matchType : "all";
        this.m_Domain = domain == null || domain.equals("") ? host : domain;
    }

    private WmiManager() {
    }

    public static boolean isValidMatchType(String matchType) {
        return matchType.equals("all") || matchType.equals("none") || matchType.equals("some") || matchType.equals("one");
    }

    public static boolean isValidOpType(String opType) {
        try {
            WmiMgrOperation op = WmiMgrOperation.valueOf(opType);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public void init() throws WmiException {
        this.m_WmiClient = new WmiClient(this.m_HostName);
        this.m_WmiClient.connect(this.m_Domain, this.m_Username, this.m_Password);
    }

    public void init(IWmiClient client) throws WmiException {
        this.m_WmiClient = client;
        this.m_WmiClient.connect(this.m_Domain, this.m_Username, this.m_Password);
    }

    public void close() throws WmiException {
        if (this.m_WmiClient == null) {
            throw new WmiException("Failed to close client: WmiClient was not initialized.");
        }
        this.m_WmiClient.disconnect();
    }

    public WmiResult performOp(WmiParams params) throws WmiException {
        if (params.getWmiOperation().equals("Wql")) {
            return this.performExecQuery(params);
        }
        return this.performInstanceOf(params);
    }

    public WmiResult performExecQuery(WmiParams params) throws WmiException {
        ArrayList<Object> wmiObjects = new ArrayList<Object>();
        OnmsWbemObjectSet wos = this.m_WmiClient.performExecQuery(params.getWql());
        for (int i = 0; i < wos.count(); ++i) {
            wmiObjects.add(wos.get(i).getWmiProperties().getByName(params.getWmiObject()).getWmiValue());
        }
        WmiResult result = new WmiResult(wmiObjects);
        if (params.getCompareOperation().equals("NOOP")) {
            result.setResultCode((short)0);
        } else if (params.getCompareOperation().equals("EQ") || params.getCompareOperation().equals("NEQ") || params.getCompareOperation().equals("GT") || params.getCompareOperation().equals("LT")) {
            this.performResultCheck(result, params);
        } else {
            result.setResultCode((short)-1);
        }
        return result;
    }

    public WmiResult performInstanceOf(WmiParams params) throws WmiException {
        ArrayList<Object> wmiObjects = new ArrayList<Object>();
        OnmsWbemObjectSet wos = this.m_WmiClient.performInstanceOf(params.getWmiClass());
        for (int i = 0; i < wos.count(); ++i) {
            wmiObjects.add(wos.get(i).getWmiProperties().getByName(params.getWmiObject()).getWmiValue());
        }
        WmiResult result = new WmiResult(wmiObjects);
        if (params.getCompareOperation().equals("NOOP")) {
            result.setResultCode((short)0);
        } else if (params.getCompareOperation().equals("EQ") || params.getCompareOperation().equals("NEQ") || params.getCompareOperation().equals("GT") || params.getCompareOperation().equals("LT")) {
            this.performResultCheck(result, params);
        } else {
            result.setResultCode((short)-1);
        }
        return result;
    }

    private void performResultCheck(WmiResult wmiResult, WmiParams params) throws WmiException {
        ArrayList<Object> wmiObjects = wmiResult.getResponse();
        int matches = 0;
        int total = wmiObjects.size();
        for (int i = 0; i < total; ++i) {
            Object wmiObj = wmiObjects.get(i);
            WmiMgrOperation op = WmiMgrOperation.valueOf(params.getCompareOperation());
            if (!op.compareString(wmiObj, (String)params.getCompareValue())) continue;
            ++matches;
        }
        if (this.m_MatchType.equals("all") && matches == total && matches > 0) {
            wmiResult.setResultCode((short)0);
        } else if (this.m_MatchType.equals("none") && matches == 0) {
            wmiResult.setResultCode((short)0);
        } else if (this.m_MatchType.equals("one") && matches == 1) {
            wmiResult.setResultCode((short)0);
        } else if (this.m_MatchType.equals("some") && matches > 1) {
            if (matches != total) {
                wmiResult.setResultCode((short)0);
            } else {
                wmiResult.setResultCode((short)1);
            }
        } else {
            wmiResult.setResultCode((short)1);
        }
    }

    public String getMatchType() {
        return this.m_MatchType;
    }

    public void setMatchType(String matchType) {
        this.m_MatchType = matchType;
    }
}

