/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.monitors;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Map;
import org.opennms.core.utils.ParameterMap;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.core.utils.TimeoutTracker;
import org.opennms.netmgt.config.WmiPeerFactory;
import org.opennms.netmgt.model.PollStatus;
import org.opennms.netmgt.poller.Distributable;
import org.opennms.netmgt.poller.MonitoredService;
import org.opennms.netmgt.poller.NetworkInterface;
import org.opennms.netmgt.poller.NetworkInterfaceNotSupportedException;
import org.opennms.netmgt.poller.monitors.IPv4Monitor;
import org.opennms.protocols.wmi.WmiAgentConfig;
import org.opennms.protocols.wmi.WmiException;
import org.opennms.protocols.wmi.WmiManager;
import org.opennms.protocols.wmi.WmiParams;
import org.opennms.protocols.wmi.WmiResult;

@Distributable
public class WmiMonitor
extends IPv4Monitor {
    private static final int DEFAULT_RETRY = 0;
    private static final int DEFAULT_TIMEOUT = 3000;
    private static final String DEFAULT_WMI_CLASS = "Win32_ComputerSystem";
    private static final String DEFAULT_WMI_OBJECT = "Status";
    private static final String DEFAULT_WMI_COMP_VAL = "OK";
    private static final String DEFAULT_WMI_MATCH_TYPE = "all";
    private static final String DEFAULT_WMI_COMP_OP = "EQ";
    private static final String DEFAULT_WMI_WQL = "NOTSET";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PollStatus poll(MonitoredService svc, Map parameters) {
        String reason = null;
        int serviceStatus = 2;
        WmiResult response = null;
        Double responseTime = null;
        NetworkInterface iface = svc.getNetInterface();
        InetAddress ipv4Addr = (InetAddress)iface.getAddress();
        ThreadCategory log = ThreadCategory.getInstance(((Object)((Object)this)).getClass());
        if (iface.getType() != 1) {
            throw new NetworkInterfaceNotSupportedException("Unsupported interface type, only TYPE_IPV4 currently supported");
        }
        WmiAgentConfig agentConfig = WmiPeerFactory.getInstance().getAgentConfig(ipv4Addr);
        String matchType = DEFAULT_WMI_MATCH_TYPE;
        String compVal = DEFAULT_WMI_COMP_VAL;
        String compOp = DEFAULT_WMI_COMP_OP;
        String wmiClass = DEFAULT_WMI_CLASS;
        String wmiObject = DEFAULT_WMI_OBJECT;
        String wmiWqlStr = DEFAULT_WMI_WQL;
        if (parameters != null) {
            if (parameters.get("timeout") != null) {
                int timeout = ParameterMap.getKeyedInteger((Map)parameters, (String)"timeout", (int)agentConfig.getTimeout());
                agentConfig.setTimeout(timeout);
            }
            if (parameters.get("retry") != null) {
                int retries = ParameterMap.getKeyedInteger((Map)parameters, (String)"retry", (int)agentConfig.getRetries());
                agentConfig.setRetries(retries);
            }
            if (parameters.get("username") != null) {
                String user = ParameterMap.getKeyedString((Map)parameters, (String)"username", (String)agentConfig.getUsername());
                agentConfig.setUsername(user);
            }
            if (parameters.get("password") != null) {
                String pass = ParameterMap.getKeyedString((Map)parameters, (String)"password", (String)agentConfig.getPassword());
                agentConfig.setUsername(pass);
            }
            if (parameters.get("domain") != null) {
                String domain = ParameterMap.getKeyedString((Map)parameters, (String)"domain", (String)agentConfig.getDomain());
                agentConfig.setUsername(domain);
            }
            matchType = ParameterMap.getKeyedString((Map)parameters, (String)"matchType", (String)DEFAULT_WMI_MATCH_TYPE);
            compVal = ParameterMap.getKeyedString((Map)parameters, (String)"compareValue", (String)DEFAULT_WMI_COMP_VAL);
            compOp = ParameterMap.getKeyedString((Map)parameters, (String)"compareOp", (String)DEFAULT_WMI_COMP_OP);
            wmiWqlStr = ParameterMap.getKeyedString((Map)parameters, (String)"wql", (String)DEFAULT_WMI_WQL);
            wmiClass = ParameterMap.getKeyedString((Map)parameters, (String)"wmiClass", (String)DEFAULT_WMI_CLASS);
            wmiObject = ParameterMap.getKeyedString((Map)parameters, (String)"wmiObject", (String)DEFAULT_WMI_OBJECT);
        }
        TimeoutTracker tracker = new TimeoutTracker(parameters, agentConfig.getRetries(), agentConfig.getTimeout());
        if (this.log().isDebugEnabled()) {
            this.log().debug("poll: address = " + ipv4Addr.getHostAddress() + ", user = " + agentConfig.getUsername() + ", " + tracker);
        }
        WmiManager mgr = null;
        tracker.reset();
        while (tracker.shouldRetry() && serviceStatus != 1) {
            try {
                tracker.startAttempt();
                if (this.log().isDebugEnabled()) {
                    this.log().debug("poll: creating WmiManager object.");
                }
                mgr = new WmiManager(ipv4Addr.getHostAddress(), agentConfig.getUsername(), agentConfig.getPassword(), agentConfig.getDomain(), matchType);
                mgr.setTimeout(tracker.getSoTimeout());
                mgr.init();
                if (this.log().isDebugEnabled()) {
                    this.log().debug("Completed initializing WmiManager object.");
                }
                serviceStatus = 3;
                WmiParams clientParams = null;
                if (wmiWqlStr.equals(DEFAULT_WMI_WQL)) {
                    clientParams = new WmiParams("InstanceOf", compVal, compOp, wmiClass, wmiObject);
                    if (this.log().isDebugEnabled()) {
                        this.log().debug("Attempting to perform operation: \\\\" + wmiClass + "\\" + wmiObject);
                    }
                } else {
                    clientParams = new WmiParams("Wql", compVal, compOp, wmiWqlStr, wmiObject);
                    if (this.log().isDebugEnabled()) {
                        this.log().debug("Attempting to perform operation: " + wmiWqlStr);
                    }
                }
                response = mgr.performOp(clientParams);
                if (this.log().isDebugEnabled()) {
                    this.log().debug("Received result: " + response);
                }
                responseTime = tracker.elapsedTimeInMillis();
                if (response != null) {
                    ArrayList<Object> wmiObjects = response.getResponse();
                    if (response.getResultCode() == 0) {
                        serviceStatus = 1;
                        reason = "Result for  " + wmiClass + "\\" + wmiObject + ": " + wmiObjects.get(0).toString();
                    } else if (response.getResultCode() == 1) {
                        serviceStatus = 2;
                        reason = "Result for  " + wmiClass + "\\" + wmiObject + ": " + wmiObjects.get(0).toString();
                        responseTime = null;
                    }
                }
            }
            catch (WmiException e) {
                log.debug("WMI Poller received exception from client: " + e.getMessage());
                reason = "WmiException: " + e.getMessage();
            }
            finally {
                if (mgr != null) {
                    try {
                        mgr.close();
                    }
                    catch (WmiException e) {
                        this.log().warn("an error occurred closing the WMI Manager", (Throwable)e);
                    }
                }
            }
            tracker.nextAttempt();
        }
        return PollStatus.get((int)serviceStatus, reason, responseTime);
    }
}

