/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.context.portlet;

import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletRequest;
import javax.portlet.PortletSession;
import javax.portlet.PortletURL;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.springframework.webflow.context.portlet.FlowUrlHandler;

public class DefaultFlowUrlHandler
implements FlowUrlHandler {
    private static final String EXECUTION_ATTRIBUTE = "execution";

    public String getFlowExecutionKey(PortletRequest request) {
        String flowExecutionKey = request.getParameter(EXECUTION_ATTRIBUTE);
        PortletSession session = request.getPortletSession(false);
        if (session != null) {
            if (flowExecutionKey == null && request instanceof RenderRequest) {
                flowExecutionKey = (String)session.getAttribute(EXECUTION_ATTRIBUTE);
            } else if (flowExecutionKey != null && request instanceof ActionRequest) {
                session.removeAttribute(EXECUTION_ATTRIBUTE);
            }
        }
        return flowExecutionKey;
    }

    public void setFlowExecutionRenderParameter(String flowExecutionKey, ActionResponse response) {
        response.setRenderParameter(EXECUTION_ATTRIBUTE, flowExecutionKey);
    }

    public void setFlowExecutionInSession(String flowExecutionKey, RenderRequest request) {
        PortletSession session = request.getPortletSession();
        session.setAttribute(EXECUTION_ATTRIBUTE, (Object)flowExecutionKey);
    }

    public String createFlowExecutionUrl(String flowId, String flowExecutionKey, RenderResponse response) {
        PortletURL url = response.createActionURL();
        url.setParameter(EXECUTION_ATTRIBUTE, flowExecutionKey);
        return url.toString();
    }
}

