/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tuple.entity;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.hibernate.EntityMode;
import org.hibernate.HibernateException;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.tuple.EntityModeToTuplizerMapping;
import org.hibernate.tuple.entity.Dom4jEntityTuplizer;
import org.hibernate.tuple.entity.DynamicMapEntityTuplizer;
import org.hibernate.tuple.entity.EntityMetamodel;
import org.hibernate.tuple.entity.EntityTuplizer;
import org.hibernate.tuple.entity.PojoEntityTuplizer;
import org.hibernate.util.ReflectHelper;

public class EntityEntityModeToTuplizerMapping
extends EntityModeToTuplizerMapping
implements Serializable {
    private static final Class[] ENTITY_TUP_CTOR_SIG = new Class[]{EntityMetamodel.class, PersistentClass.class};

    public EntityEntityModeToTuplizerMapping(PersistentClass mappedEntity, EntityMetamodel em) {
        HashMap userSuppliedTuplizerImpls = new HashMap();
        if (mappedEntity.getTuplizerMap() != null) {
            userSuppliedTuplizerImpls.putAll(mappedEntity.getTuplizerMap());
        }
        EntityTuplizer dynamicMapTuplizer = null;
        String tuplizerImpl = (String)userSuppliedTuplizerImpls.remove(EntityMode.MAP);
        dynamicMapTuplizer = tuplizerImpl == null ? new DynamicMapEntityTuplizer(em, mappedEntity) : EntityEntityModeToTuplizerMapping.buildEntityTuplizer(tuplizerImpl, mappedEntity, em);
        EntityTuplizer pojoTuplizer = null;
        tuplizerImpl = (String)userSuppliedTuplizerImpls.remove(EntityMode.POJO);
        pojoTuplizer = mappedEntity.hasPojoRepresentation() ? (tuplizerImpl == null ? new PojoEntityTuplizer(em, mappedEntity) : EntityEntityModeToTuplizerMapping.buildEntityTuplizer(tuplizerImpl, mappedEntity, em)) : dynamicMapTuplizer;
        EntityTuplizer dom4jTuplizer = null;
        tuplizerImpl = (String)userSuppliedTuplizerImpls.remove(EntityMode.DOM4J);
        dom4jTuplizer = mappedEntity.hasDom4jRepresentation() ? (tuplizerImpl == null ? new Dom4jEntityTuplizer(em, mappedEntity) : EntityEntityModeToTuplizerMapping.buildEntityTuplizer(tuplizerImpl, mappedEntity, em)) : null;
        if (pojoTuplizer != null) {
            this.addTuplizer(EntityMode.POJO, pojoTuplizer);
        }
        if (dynamicMapTuplizer != null) {
            this.addTuplizer(EntityMode.MAP, dynamicMapTuplizer);
        }
        if (dom4jTuplizer != null) {
            this.addTuplizer(EntityMode.DOM4J, dom4jTuplizer);
        }
        if (!userSuppliedTuplizerImpls.isEmpty()) {
            Iterator itr = userSuppliedTuplizerImpls.entrySet().iterator();
            while (itr.hasNext()) {
                Map.Entry entry = itr.next();
                EntityMode entityMode = (EntityMode)entry.getKey();
                EntityTuplizer tuplizer = EntityEntityModeToTuplizerMapping.buildEntityTuplizer((String)entry.getValue(), mappedEntity, em);
                this.addTuplizer(entityMode, tuplizer);
            }
        }
    }

    private static EntityTuplizer buildEntityTuplizer(String className, PersistentClass pc, EntityMetamodel em) {
        try {
            Class implClass = ReflectHelper.classForName(className);
            return (EntityTuplizer)implClass.getConstructor(ENTITY_TUP_CTOR_SIG).newInstance(em, pc);
        }
        catch (Throwable t) {
            throw new HibernateException("Could not build tuplizer [" + className + "]", t);
        }
    }
}

