/*
 * Decompiled with CFR 0.152.
 */
package twitter4j;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import twitter4j.Twitter;
import twitter4j.TwitterException;
import twitter4j.TwitterResponse;
import twitter4j.User;
import twitter4j.http.Response;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirectMessage
extends TwitterResponse
implements Serializable {
    private int id;
    private String text;
    private int sender_id;
    private int recipient_id;
    private Date created_at;
    private String sender_screen_name;
    private String recipient_screen_name;
    private static final long serialVersionUID = -3253021825891789737L;
    private User sender;
    private User recipient;

    DirectMessage(Response res, Twitter twitter) throws TwitterException {
        super(res);
        this.init(res, res.asDocument().getDocumentElement(), twitter);
    }

    DirectMessage(Response res, Element elem, Twitter twitter) throws TwitterException {
        super(res);
        this.init(res, elem, twitter);
    }

    private void init(Response res, Element elem, Twitter twitter) throws TwitterException {
        DirectMessage.ensureRootNodeNameIs("direct_message", elem);
        this.sender = new User(res, (Element)elem.getElementsByTagName("sender").item(0), twitter);
        this.recipient = new User(res, (Element)elem.getElementsByTagName("recipient").item(0), twitter);
        this.id = DirectMessage.getChildInt("id", elem);
        this.text = DirectMessage.getChildText("text", elem);
        this.sender_id = DirectMessage.getChildInt("sender_id", elem);
        this.recipient_id = DirectMessage.getChildInt("recipient_id", elem);
        this.created_at = DirectMessage.getChildDate("created_at", elem);
        this.sender_screen_name = DirectMessage.getChildText("sender_screen_name", elem);
        this.recipient_screen_name = DirectMessage.getChildText("recipient_screen_name", elem);
    }

    public int getId() {
        return this.id;
    }

    public String getText() {
        return this.text;
    }

    public int getSenderId() {
        return this.sender_id;
    }

    public int getRecipientId() {
        return this.recipient_id;
    }

    public Date getCreatedAt() {
        return this.created_at;
    }

    public String getSenderScreenName() {
        return this.sender_screen_name;
    }

    public String getRecipientScreenName() {
        return this.recipient_screen_name;
    }

    public User getSender() {
        return this.sender;
    }

    public User getRecipient() {
        return this.recipient;
    }

    static List<DirectMessage> constructDirectMessages(Response res, Twitter twitter) throws TwitterException {
        Document doc = res.asDocument();
        if (DirectMessage.isRootNodeNilClasses(doc)) {
            return new ArrayList<DirectMessage>(0);
        }
        try {
            DirectMessage.ensureRootNodeNameIs("direct-messages", doc);
            NodeList list = doc.getDocumentElement().getElementsByTagName("direct_message");
            int size = list.getLength();
            ArrayList<DirectMessage> messages = new ArrayList<DirectMessage>(size);
            for (int i = 0; i < size; ++i) {
                Element status = (Element)list.item(i);
                messages.add(new DirectMessage(res, status, twitter));
            }
            return messages;
        }
        catch (TwitterException te) {
            if (DirectMessage.isRootNodeNilClasses(doc)) {
                return new ArrayList<DirectMessage>(0);
            }
            throw te;
        }
    }

    public int hashCode() {
        return this.id;
    }

    public boolean equals(Object obj) {
        if (null == obj) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        return obj instanceof DirectMessage && ((DirectMessage)obj).id == this.id;
    }

    public String toString() {
        return new StringBuffer().append("DirectMessage{id=").append(this.id).append(", text='").append(this.text).append('\'').append(", sender_id=").append(this.sender_id).append(", recipient_id=").append(this.recipient_id).append(", created_at=").append(this.created_at).append(", sender_screen_name='").append(this.sender_screen_name).append('\'').append(", recipient_screen_name='").append(this.recipient_screen_name).append('\'').append(", sender=").append(this.sender).append(", recipient=").append(this.recipient).append('}').toString();
    }
}

