/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config;

import java.io.File;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.directory.server.configuration.MutableServerStartupConfiguration;
import org.apache.directory.server.core.DirectoryService;
import org.apache.directory.server.core.configuration.ShutdownConfiguration;
import org.apache.directory.server.protocol.shared.store.LdifFileLoader;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.Lifecycle;
import org.springframework.core.io.Resource;
import org.springframework.ldap.core.ContextSource;
import org.springframework.util.Assert;

class ApacheDSContainer
implements InitializingBean,
DisposableBean,
Lifecycle,
ApplicationContextAware {
    private Log logger = LogFactory.getLog(this.getClass());
    private MutableServerStartupConfiguration configuration;
    private ApplicationContext ctxt;
    private File workingDir;
    private ContextSource contextSource;
    private boolean running;
    private String ldifResources;
    static /* synthetic */ Class class$org$apache$directory$server$jndi$ServerContextFactory;

    public ApacheDSContainer(MutableServerStartupConfiguration config, ContextSource contextSource, String ldifs) {
        this.configuration = config;
        this.contextSource = contextSource;
        this.ldifResources = ldifs;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.workingDir == null) {
            String apacheWorkDir = System.getProperty("apacheDSWorkDir");
            if (apacheWorkDir == null) {
                apacheWorkDir = System.getProperty("java.io.tmpdir") + File.separator + "apacheds-spring-security";
            }
            this.setWorkingDirectory(new File(apacheWorkDir));
        }
        this.start();
    }

    public void destroy() throws Exception {
        this.stop();
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.ctxt = applicationContext;
    }

    private boolean deleteDir(File dir) {
        if (dir.isDirectory()) {
            String[] children = dir.list();
            for (int i = 0; i < children.length; ++i) {
                boolean success = this.deleteDir(new File(dir, children[i]));
                if (success) continue;
                return false;
            }
        }
        return dir.delete();
    }

    public void setWorkingDirectory(File workingDir) {
        Assert.notNull((Object)workingDir);
        this.logger.info((Object)("Setting working directory for LDAP_PROVIDER: " + workingDir.getAbsolutePath()));
        if (workingDir.exists()) {
            throw new IllegalArgumentException("The specified working directory '" + workingDir.getAbsolutePath() + "' already exists. Another directory service instance may be using it or it may be from a " + " previous unclean shutdown. Please confirm and delete it or configure a different " + "working directory");
        }
        this.workingDir = workingDir;
        this.configuration.setWorkingDirectory(workingDir);
    }

    public void start() {
        if (this.isRunning()) {
            return;
        }
        DirectoryService ds = DirectoryService.getInstance((String)this.configuration.getInstanceId());
        if (ds.isStarted()) {
            throw new IllegalStateException("A DirectoryService with Id '" + this.configuration.getInstanceId() + "' is already running.");
        }
        this.logger.info((Object)("Starting directory server with Id '" + this.configuration.getInstanceId() + "'"));
        Properties env = new Properties();
        env.setProperty("java.naming.factory.initial", (class$org$apache$directory$server$jndi$ServerContextFactory == null ? (class$org$apache$directory$server$jndi$ServerContextFactory = ApacheDSContainer.class$("org.apache.directory.server.jndi.ServerContextFactory")) : class$org$apache$directory$server$jndi$ServerContextFactory).getName());
        env.setProperty("java.naming.security.authentication", "simple");
        env.setProperty("java.naming.security.principal", "uid=admin,ou=system");
        env.setProperty("java.naming.security.credentials", "secret");
        ((Hashtable)env).putAll(this.configuration.toJndiEnvironment());
        try {
            new InitialDirContext(env);
        }
        catch (NamingException e) {
            this.logger.error((Object)"Failed to start directory service", (Throwable)e);
            return;
        }
        this.running = true;
        try {
            this.importLdifs();
        }
        catch (Exception e) {
            this.logger.error((Object)"Failed to import LDIF file(s)", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void importLdifs() throws IOException, NamingException {
        Resource[] ldifs = this.ctxt.getResources(this.ldifResources);
        DirContext dirContext = this.contextSource.getReadWriteContext();
        if (ldifs != null && ldifs.length > 0) {
            try {
                String ldifFile = ldifs[0].getFile().getAbsolutePath();
                this.logger.info((Object)("Loading LDIF file: " + ldifFile));
                LdifFileLoader loader = new LdifFileLoader(dirContext, ldifFile);
                loader.execute();
            }
            finally {
                dirContext.close();
            }
        }
    }

    public void stop() {
        Properties env = new Properties();
        env.setProperty("java.naming.factory.initial", (class$org$apache$directory$server$jndi$ServerContextFactory == null ? (class$org$apache$directory$server$jndi$ServerContextFactory = ApacheDSContainer.class$("org.apache.directory.server.jndi.ServerContextFactory")) : class$org$apache$directory$server$jndi$ServerContextFactory).getName());
        env.setProperty("java.naming.security.authentication", "simple");
        env.setProperty("java.naming.security.principal", "uid=admin,ou=system");
        env.setProperty("java.naming.security.credentials", "secret");
        ShutdownConfiguration shutdown = new ShutdownConfiguration(this.configuration.getInstanceId());
        ((Hashtable)env).putAll(shutdown.toJndiEnvironment());
        this.logger.info((Object)("Shutting down directory server with Id '" + this.configuration.getInstanceId() + "'"));
        try {
            new InitialContext(env);
        }
        catch (NamingException e) {
            this.logger.error((Object)"Failed to shutdown directory server", (Throwable)e);
            return;
        }
        this.running = false;
        if (this.workingDir.exists()) {
            this.logger.info((Object)("Deleting working directory " + this.workingDir.getAbsolutePath()));
            this.deleteDir(this.workingDir);
        }
    }

    public boolean isRunning() {
        return this.running;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

