/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.authoritymapping;

import java.util.Locale;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.security.GrantedAuthority;
import org.springframework.security.GrantedAuthorityImpl;
import org.springframework.security.authoritymapping.Attributes2GrantedAuthoritiesMapper;
import org.springframework.util.Assert;

public class SimpleAttributes2GrantedAuthoritiesMapper
implements Attributes2GrantedAuthoritiesMapper,
InitializingBean {
    private String attributePrefix = "ROLE_";
    private boolean convertAttributeToUpperCase = false;
    private boolean convertAttributeToLowerCase = false;
    private boolean addPrefixIfAlreadyExisting = false;

    public void afterPropertiesSet() throws Exception {
        Assert.isTrue((!this.isConvertAttributeToUpperCase() || !this.isConvertAttributeToLowerCase() ? 1 : 0) != 0, (String)"Either convertAttributeToUpperCase or convertAttributeToLowerCase can be set to true, but not both");
    }

    public GrantedAuthority[] getGrantedAuthorities(String[] attributes) {
        GrantedAuthority[] result = new GrantedAuthority[attributes.length];
        for (int i = 0; i < attributes.length; ++i) {
            result[i] = this.getGrantedAuthority(attributes[i]);
        }
        return result;
    }

    private GrantedAuthority getGrantedAuthority(String attribute) {
        if (this.isConvertAttributeToLowerCase()) {
            attribute = attribute.toLowerCase(Locale.getDefault());
        } else if (this.isConvertAttributeToUpperCase()) {
            attribute = attribute.toUpperCase(Locale.getDefault());
        }
        if (this.isAddPrefixIfAlreadyExisting() || !attribute.startsWith(this.getAttributePrefix())) {
            return new GrantedAuthorityImpl(this.getAttributePrefix() + attribute);
        }
        return new GrantedAuthorityImpl(attribute);
    }

    private boolean isConvertAttributeToLowerCase() {
        return this.convertAttributeToLowerCase;
    }

    public void setConvertAttributeToLowerCase(boolean b) {
        this.convertAttributeToLowerCase = b;
    }

    private boolean isConvertAttributeToUpperCase() {
        return this.convertAttributeToUpperCase;
    }

    public void setConvertAttributeToUpperCase(boolean b) {
        this.convertAttributeToUpperCase = b;
    }

    private String getAttributePrefix() {
        return this.attributePrefix == null ? "" : this.attributePrefix;
    }

    public void setAttributePrefix(String string) {
        this.attributePrefix = string;
    }

    private boolean isAddPrefixIfAlreadyExisting() {
        return this.addPrefixIfAlreadyExisting;
    }

    public void setAddPrefixIfAlreadyExisting(boolean b) {
        this.addPrefixIfAlreadyExisting = b;
    }
}

