/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.vacuumd;

import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.Validator;
import org.opennms.netmgt.config.vacuumd.ActionEvents;
import org.opennms.netmgt.config.vacuumd.Actions;
import org.opennms.netmgt.config.vacuumd.AutoEvents;
import org.opennms.netmgt.config.vacuumd.Automations;
import org.opennms.netmgt.config.vacuumd.Statement;
import org.opennms.netmgt.config.vacuumd.Triggers;
import org.xml.sax.ContentHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VacuumdConfiguration
implements Serializable {
    private int _period;
    private boolean _has_period;
    private List<Statement> _statementList = new ArrayList<Statement>();
    private Automations _automations;
    private Triggers _triggers;
    private Actions _actions;
    private AutoEvents _autoEvents;
    private ActionEvents _actionEvents;

    public void addStatement(Statement vStatement) throws IndexOutOfBoundsException {
        this._statementList.add(vStatement);
    }

    public void addStatement(int index, Statement vStatement) throws IndexOutOfBoundsException {
        this._statementList.add(index, vStatement);
    }

    public void deletePeriod() {
        this._has_period = false;
    }

    public Enumeration<Statement> enumerateStatement() {
        return Collections.enumeration(this._statementList);
    }

    public ActionEvents getActionEvents() {
        return this._actionEvents;
    }

    public Actions getActions() {
        return this._actions;
    }

    public AutoEvents getAutoEvents() {
        return this._autoEvents;
    }

    public Automations getAutomations() {
        return this._automations;
    }

    public int getPeriod() {
        return this._period;
    }

    public Statement getStatement(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._statementList.size()) {
            throw new IndexOutOfBoundsException("getStatement: Index value '" + index + "' not in range [0.." + (this._statementList.size() - 1) + "]");
        }
        return this._statementList.get(index);
    }

    public Statement[] getStatement() {
        Statement[] array = new Statement[]{};
        return this._statementList.toArray(array);
    }

    public List<Statement> getStatementCollection() {
        return this._statementList;
    }

    public int getStatementCount() {
        return this._statementList.size();
    }

    public Triggers getTriggers() {
        return this._triggers;
    }

    public boolean hasPeriod() {
        return this._has_period;
    }

    public boolean isValid() {
        try {
            this.validate();
        }
        catch (ValidationException vex) {
            return false;
        }
        return true;
    }

    public Iterator<Statement> iterateStatement() {
        return this._statementList.iterator();
    }

    public void marshal(Writer out) throws MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (Writer)out);
    }

    public void marshal(ContentHandler handler) throws IOException, MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (ContentHandler)handler);
    }

    public void removeAllStatement() {
        this._statementList.clear();
    }

    public boolean removeStatement(Statement vStatement) {
        boolean removed = this._statementList.remove(vStatement);
        return removed;
    }

    public Statement removeStatementAt(int index) {
        Statement obj = this._statementList.remove(index);
        return obj;
    }

    public void setActionEvents(ActionEvents actionEvents) {
        this._actionEvents = actionEvents;
    }

    public void setActions(Actions actions) {
        this._actions = actions;
    }

    public void setAutoEvents(AutoEvents autoEvents) {
        this._autoEvents = autoEvents;
    }

    public void setAutomations(Automations automations) {
        this._automations = automations;
    }

    public void setPeriod(int period) {
        this._period = period;
        this._has_period = true;
    }

    public void setStatement(int index, Statement vStatement) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._statementList.size()) {
            throw new IndexOutOfBoundsException("setStatement: Index value '" + index + "' not in range [0.." + (this._statementList.size() - 1) + "]");
        }
        this._statementList.set(index, vStatement);
    }

    public void setStatement(Statement[] vStatementArray) {
        this._statementList.clear();
        for (int i = 0; i < vStatementArray.length; ++i) {
            this._statementList.add(vStatementArray[i]);
        }
    }

    public void setStatement(List<Statement> vStatementList) {
        this._statementList.clear();
        this._statementList.addAll(vStatementList);
    }

    public void setStatementCollection(List<Statement> statementList) {
        this._statementList = statementList;
    }

    public void setTriggers(Triggers triggers) {
        this._triggers = triggers;
    }

    public static VacuumdConfiguration unmarshal(Reader reader) throws MarshalException, ValidationException {
        return (VacuumdConfiguration)Unmarshaller.unmarshal(VacuumdConfiguration.class, (Reader)reader);
    }

    public void validate() throws ValidationException {
        Validator validator = new Validator();
        validator.validate((Object)this);
    }
}

