/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.utils;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.ProtocolException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.GregorianCalendar;
import org.apache.log4j.Logger;
import org.opennms.core.utils.Base64;

public final class HttpUtils {
    public static final int DEFAULT_POST_BUFFER_SIZE = 1024;

    private HttpUtils() {
    }

    public static InputStream post(URL url, InputStream dataStream) throws IOException {
        return HttpUtils.post(url, dataStream, null, null, 1024);
    }

    public static InputStream post(URL url, InputStream dataStream, String username, String password) throws IOException {
        return HttpUtils.post(url, dataStream, username, password, 1024);
    }

    public static InputStream post(URL url, InputStream dataStream, String username, String password, int bufSize) throws IOException {
        if (url == null || dataStream == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        if (bufSize < 1) {
            throw new IllegalArgumentException("Cannot use zero or negative buffer size.");
        }
        if (!"http".equals(url.getProtocol())) {
            throw new IllegalArgumentException("Cannot use non-HTTP URLs.");
        }
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setDoOutput(true);
        conn.setDoInput(true);
        try {
            conn.setRequestMethod("POST");
        }
        catch (ProtocolException e) {
            throw new IllegalStateException("Could not set a HttpURLConnection's method to POST.");
        }
        if (username != null && password != null) {
            byte[] authBytes = (username + ":" + password).getBytes();
            String authString = new String(Base64.encodeBase64(authBytes));
            conn.setRequestProperty("Authorization", "Basic " + authString);
        }
        OutputStream ostream = conn.getOutputStream();
        byte[] b = new byte[bufSize];
        int bytesRead = dataStream.read(b, 0, bufSize);
        while (bytesRead > 0) {
            ostream.write(b, 0, bytesRead);
            bytesRead = dataStream.read(b, 0, bufSize);
        }
        ostream.close();
        return conn.getInputStream();
    }

    public static InputStream post(URL url, Reader dataReader, String username, String password, int bufSize) throws IOException {
        char[] b;
        int bytesRead;
        if (url == null || dataReader == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        if (bufSize < 1) {
            throw new IllegalArgumentException("Cannot use zero or negative buffer size.");
        }
        if (!"http".equals(url.getProtocol())) {
            throw new IllegalArgumentException("Cannot use non-HTTP URLs.");
        }
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setDoOutput(true);
        conn.setDoInput(true);
        try {
            conn.setRequestMethod("POST");
        }
        catch (ProtocolException e) {
            throw new IllegalStateException("Could not set a HttpURLConnection's method to POST.");
        }
        if (username != null && password != null) {
            byte[] authBytes = (username + ":" + password).getBytes();
            String authString = new String(Base64.encodeBase64(authBytes));
            conn.setRequestProperty("Authorization", "Basic " + authString);
        }
        conn.setRequestProperty("Content-type", "text/xml; charset=\"utf-8\"");
        OutputStreamWriter ostream = new OutputStreamWriter(conn.getOutputStream(), "US-ASCII");
        Logger log = Logger.getLogger((String)"POSTDATALOG");
        if (log.isDebugEnabled()) {
            String nl = System.getProperty("line.separator");
            log.debug((Object)(nl + "HTTP Post: Current time: " + new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new GregorianCalendar().getTime())));
            log.debug((Object)(nl + "Data posted:" + nl));
        }
        if ((bytesRead = dataReader.read(b = new char[bufSize], 0, bufSize)) > 0 && log.isDebugEnabled()) {
            log.debug((Object)new String(b, 0, bytesRead));
        }
        while (bytesRead > 0) {
            ostream.write(b, 0, bytesRead);
            bytesRead = dataReader.read(b, 0, bufSize);
            if (bytesRead <= 0 || !log.isDebugEnabled()) continue;
            log.debug((Object)new String(b, 0, bytesRead));
        }
        ostream.close();
        return conn.getInputStream();
    }
}

