/*
 * Decompiled with CFR 0.152.
 */
package org.smslib.threading;

import org.smslib.Service;

public abstract class AServiceThread
extends Thread {
    private Service service;
    private int delay;
    private int initialDelay;
    private boolean enabled;
    private boolean canceled;

    public AServiceThread(String name, Service service, int delay, int initialDelay, boolean enabled) {
        this.setName(name);
        this.setService(service);
        this.setDelay(delay);
        if (enabled) {
            this.enable();
        } else {
            this.disable();
        }
        this.canceled = false;
        this.getService().getLogger().logDebug("Initialized.", null, null);
        this.start();
    }

    public Service getService() {
        return this.service;
    }

    public void setService(Service service) {
        this.service = service;
    }

    public int getDelay() {
        return this.delay;
    }

    public void setDelay(int delay) {
        this.delay = delay;
    }

    public int getInitialDelay() {
        return this.initialDelay;
    }

    public void setInitialDelay(int initialDelay) {
        this.initialDelay = initialDelay;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void enable() {
        this.enabled = true;
    }

    public void disable() {
        this.enabled = false;
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public void cancel() {
        this.canceled = true;
        this.interrupt();
        try {
            this.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void run() {
        while (!this.isCanceled()) {
            try {
                this.getService().getLogger().logDebug(this.isEnabled() ? "Running..." : "** disabled **", null, null);
                if (this.isEnabled()) {
                    this.process();
                }
                AServiceThread.sleep(this.getDelay());
            }
            catch (InterruptedException e) {
                if (this.isCanceled()) {
                    this.getService().getLogger().logDebug("Stopped.", null, null);
                    break;
                }
                this.getService().getLogger().logInfo("Interrupted!", e, null);
            }
            catch (Exception e) {
                this.getService().getLogger().logError("Error!", e, null);
            }
        }
    }

    public abstract void process() throws Exception;
}

