/*
 * Decompiled with CFR 0.152.
 */
package org.smslib.routing;

import java.util.ArrayList;
import org.smslib.AGateway;
import org.smslib.OutboundMessage;
import org.smslib.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Router {
    private ArrayList<AGateway> candidates = new ArrayList();
    private ArrayList<AGateway> allowed = new ArrayList();
    private Service srv;

    public Router(Service mySrv) {
        this.srv = mySrv;
    }

    protected Service getService() {
        return this.srv;
    }

    protected ArrayList<AGateway> getCandidates() {
        return this.candidates;
    }

    protected ArrayList<AGateway> getAllowed() {
        return this.allowed;
    }

    protected void preroute(OutboundMessage msg) {
        for (AGateway gtw : this.getService().getGateways()) {
            if (!gtw.isOutbound() || gtw.getStatus() != AGateway.GatewayStatuses.STARTED) continue;
            if (msg.getGatewayId().equalsIgnoreCase("*")) {
                this.getCandidates().add(gtw);
                continue;
            }
            if (!msg.getGatewayId().equalsIgnoreCase(gtw.getGatewayId())) continue;
            this.getCandidates().add(gtw);
        }
    }

    public AGateway route(OutboundMessage msg) {
        AGateway gtw = null;
        this.beginRouting();
        this.preroute(msg);
        this.customRouting(msg);
        if (this.getAllowed().size() > 0) {
            gtw = this.getService().getLoadBalancer().balance(msg, this.getAllowed());
        } else {
            msg.setMessageStatus(OutboundMessage.MessageStatuses.FAILED);
            msg.setFailureCause(OutboundMessage.FailureCauses.NO_ROUTE);
        }
        this.finishRouting();
        return gtw;
    }

    public void customRouting(OutboundMessage msg) {
        this.getAllowed().addAll(this.getCandidates());
    }

    protected final void beginRouting() {
        this.getCandidates().clear();
        this.getAllowed().clear();
    }

    protected final void finishRouting() {
        this.getCandidates().clear();
        this.getAllowed().clear();
    }
}

