/*
 * Decompiled with CFR 0.152.
 */
package org.smslib.queues;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.PriorityBlockingQueue;
import org.smslib.AGateway;
import org.smslib.OutboundMessage;
import org.smslib.Service;
import org.smslib.queues.DelayedOutboundMessage;
import org.smslib.threading.AServiceThread;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueueManager {
    HashMap<String, PriorityBlockingQueue<OutboundMessage>> queueMap;
    DelayQueue<DelayedOutboundMessage> delayQueue;
    DelayQueueManager delayQueueManager;
    Service service;

    public QueueManager(Service service) {
        this.setQueueMap(new HashMap<String, PriorityBlockingQueue<OutboundMessage>>());
        this.setDelayQueue(new DelayQueue<DelayedOutboundMessage>());
        this.setDelayQueueManager(new DelayQueueManager("DelayQueueManager", service, 200));
        this.setService(service);
    }

    public boolean queueMessage(OutboundMessage msg) {
        if (msg.getGatewayId().length() > 1) {
            return this.getGatewayQueue(msg.getGatewayId()).add(msg);
        }
        AGateway gateway = this.getService().routeMessage(msg);
        if (gateway != null) {
            return this.getGatewayQueue(gateway.getGatewayId()).add(msg);
        }
        return false;
    }

    public boolean removeMessage(OutboundMessage msg) {
        for (PriorityBlockingQueue<OutboundMessage> q : this.getQueueMap().values()) {
            if (!q.remove(msg)) continue;
            return true;
        }
        return false;
    }

    public boolean queueDelayedMessage(OutboundMessage msg, Date at) {
        return this.getDelayQueue().add(new DelayedOutboundMessage(msg, at));
    }

    public boolean queueDelayedMessage(OutboundMessage msg, long delayMillis) {
        Date at = new Date(new Date().getTime() + delayMillis);
        return this.getDelayQueue().add(new DelayedOutboundMessage(msg, at));
    }

    public int getQueueLoad() {
        int load = 0;
        for (PriorityBlockingQueue<OutboundMessage> q : this.getQueueMap().values()) {
            load += q.size();
        }
        return load;
    }

    public int getQueueLoad(String gatewayId) {
        if (this.getQueueMap().containsKey(gatewayId)) {
            return this.getQueueMap().get(gatewayId).size();
        }
        return 0;
    }

    public int getQueueLoad(int priority) {
        int load = 0;
        for (PriorityBlockingQueue<OutboundMessage> q : this.getQueueMap().values()) {
            ArrayList msgList = new ArrayList();
            q.drainTo(msgList);
            for (OutboundMessage msg : msgList) {
                if (msg.getPriority() != priority) continue;
                ++load;
            }
        }
        return load;
    }

    public int getQueueLoad(String gatewayId, int priority) {
        int load = 0;
        if (this.getQueueMap().containsKey(gatewayId)) {
            PriorityBlockingQueue<OutboundMessage> q = this.getQueueMap().get(gatewayId);
            ArrayList msgList = new ArrayList();
            q.drainTo(msgList);
            for (OutboundMessage msg : msgList) {
                if (msg.getPriority() != priority) continue;
                ++load;
            }
            return load;
        }
        return 0;
    }

    public void clearQueue(String gatewayId) {
        PriorityBlockingQueue<OutboundMessage> q = this.getQueueMap().get(gatewayId);
        if (q != null) {
            q.clear();
        }
    }

    public void clearQueues() {
        for (PriorityBlockingQueue<OutboundMessage> q : this.getQueueMap().values()) {
            q.clear();
        }
    }

    public PriorityBlockingQueue<OutboundMessage> getGatewayQueue(String gatewayId) {
        PriorityBlockingQueue<OutboundMessage> q;
        if (this.getQueueMap().containsKey(gatewayId)) {
            q = this.getQueueMap().get(gatewayId);
        } else {
            q = new PriorityBlockingQueue<OutboundMessage>(50, new Comparator<OutboundMessage>(){

                @Override
                public int compare(OutboundMessage x, OutboundMessage y) {
                    int comp = y.getPriority() - x.getPriority();
                    if (comp == 0) {
                        comp = x.getDate().compareTo(y.getDate());
                    }
                    return comp;
                }
            });
            this.getQueueMap().put(gatewayId, q);
        }
        return q;
    }

    protected HashMap<String, PriorityBlockingQueue<OutboundMessage>> getQueueMap() {
        return this.queueMap;
    }

    protected void setQueueMap(HashMap<String, PriorityBlockingQueue<OutboundMessage>> queueMap) {
        this.queueMap = queueMap;
    }

    protected void setDelayQueue(DelayQueue<DelayedOutboundMessage> delayQueue) {
        this.delayQueue = delayQueue;
    }

    protected DelayQueue<DelayedOutboundMessage> getDelayQueue() {
        return this.delayQueue;
    }

    protected Service getService() {
        return this.service;
    }

    protected void setService(Service service) {
        this.service = service;
    }

    protected DelayQueueManager getDelayQueueManager() {
        return this.delayQueueManager;
    }

    protected void setDelayQueueManager(DelayQueueManager delayQueueManager) {
        this.delayQueueManager = delayQueueManager;
    }

    class DelayQueueManager
    extends AServiceThread {
        public DelayQueueManager(String name, Service service, int delay) {
            super(name, service, delay, 0, true);
        }

        public void process() throws Exception {
            this.getService().getLogger().logDebug("DelayQueueManager running...", null, null);
            QueueManager.this.queueMessage(((DelayedOutboundMessage)QueueManager.this.getDelayQueue().take()).getMsg());
            this.getService().getLogger().logDebug("DelayQueueManager end...", null, null);
        }
    }
}

