/*
 * Decompiled with CFR 0.152.
 */
package org.smslib.queues;

import java.util.Date;
import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;
import org.smslib.OutboundMessage;

class DelayedOutboundMessage
implements Delayed {
    OutboundMessage msg;
    Date at;

    public DelayedOutboundMessage(OutboundMessage msg, Date at) {
        this.setMsg(msg);
        this.setAt(at);
    }

    public int compareTo(Delayed object) {
        if (this.getAt().getTime() < ((DelayedOutboundMessage)object).getAt().getTime()) {
            return -1;
        }
        if (this.getAt().getTime() > ((DelayedOutboundMessage)object).getAt().getTime()) {
            return 1;
        }
        return 0;
    }

    public long getDelay(TimeUnit unit) {
        long n = this.getAt().getTime() - System.currentTimeMillis();
        return unit.convert(n, TimeUnit.MILLISECONDS);
    }

    public OutboundMessage getMsg() {
        return this.msg;
    }

    public void setMsg(OutboundMessage msg) {
        this.msg = msg;
    }

    public Date getAt() {
        return this.at;
    }

    public void setAt(Date at) {
        this.at = at;
    }

    public String toString() {
        return "Scheduled: " + this.getAt();
    }
}

