/*
 * Decompiled with CFR 0.152.
 */
package org.smslib.modem.athandler;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.smslib.GatewayException;
import org.smslib.InboundMessage;
import org.smslib.TimeoutException;
import org.smslib.modem.ModemGateway;
import org.smslib.modem.athandler.ATHandler_Wavecom;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ATHandler_Wavecom_WISMOQCDMA
extends ATHandler_Wavecom {
    public ATHandler_Wavecom_WISMOQCDMA(ModemGateway myGateway) {
        super(myGateway);
        this.terminators[1] = "\\s*([\\p{ASCII}]|[^\\x00-\\xff])*\\s+OK\\s";
        this.setStorageLocations("MT");
    }

    @Override
    public String listMessages(InboundMessage.MessageClasses messageClass) throws TimeoutException, GatewayException, IOException, InterruptedException {
        StringBuffer msgList = new StringBuffer();
        String listMsgRespons = super.listMessages(messageClass);
        ArrayList<Integer> memIndexs = this.getMsgIndexs(listMsgRespons);
        for (int memIndex : memIndexs) {
            String line;
            String oneMessage = "";
            String header = "";
            String msgText = "";
            oneMessage = this.getGateway().getMessageByIndex(memIndex);
            BufferedReader reader = new BufferedReader(new StringReader(oneMessage));
            header = reader.readLine().trim();
            String regx = "(^\\+CMGR:)(\\\"[^\\\"]+\\\",)(\\\"[^\\\"]+\\\",)(\\\"[^,]+,)(\\d+)\\s+(:\\d+)\\s+(:\\d+\\\")(,\\d,)(\\d)";
            Pattern pat = Pattern.compile(regx);
            Matcher matcher = pat.matcher(header);
            header = matcher.replaceAll("$1 " + memIndex + ",$2$3,$4$5$6$7$8$9");
            char encoding = matcher.replaceAll("$9").charAt(0);
            StringBuffer msgContent = new StringBuffer();
            while ((line = reader.readLine()) != null) {
                if ((line = line.trim()).length() <= 0 || line.equalsIgnoreCase("OK")) continue;
                msgContent.append(line);
            }
            String msgContentStr = msgContent.toString();
            if (encoding == new String("4").charAt(0)) {
                char[] unicodeText = msgContentStr.toCharArray();
                msgContentStr = new String(unicodeText);
            }
            msgText = header + "\r" + msgContentStr + "\r";
            msgList.append(msgText);
        }
        msgList.append("OK\r");
        return msgList.toString();
    }

    private ArrayList<Integer> getMsgIndexs(String respons) throws IOException {
        String line;
        ArrayList<Integer> msgIndexs = new ArrayList<Integer>();
        String listMsgRespons = respons;
        BufferedReader reader = new BufferedReader(new StringReader(listMsgRespons));
        while ((line = reader.readLine().trim()) != null && (line = line.trim()).length() <= 0) {
        }
        while (line != null && (line = line.trim()).length() > 0 && !line.equalsIgnoreCase("OK")) {
            if (line.matches("^\\+CMGL:\\s*\\d+,.*")) {
                int i = line.indexOf(58);
                int j = line.indexOf(44);
                int memIndex = Integer.parseInt(line.substring(i + 1, j).trim());
                msgIndexs.add(new Integer(memIndex));
            }
            line = reader.readLine().trim();
            while (line.length() == 0) {
                line = reader.readLine().trim();
            }
        }
        reader.close();
        return msgIndexs;
    }

    @Override
    public boolean setTextProtocol() throws TimeoutException, GatewayException, IOException, InterruptedException {
        this.getModemDriver().write("AT+CMGF=1\r");
        this.getModemDriver().getResponse();
        if (this.getModemDriver().isOk()) {
            this.getModemDriver().write("AT+CSCS=\"CDMA\"\r");
            this.getModemDriver().getResponse();
            if (this.getModemDriver().isOk()) {
                this.getModemDriver().write("AT+WSCL=1,2\r");
                this.echoOff();
                return true;
            }
            return false;
        }
        return false;
    }
}

