/*
 * Decompiled with CFR 0.152.
 */
package org.smslib.modem.athandler;

import java.io.IOException;
import org.smslib.GatewayException;
import org.smslib.TimeoutException;
import org.smslib.modem.ModemGateway;
import org.smslib.modem.athandler.ATHandler;

public class ATHandler_Siemens_MC35i
extends ATHandler {
    public static final int RETRIES = 5;
    public static final int WAIT = 1500;

    public ATHandler_Siemens_MC35i(ModemGateway myGateway) {
        super(myGateway);
    }

    public void init() throws TimeoutException, GatewayException, IOException, InterruptedException {
        for (int i = 0; i < 5; ++i) {
            this.getModemDriver().write("AT+CLIP=1\r");
            this.getModemDriver().getResponse();
            if (this.getModemDriver().isOk()) break;
            this.getGateway().getService().getLogger().logDebug("Modem didn't respond correctly on AT+CLIP. Retrying...", null, this.getGateway().getGatewayId());
            Thread.sleep(1500L);
        }
        if (!this.getModemDriver().isOk()) {
            this.getGateway().getService().getLogger().logDebug("Modem didn't respond correctly on AT+CLIP correctly on 5 attemts. Giving up.", null, this.getGateway().getGatewayId());
        }
        this.getModemDriver().write("AT+COPS=0\r");
        this.getModemDriver().getResponse();
    }

    public void echoOff() throws IOException, InterruptedException {
        this.getModemDriver().write("ATV1\r");
        this.getModemDriver().write("ATQ0\r");
        this.getModemDriver().write("ATE0\r");
        Thread.sleep(this.getGateway().getService().getSettings().AT_WAIT);
        this.getModemDriver().clearBuffer();
    }
}

