/*
 * Decompiled with CFR 0.152.
 */
package org.smslib.modem;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.StringTokenizer;
import org.smslib.GatewayException;
import org.smslib.Service;
import org.smslib.helper.CommPortIdentifier;
import org.smslib.helper.SerialPort;
import org.smslib.helper.SerialPortEvent;
import org.smslib.helper.SerialPortEventListener;
import org.smslib.modem.AModemDriver;
import org.smslib.modem.ModemGateway;
import org.smslib.threading.AServiceThread;

class SerialModemDriver
extends AModemDriver
implements SerialPortEventListener {
    private String comPort;
    private int baudRate;
    private CommPortIdentifier portId;
    private SerialPort serialPort;
    private InputStream in;
    private OutputStream out;
    private PortReader portReader;

    protected SerialModemDriver(ModemGateway myGateway, String deviceParms) {
        super(myGateway, deviceParms);
        StringTokenizer tokens = new StringTokenizer(deviceParms, ":");
        this.setComPort(tokens.nextToken());
        this.setBaudRate(Integer.parseInt(tokens.nextToken()));
        this.setSerialPort(null);
    }

    protected void connectPort() throws GatewayException, IOException, InterruptedException {
        if (this.getGateway().getService().getSettings().SERIAL_NOFLUSH) {
            this.getGateway().getService().getLogger().logInfo("Comm port flushing is disabled.", null, this.getGateway().getGatewayId());
        }
        if (this.getGateway().getService().getSettings().SERIAL_POLLING) {
            this.getGateway().getService().getLogger().logInfo("Using polled serial port mode.", null, this.getGateway().getGatewayId());
        }
        try {
            this.getGateway().getService().getLogger().logInfo("Opening: " + this.getComPort() + " @" + this.getBaudRate(), null, this.getGateway().getGatewayId());
            CommPortIdentifier.getPortIdentifiers();
            this.setPortId(CommPortIdentifier.getPortIdentifier(this.getComPort()));
            this.setSerialPort(this.getPortId().open("org.smslib", 1971));
            this.setIn(this.getSerialPort().getInputStream());
            this.setOut(this.getSerialPort().getOutputStream());
            if (!this.getGateway().getService().getSettings().SERIAL_POLLING) {
                this.getSerialPort().notifyOnDataAvailable(true);
                this.getSerialPort().notifyOnOutputEmpty(true);
            }
            this.getSerialPort().notifyOnBreakInterrupt(true);
            this.getSerialPort().notifyOnFramingError(true);
            this.getSerialPort().notifyOnOverrunError(true);
            this.getSerialPort().notifyOnParityError(true);
            if (this.getGateway().getService().getSettings().SERIAL_RTSCTS_OUT) {
                this.getSerialPort().setFlowControlMode(SerialPort.FLOWCONTROL_RTSCTS_IN | SerialPort.FLOWCONTROL_RTSCTS_OUT);
            } else {
                this.getSerialPort().setFlowControlMode(SerialPort.FLOWCONTROL_RTSCTS_IN);
            }
            this.getSerialPort().addEventListener(this);
            this.getSerialPort().setSerialPortParams(this.getBaudRate(), SerialPort.DATABITS_8, SerialPort.STOPBITS_1, SerialPort.PARITY_NONE);
            this.getSerialPort().setInputBufferSize(this.getGateway().getService().getSettings().SERIAL_BUFFER_SIZE);
            this.getSerialPort().setOutputBufferSize(this.getGateway().getService().getSettings().SERIAL_BUFFER_SIZE);
            this.getSerialPort().enableReceiveThreshold(1);
            this.getSerialPort().enableReceiveTimeout(this.getGateway().getService().getSettings().SERIAL_TIMEOUT);
            if (this.getGateway().getService().getSettings().SERIAL_POLLING) {
                this.setPortReader(new PortReader("PortReader() [" + this.getComPort() + "]", this.getGateway().getService(), this.getGateway().getService().getSettings().SERIAL_POLLING_INTERVAL));
            }
        }
        catch (Exception e) {
            throw new GatewayException("Comm library exception: " + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void disconnectPort() throws IOException, InterruptedException {
        Object object = this.getSYNCReader();
        synchronized (object) {
            if (this.getGateway().getService().getSettings().SERIAL_POLLING) {
                this.getPortReader().cancel();
                this.setPortReader(null);
            }
            if (this.getSerialPort() != null) {
                this.getSerialPort().close();
            }
            this.getGateway().getService().getLogger().logInfo("Closing: " + this.getComPort() + " @" + this.getBaudRate(), null, this.getGateway().getGatewayId());
        }
    }

    protected void clear() throws IOException {
        while (this.portHasData()) {
            this.read();
        }
    }

    protected boolean portHasData() throws IOException {
        return this.getIn().available() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serialEvent(SerialPortEvent event) {
        int eventType = event.getEventType();
        if (eventType == SerialPortEvent.OE) {
            this.getGateway().getService().getLogger().logError("Overrun Error!", null, this.getGateway().getGatewayId());
        } else if (eventType == SerialPortEvent.FE) {
            this.getGateway().getService().getLogger().logError("Framing Error!", null, this.getGateway().getGatewayId());
        } else if (eventType == SerialPortEvent.PE) {
            this.getGateway().getService().getLogger().logError("Parity Error!", null, this.getGateway().getGatewayId());
        } else if (eventType == SerialPortEvent.DATA_AVAILABLE && !this.getGateway().getService().getSettings().SERIAL_POLLING) {
            Object object = this.getSYNCReader();
            synchronized (object) {
                this.setDataReceived(true);
                this.getSYNCReader().notifyAll();
            }
        }
    }

    public void write(char c) throws IOException {
        this.getOut().write(c);
        if (!this.getGateway().getService().getSettings().SERIAL_NOFLUSH) {
            this.getOut().flush();
        }
    }

    public void write(byte[] s) throws IOException {
        this.getOut().write(s);
        if (!this.getGateway().getService().getSettings().SERIAL_NOFLUSH) {
            this.getOut().flush();
        }
    }

    protected int read() throws IOException {
        return this.getIn().read();
    }

    PortReader getPortReader() {
        return this.portReader;
    }

    void setPortReader(PortReader myPortReader) {
        this.portReader = myPortReader;
    }

    String getComPort() {
        return this.comPort;
    }

    void setComPort(String myComPort) {
        this.comPort = myComPort;
    }

    int getBaudRate() {
        return this.baudRate;
    }

    void setBaudRate(int myBaudRate) {
        this.baudRate = myBaudRate;
    }

    CommPortIdentifier getPortId() {
        return this.portId;
    }

    void setPortId(CommPortIdentifier myPortId) {
        this.portId = myPortId;
    }

    SerialPort getSerialPort() {
        return this.serialPort;
    }

    void setSerialPort(SerialPort mySerialPort) {
        this.serialPort = mySerialPort;
    }

    InputStream getIn() {
        return this.in;
    }

    void setIn(InputStream myIn) {
        this.in = myIn;
    }

    OutputStream getOut() {
        return this.out;
    }

    void setOut(OutputStream myOut) {
        this.out = myOut;
    }

    private class PortReader
    extends AServiceThread {
        public PortReader(String name, Service service, int delay) {
            super(name, service, delay, 0, true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void process() throws Exception {
            block5: {
                try {
                    if (!SerialModemDriver.this.portHasData()) break block5;
                    Object object = SerialModemDriver.this.getSYNCReader();
                    synchronized (object) {
                        SerialModemDriver.this.setDataReceived(true);
                        SerialModemDriver.this.getSYNCReader().notifyAll();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }
}

