/*
 * Decompiled with CFR 0.152.
 */
package org.smslib.modem;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.NoSuchAlgorithmException;
import java.util.StringTokenizer;
import javax.net.SocketFactory;
import javax.net.ssl.SSLContext;
import org.apache.commons.net.telnet.EchoOptionHandler;
import org.apache.commons.net.telnet.InvalidTelnetOptionException;
import org.apache.commons.net.telnet.SimpleOptionHandler;
import org.apache.commons.net.telnet.SuppressGAOptionHandler;
import org.apache.commons.net.telnet.TelnetClient;
import org.apache.commons.net.telnet.TelnetOptionHandler;
import org.apache.commons.net.telnet.TerminalTypeOptionHandler;
import org.smslib.GatewayException;
import org.smslib.modem.AModemDriver;
import org.smslib.modem.ModemGateway;

class IPModemDriver
extends AModemDriver {
    private String ipAddress;
    private int ipPort;
    private TelnetClient tc;
    private InputStream in;
    private OutputStream out;
    private Peeker peeker;
    private TerminalTypeOptionHandler ttopt = new TerminalTypeOptionHandler("VT100", false, false, true, false);
    private SimpleOptionHandler binaryopt = new SimpleOptionHandler(0, true, false, true, false);
    private EchoOptionHandler echoopt = new EchoOptionHandler(true, false, true, false);
    private SuppressGAOptionHandler gaopt = new SuppressGAOptionHandler(true, true, true, true);

    protected IPModemDriver(ModemGateway myGateway, String deviceParms) {
        super(myGateway, deviceParms);
        StringTokenizer tokens = new StringTokenizer(deviceParms, ":");
        this.ipAddress = tokens.nextToken();
        this.ipPort = Integer.parseInt(tokens.nextToken());
        this.tc = null;
    }

    protected void connectPort() throws GatewayException, IOException, InterruptedException {
        try {
            this.getGateway().getService().getLogger().logInfo("Opening: " + this.ipAddress + " @" + this.ipPort, null, this.getGateway().getGatewayId());
            this.tc = new TelnetClient();
            this.tc.addOptionHandler((TelnetOptionHandler)this.ttopt);
            this.tc.addOptionHandler((TelnetOptionHandler)this.echoopt);
            this.tc.addOptionHandler((TelnetOptionHandler)this.gaopt);
            if (this.getGateway().getIpProtocol() == ModemGateway.IPProtocols.BINARY) {
                this.tc.addOptionHandler((TelnetOptionHandler)this.binaryopt);
            }
            if (this.getGateway().getIpEncryption()) {
                try {
                    this.tc.setSocketFactory((SocketFactory)SSLContext.getInstance("Default").getSocketFactory());
                }
                catch (NoSuchAlgorithmException e) {
                    this.getGateway().getService().getLogger().logError("Unable to find algorithm needed for using SSL", e, this.getGateway().getGatewayId());
                }
            }
            this.tc.connect(this.ipAddress, this.ipPort);
            this.in = this.tc.getInputStream();
            this.out = this.tc.getOutputStream();
            this.peeker = new Peeker();
        }
        catch (InvalidTelnetOptionException e) {
            throw new GatewayException("Unsupported telnet option for the selected IP connection.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void disconnectPort() throws IOException, InterruptedException {
        this.getGateway().getService().getLogger().logInfo("Closing: " + this.ipAddress + " @" + this.ipPort, null, this.getGateway().getGatewayId());
        Object object = this.getSYNCReader();
        synchronized (object) {
            if (this.tc != null) {
                this.tc.disconnect();
            }
            this.tc = null;
            this.peeker.interrupt();
            this.peeker.join();
        }
    }

    protected void clear() throws IOException {
        while (this.portHasData()) {
            this.read();
        }
    }

    protected boolean portHasData() throws IOException {
        return this.in.available() > 0;
    }

    public void write(char c) throws IOException {
        this.out.write((short)c);
        this.out.flush();
    }

    public void write(byte[] s) throws IOException {
        this.out.write(s);
        this.out.flush();
    }

    protected int read() throws IOException {
        return this.in.read();
    }

    TelnetClient getTc() {
        return this.tc;
    }

    private class Peeker
    extends Thread {
        public Peeker() {
            this.setPriority(1);
            this.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            IPModemDriver.this.getGateway().getService().getLogger().logDebug("Peeker started.", null, IPModemDriver.this.getGateway().getGatewayId());
            while (true) {
                try {
                    while (true) {
                        if (IPModemDriver.this.getTc() != null && IPModemDriver.this.portHasData()) {
                            Object object = IPModemDriver.this.getSYNCReader();
                            synchronized (object) {
                                IPModemDriver.this.setDataReceived(true);
                                IPModemDriver.this.getSYNCReader().notifyAll();
                            }
                        }
                        Peeker.sleep(IPModemDriver.this.getGateway().getService().getSettings().SERIAL_POLLING_INTERVAL);
                    }
                }
                catch (InterruptedException e) {
                    if (IPModemDriver.this.getTc() != null) continue;
                }
                catch (IOException iOException) {
                    continue;
                }
                break;
            }
            IPModemDriver.this.getGateway().getService().getLogger().logDebug("Peeker stopped.", null, IPModemDriver.this.getGateway().getGatewayId());
        }
    }
}

