/*
 * Decompiled with CFR 0.152.
 */
package org.smslib.modem;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.smslib.AGateway;

public class CNMIDetector {
    private AGateway gtw;
    private static final Pattern splitterPattern = Pattern.compile("(\\(\\d([-,]\\d)*\\)|\\d)");
    private String rawSentence = null;
    private final String[] bestMode = new String[]{"3", "2"};
    private String mode = null;
    private final String[] bestMt = new String[]{"1"};
    private String mt = null;
    private final String[] bestBm = new String[]{"0"};
    private String bm = null;
    private final String[] bestDs = new String[]{"2"};
    private String ds = null;
    private final String[] bestBfr = new String[]{"0"};
    private String bfr = null;

    public CNMIDetector(String cnmi, AGateway myGtw) {
        this.rawSentence = cnmi;
        this.gtw = myGtw;
        this.detect();
    }

    String[] convertRange(String myRange) {
        String range = myRange;
        if (range.startsWith("(")) {
            range = range.substring(1, range.length() - 1);
        }
        String[] retValue = null;
        if (range.indexOf(",") != -1) {
            retValue = range.split(",");
        } else if (range.indexOf("-") != -1) {
            int pos = range.indexOf("-");
            int begin = Integer.parseInt(range.substring(0, pos));
            int end = Integer.parseInt(range.substring(pos + 1));
            retValue = new String[end - begin + 1];
            int i = 0;
            while (begin <= end) {
                retValue[i] = String.valueOf(begin);
                ++begin;
                ++i;
            }
        } else {
            retValue = new String[]{range};
        }
        return retValue;
    }

    String getBestMatch(String[] availableOptions, String[] searchedOptions) {
        for (int i = 0; i < searchedOptions.length; ++i) {
            String search = searchedOptions[i];
            for (int j = 0; j < availableOptions.length; ++j) {
                String option = availableOptions[j];
                if (!search.equals(option)) continue;
                this.gtw.getService().getLogger().logDebug("CNMI: Found best match: " + search, null, null);
                return search;
            }
        }
        String bestAvailableOption = availableOptions[availableOptions.length - 1];
        this.gtw.getService().getLogger().logInfo("CNMI: No best match, returning: " + bestAvailableOption, null, null);
        return bestAvailableOption;
    }

    void detect() {
        Matcher m = splitterPattern.matcher(this.rawSentence);
        ArrayList<String> options = new ArrayList<String>();
        while (m.find()) {
            options.add(m.group());
        }
        if (options.size() < 5) {
            throw new IllegalArgumentException("Missing parameters");
        }
        this.mode = this.getBestMatch(this.convertRange((String)options.get(0)), this.bestMode);
        this.mt = this.getBestMatch(this.convertRange((String)options.get(1)), this.bestMt);
        this.bm = this.getBestMatch(this.convertRange((String)options.get(2)), this.bestBm);
        this.ds = this.getBestMatch(this.convertRange((String)options.get(3)), this.bestDs);
        this.bfr = this.getBestMatch(this.convertRange((String)options.get(4)), this.bestBfr);
    }

    String getMode() {
        if (this.gtw.getService().getSettings().DISABLE_CMTI) {
            return "0";
        }
        return this.mode;
    }

    String getMt() {
        return this.mt;
    }

    String getBm() {
        return this.bm;
    }

    String getDs() {
        return this.ds;
    }

    String getBfr() {
        return this.bfr;
    }

    public String toString() {
        return "AT+CNMI=" + this.getMode() + "," + this.getMt() + "," + this.getBm() + "," + this.getDs() + "," + this.getBfr();
    }

    public String getATCommand() {
        return this.toString() + "\r";
    }

    String getATCommand(String ending) {
        return this.toString() + ending;
    }
}

