/*
 * Decompiled with CFR 0.152.
 */
package org.smslib.http;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLConnection;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import org.smslib.AGateway;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class HTTPGateway
extends AGateway {
    public HTTPGateway(String id) {
        super(id);
    }

    List<String> HttpPost(URL url, List<HttpHeader> requestList) throws IOException {
        String line;
        ArrayList<String> responseList = new ArrayList<String>();
        this.getService().getLogger().logInfo("HTTP POST: " + url, null, this.getGatewayId());
        URLConnection con = url.openConnection();
        con.setDoInput(true);
        con.setDoOutput(true);
        con.setUseCaches(false);
        con.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
        OutputStreamWriter out = new OutputStreamWriter(con.getOutputStream());
        StringBuffer req = new StringBuffer();
        int n = requestList.size();
        for (int i = 0; i < n; ++i) {
            if (i != 0) {
                req.append("&");
            }
            req.append(requestList.get((int)i).key);
            req.append("=");
            if (requestList.get((int)i).unicode) {
                StringBuffer tmp = new StringBuffer(200);
                byte[] uniBytes = requestList.get((int)i).value.getBytes("UnicodeBigUnmarked");
                for (int j = 0; j < uniBytes.length; ++j) {
                    tmp.append(Integer.toHexString(uniBytes[j]).length() == 1 ? "0" + Integer.toHexString(uniBytes[j]) : Integer.toHexString(uniBytes[j]));
                }
                req.append(tmp.toString().replaceAll("ff", ""));
                continue;
            }
            req.append(requestList.get((int)i).value);
        }
        out.write(req.toString());
        out.flush();
        out.close();
        BufferedReader in = new BufferedReader(new InputStreamReader(con.getInputStream()));
        while ((line = in.readLine()) != null) {
            responseList.add(line);
        }
        in.close();
        return responseList;
    }

    List<String> HttpGet(URL url) throws IOException {
        String inputLine;
        ArrayList<String> responseList = new ArrayList<String>();
        this.getService().getLogger().logInfo("HTTP GET: " + url, null, this.getGatewayId());
        URLConnection con = url.openConnection();
        con.setAllowUserInteraction(false);
        BufferedReader in = new BufferedReader(new InputStreamReader(con.getInputStream()));
        while ((inputLine = in.readLine()) != null) {
            responseList.add(inputLine);
        }
        in.close();
        return responseList;
    }

    String ExpandHttpHeaders(List<HttpHeader> httpHeaderList) {
        StringBuffer buffer = new StringBuffer();
        for (HttpHeader h : httpHeaderList) {
            buffer.append(h.key);
            buffer.append("=");
            buffer.append(h.value);
            buffer.append("&");
        }
        return buffer.toString();
    }

    String calculateMD5(String in) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] pre_md5 = md.digest(in.getBytes("LATIN1"));
            String md5 = "";
            for (int i = 0; i < 16; ++i) {
                md5 = pre_md5[i] < 0 ? md5 + Integer.toHexString(256 + pre_md5[i]) : (pre_md5[i] > 15 ? md5 + Integer.toHexString(pre_md5[i]) : md5 + "0" + Integer.toHexString(pre_md5[i]));
            }
            return md5;
        }
        catch (UnsupportedEncodingException ex) {
            this.getService().getLogger().logError("Unsupported encoding.", ex, this.getGatewayId());
            return "";
        }
        catch (NoSuchAlgorithmException ex) {
            this.getService().getLogger().logError("No such algorithm.", ex, this.getGatewayId());
            return "";
        }
    }

    @Override
    public int getQueueSchedulingInterval() {
        return 500;
    }

    class HttpHeader {
        public String key;
        public String value;
        public boolean unicode;

        public HttpHeader() {
            this.key = "";
            this.value = "";
            this.unicode = false;
        }

        public HttpHeader(String myKey, String myValue, boolean myUnicode) {
            this.key = myKey;
            this.value = myValue;
            this.unicode = myUnicode;
        }
    }
}

