/*
 * Decompiled with CFR 0.152.
 */
package org.smslib.http;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.smslib.GatewayException;
import org.smslib.Message;
import org.smslib.OutboundMessage;
import org.smslib.OutboundWapSIMessage;
import org.smslib.Service;
import org.smslib.StatusReportMessage;
import org.smslib.TimeoutException;
import org.smslib.http.HTTPGateway;
import org.smslib.threading.AServiceThread;

public class ClickatellHTTPGateway
extends HTTPGateway {
    String apiId;
    String username;
    String password;
    String sessionId;
    KeepAlive keepAlive;
    boolean secure;
    Object SYNC_Commander;
    String HTTP = "http://";
    String HTTPS = "https://";
    String URL_BALANCE = "api.clickatell.com/http/getbalance";
    String URL_COVERAGE = "api.clickatell.com/utils/routeCoverage.php";
    String URL_QUERYMSG = "api.clickatell.com/http/querymsg";
    String URL_AUTH = "api.clickatell.com/http/auth";
    String URL_PING = "api.clickatell.com/http/ping";
    String URL_SENDMSG = "api.clickatell.com/http/sendmsg";
    String URL_SENDWAPSI = "api.clickatell.com/mms/si_push";

    public ClickatellHTTPGateway(String id, String myApiId, String myUsername, String myPassword) {
        super(id);
        this.apiId = myApiId;
        this.username = myUsername;
        this.password = myPassword;
        this.sessionId = null;
        this.secure = false;
        this.SYNC_Commander = new Object();
        this.setAttributes(93);
        this.setKeepAlive(new KeepAlive("KeepAlive [" + this.getGatewayId() + "]", this.getService(), 60000));
    }

    public void setSecure(boolean mySecure) {
        this.secure = mySecure;
    }

    public boolean getSecure() {
        return this.secure;
    }

    public void startGateway() throws TimeoutException, GatewayException, IOException, InterruptedException {
        this.getService().getLogger().logInfo("Starting gateway.", null, this.getGatewayId());
        this.connect();
        super.startGateway();
    }

    public void stopGateway() throws TimeoutException, GatewayException, IOException, InterruptedException {
        this.getService().getLogger().logInfo("Stopping gateway.", null, this.getGatewayId());
        super.stopGateway();
        this.sessionId = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float queryBalance() throws TimeoutException, GatewayException, IOException, InterruptedException {
        List<String> response;
        ArrayList<HTTPGateway.HttpHeader> request = new ArrayList<HTTPGateway.HttpHeader>();
        if (this.sessionId == null) {
            throw new GatewayException("Internal Clickatell Gateway error.");
        }
        URL url = new URL((this.secure ? this.HTTPS : this.HTTP) + this.URL_BALANCE);
        request.add(new HTTPGateway.HttpHeader(this, "session_id", this.sessionId, false));
        Object object = this.SYNC_Commander;
        synchronized (object) {
            response = this.HttpPost(url, request);
        }
        if (response.get(0).indexOf("Credit:") == 0) {
            return Float.parseFloat(response.get(0).substring(response.get(0).indexOf(58) + 1));
        }
        return -1.0f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean queryCoverage(OutboundMessage msg) throws TimeoutException, GatewayException, IOException, InterruptedException {
        List<String> response;
        ArrayList<HTTPGateway.HttpHeader> request = new ArrayList<HTTPGateway.HttpHeader>();
        if (this.sessionId == null) {
            throw new GatewayException("Internal Clickatell Gateway error.");
        }
        URL url = new URL((this.secure ? this.HTTPS : this.HTTP) + this.URL_COVERAGE);
        request.add(new HTTPGateway.HttpHeader(this, "session_id", this.sessionId, false));
        request.add(new HTTPGateway.HttpHeader(this, "msisdn", msg.getRecipient().substring(1), false));
        Object object = this.SYNC_Commander;
        synchronized (object) {
            response = this.HttpPost(url, request);
        }
        return response.get(0).indexOf("OK") == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StatusReportMessage.DeliveryStatuses queryMessage(String refNo) throws TimeoutException, GatewayException, IOException, InterruptedException {
        List<String> response;
        ArrayList<HTTPGateway.HttpHeader> request = new ArrayList<HTTPGateway.HttpHeader>();
        if (this.sessionId == null) {
            throw new GatewayException("Internal Clickatell Gateway error.");
        }
        URL url = new URL((this.secure ? this.HTTPS : this.HTTP) + this.URL_QUERYMSG);
        request.add(new HTTPGateway.HttpHeader(this, "session_id", this.sessionId, false));
        request.add(new HTTPGateway.HttpHeader(this, "apimsgid", refNo, false));
        Object object = this.SYNC_Commander;
        synchronized (object) {
            response = this.HttpPost(url, request);
        }
        int pos = response.get(0).indexOf("Status:");
        this.setDeliveryErrorCode(Integer.parseInt(response.get(0).substring(pos + 7).trim()));
        switch (this.getDeliveryErrorCode()) {
            case 1: {
                return StatusReportMessage.DeliveryStatuses.UNKNOWN;
            }
            case 2: 
            case 3: 
            case 8: 
            case 11: {
                return StatusReportMessage.DeliveryStatuses.KEEPTRYING;
            }
            case 4: {
                return StatusReportMessage.DeliveryStatuses.DELIVERED;
            }
            case 5: 
            case 6: 
            case 7: {
                return StatusReportMessage.DeliveryStatuses.ABORTED;
            }
            case 9: 
            case 10: {
                return StatusReportMessage.DeliveryStatuses.ABORTED;
            }
            case 12: {
                return StatusReportMessage.DeliveryStatuses.ABORTED;
            }
        }
        return StatusReportMessage.DeliveryStatuses.UNKNOWN;
    }

    void connect() throws GatewayException, IOException {
        try {
            if (!this.authenticate()) {
                throw new GatewayException("Cannot authenticate to Clickatell.");
            }
        }
        catch (MalformedURLException e) {
            throw new GatewayException("Internal Clickatell Gateway error.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean authenticate() throws IOException, MalformedURLException {
        List<String> response;
        ArrayList<HTTPGateway.HttpHeader> request = new ArrayList<HTTPGateway.HttpHeader>();
        this.getService().getLogger().logDebug("Authenticate().", null, this.getGatewayId());
        URL url = new URL((this.secure ? this.HTTPS : this.HTTP) + this.URL_AUTH);
        request.add(new HTTPGateway.HttpHeader(this, "api_id", this.apiId, false));
        request.add(new HTTPGateway.HttpHeader(this, "user", this.username, false));
        request.add(new HTTPGateway.HttpHeader(this, "password", this.password, false));
        Object object = this.SYNC_Commander;
        synchronized (object) {
            response = this.HttpPost(url, request);
        }
        if (response.get(0).indexOf("ERR:") == 0) {
            this.sessionId = null;
            return false;
        }
        this.sessionId = response.get(0).substring(4);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean ping() throws IOException, MalformedURLException {
        List<String> response;
        ArrayList<HTTPGateway.HttpHeader> request = new ArrayList<HTTPGateway.HttpHeader>();
        this.getService().getLogger().logDebug("Ping()", null, this.getGatewayId());
        URL url = new URL((this.secure ? this.HTTPS : this.HTTP) + this.URL_PING);
        request.add(new HTTPGateway.HttpHeader(this, "session_id", this.sessionId, false));
        Object object = this.SYNC_Commander;
        synchronized (object) {
            response = this.HttpPost(url, request);
        }
        return response.get(0).indexOf("ERR:") != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean sendMessage(OutboundMessage msg) throws TimeoutException, GatewayException, IOException, InterruptedException {
        ArrayList<HTTPGateway.HttpHeader> request = new ArrayList<HTTPGateway.HttpHeader>();
        int requestFeatures = 0;
        boolean ok = false;
        if (this.sessionId == null) {
            this.getService().getLogger().logError("No session defined.", null, this.getGatewayId());
            msg.setFailureCause(OutboundMessage.FailureCauses.GATEWAY_FAILURE);
            return false;
        }
        this.getService().getLogger().logDebug("sendMessage()", null, this.getGatewayId());
        try {
            List<String> response;
            URL url;
            if (msg.getType() == Message.MessageTypes.OUTBOUND) {
                url = new URL((this.secure ? this.HTTPS : this.HTTP) + this.URL_SENDMSG);
            } else if (msg.getType() == Message.MessageTypes.WAPSI) {
                url = new URL((this.secure ? this.HTTPS : this.HTTP) + this.URL_SENDWAPSI);
            } else {
                msg.setFailureCause(OutboundMessage.FailureCauses.BAD_FORMAT);
                this.getService().getLogger().logError("Incorrect message format.", null, this.getGatewayId());
                return false;
            }
            request.add(new HTTPGateway.HttpHeader(this, "session_id", this.sessionId, false));
            request.add(new HTTPGateway.HttpHeader(this, "to", msg.getRecipient().substring(1), false));
            request.add(new HTTPGateway.HttpHeader(this, "concat", "3", false));
            if (msg.getPriority() < 0) {
                request.add(new HTTPGateway.HttpHeader(this, "queue", "3", false));
            } else if (msg.getPriority() == 0) {
                request.add(new HTTPGateway.HttpHeader(this, "queue", "2", false));
            } else if (msg.getPriority() >= 0) {
                request.add(new HTTPGateway.HttpHeader(this, "queue", "1", false));
            }
            if (msg.getFrom() != null && msg.getFrom().length() != 0) {
                request.add(new HTTPGateway.HttpHeader(this, "from", msg.getFrom(), false));
            } else if (this.getFrom() != null && this.getFrom().length() != 0) {
                request.add(new HTTPGateway.HttpHeader(this, "from", this.getFrom(), false));
            }
            if (msg.getFlashSms()) {
                request.add(new HTTPGateway.HttpHeader(this, "msg_type", "SMS_FLASH", false));
            }
            if (msg.getType() == Message.MessageTypes.OUTBOUND) {
                if (msg.getSrcPort() != -1 || msg.getDstPort() != -1) {
                    request.add(new HTTPGateway.HttpHeader(this, "udh", msg.getPduUserDataHeader(), false));
                }
                if (msg.getEncoding() == Message.MessageEncodings.ENC7BIT) {
                    request.add(new HTTPGateway.HttpHeader(this, "text", msg.getText(), false));
                } else if (msg.getEncoding() == Message.MessageEncodings.ENCUCS2) {
                    request.add(new HTTPGateway.HttpHeader(this, "unicode", "1", false));
                    request.add(new HTTPGateway.HttpHeader(this, "text", msg.getText(), true));
                }
            } else if (msg.getType() == Message.MessageTypes.WAPSI) {
                request.add(new HTTPGateway.HttpHeader(this, "si_id", String.valueOf(msg.getId()), false));
                if (((OutboundWapSIMessage)msg).getCreateDate() != null) {
                    request.add(new HTTPGateway.HttpHeader(this, "si_created", this.formatDateUTC(((OutboundWapSIMessage)msg).getCreateDate()), false));
                }
                if (((OutboundWapSIMessage)msg).getExpireDate() != null) {
                    request.add(new HTTPGateway.HttpHeader(this, "si_expires", this.formatDateUTC(((OutboundWapSIMessage)msg).getExpireDate()), false));
                }
                request.add(new HTTPGateway.HttpHeader(this, "si_action", this.formatSignal(((OutboundWapSIMessage)msg).getSignal()), false));
                request.add(new HTTPGateway.HttpHeader(this, "si_url", ((OutboundWapSIMessage)msg).getUrl().toString(), false));
                request.add(new HTTPGateway.HttpHeader(this, "si_text", ((OutboundWapSIMessage)msg).getIndicationText(), false));
            }
            if (msg.getStatusReport()) {
                request.add(new HTTPGateway.HttpHeader(this, "deliv_ack", "1", false));
            }
            if (this.getFrom() != null && this.getFrom().length() != 0 || msg.getFrom() != null && msg.getFrom().length() != 0) {
                requestFeatures += 48;
            }
            if (msg.getFlashSms()) {
                requestFeatures += 512;
            }
            if (msg.getStatusReport()) {
                requestFeatures += 8192;
            }
            request.add(new HTTPGateway.HttpHeader(this, "req_feat", "" + requestFeatures, false));
            Object object = this.SYNC_Commander;
            synchronized (object) {
                response = this.HttpPost(url, request);
            }
            if (response.get(0).indexOf("ID:") == 0) {
                msg.setRefNo(response.get(0).substring(4));
                msg.setDispatchDate(new Date());
                msg.setGatewayId(this.getGatewayId());
                msg.setMessageStatus(OutboundMessage.MessageStatuses.SENT);
                this.incOutboundMessageCount();
                ok = true;
            } else if (response.get(0).indexOf("ERR:") == 0) {
                switch (Integer.parseInt(response.get(0).substring(5, 8))) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: {
                        msg.setFailureCause(OutboundMessage.FailureCauses.GATEWAY_AUTH);
                        break;
                    }
                    case 101: 
                    case 102: 
                    case 105: 
                    case 106: 
                    case 107: 
                    case 112: 
                    case 116: 
                    case 120: {
                        msg.setFailureCause(OutboundMessage.FailureCauses.BAD_FORMAT);
                        break;
                    }
                    case 114: {
                        msg.setFailureCause(OutboundMessage.FailureCauses.NO_ROUTE);
                        break;
                    }
                    case 301: 
                    case 302: {
                        msg.setFailureCause(OutboundMessage.FailureCauses.NO_CREDIT);
                        break;
                    }
                    default: {
                        msg.setFailureCause(OutboundMessage.FailureCauses.UNKNOWN);
                    }
                }
                msg.setRefNo(null);
                msg.setDispatchDate(null);
                msg.setMessageStatus(OutboundMessage.MessageStatuses.FAILED);
                ok = false;
            }
        }
        catch (MalformedURLException e) {
            this.getService().getLogger().logError("Malformed URL.", e, this.getGatewayId());
        }
        catch (IOException e) {
            this.getService().getLogger().logError("I/O error.", e, this.getGatewayId());
        }
        return ok;
    }

    String formatDateUTC(Date d) {
        String strDate = "";
        String tmp = "";
        Calendar cal = Calendar.getInstance();
        cal.setTime(d);
        strDate = String.valueOf(cal.get(1));
        tmp = String.valueOf(cal.get(2) + 1);
        if (tmp.length() != 2) {
            tmp = "0" + tmp;
        }
        strDate = strDate + "-" + tmp;
        tmp = String.valueOf(cal.get(5));
        if (tmp.length() != 2) {
            tmp = "0" + tmp;
        }
        strDate = strDate + "-" + tmp;
        tmp = String.valueOf(cal.get(11));
        if (tmp.length() != 2) {
            tmp = "0" + tmp;
        }
        strDate = strDate + "T" + tmp;
        tmp = String.valueOf(cal.get(12));
        if (tmp.length() != 2) {
            tmp = "0" + tmp;
        }
        strDate = strDate + ":" + tmp;
        tmp = String.valueOf(cal.get(13));
        if (tmp.length() != 2) {
            tmp = "0" + tmp;
        }
        strDate = strDate + ":" + tmp + "Z";
        return strDate;
    }

    String formatSignal(OutboundWapSIMessage.WapSISignals signal) {
        if (signal == OutboundWapSIMessage.WapSISignals.NONE) {
            return "signal-none";
        }
        if (signal == OutboundWapSIMessage.WapSISignals.LOW) {
            return "signal-low";
        }
        if (signal == OutboundWapSIMessage.WapSISignals.MEDIUM) {
            return "signal-medium";
        }
        if (signal == OutboundWapSIMessage.WapSISignals.HIGH) {
            return "signal-high";
        }
        if (signal == OutboundWapSIMessage.WapSISignals.DELETE) {
            return "signal-delete";
        }
        return "signal-none";
    }

    KeepAlive getKeepAlive() {
        return this.keepAlive;
    }

    void setKeepAlive(KeepAlive keepAlive) {
        this.keepAlive = keepAlive;
    }

    class KeepAlive
    extends AServiceThread {
        public KeepAlive(String name, Service service, int delay) {
            super(name, service, delay, 0, true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void process() throws Exception {
            if (ClickatellHTTPGateway.this.sessionId == null) {
                return;
            }
            Object object = ClickatellHTTPGateway.this.SYNC_Commander;
            synchronized (object) {
                ClickatellHTTPGateway.this.ping();
            }
        }
    }
}

