/*
 * Decompiled with CFR 0.152.
 */
package org.smslib.http;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.StringTokenizer;
import org.smslib.GatewayException;
import org.smslib.OutboundMessage;
import org.smslib.StatusReportMessage;
import org.smslib.TimeoutException;
import org.smslib.http.HTTPGateway;

public class BulkSmsHTTPGateway
extends HTTPGateway {
    String providerUrl = "http://bulksms.vsms.net:5567";
    String username;
    String password;
    Object SYNC_Commander;

    public BulkSmsHTTPGateway(String id, String myUsername, String myPassword) {
        super(id);
        this.setRegion(Regions.INTERNATIONAL);
        this.username = myUsername;
        this.password = myPassword;
        this.SYNC_Commander = new Object();
        this.setAttributes(77);
    }

    public BulkSmsHTTPGateway(String id, String myUsername, String myPassword, Regions region) {
        this(id, myUsername, myPassword);
        this.setRegion(region);
    }

    public void startGateway() throws TimeoutException, GatewayException, IOException, InterruptedException {
        this.getService().getLogger().logInfo("Starting gateway.", null, this.getGatewayId());
        super.startGateway();
    }

    public void stopGateway() throws TimeoutException, GatewayException, IOException, InterruptedException {
        this.getService().getLogger().logInfo("Stopping gateway.", null, this.getGatewayId());
        super.stopGateway();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float queryBalance() throws TimeoutException, GatewayException, IOException, InterruptedException {
        List<String> response;
        ArrayList<HTTPGateway.HttpHeader> request = new ArrayList<HTTPGateway.HttpHeader>();
        request.add(new HTTPGateway.HttpHeader(this, "username", this.username, false));
        request.add(new HTTPGateway.HttpHeader(this, "password", this.password, false));
        String reqLine = this.ExpandHttpHeaders(request);
        URL url = new URL(this.providerUrl + "/eapi/user/get_credits/1/1.1" + "?" + reqLine);
        Object object = this.SYNC_Commander;
        synchronized (object) {
            response = this.HttpGet(url);
        }
        if (response.get(0).charAt(0) == '0') {
            return Float.parseFloat(response.get(0).substring(response.get(0).indexOf(124) + 1));
        }
        return -1.0f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StatusReportMessage.DeliveryStatuses queryMessage(String refNo) throws TimeoutException, GatewayException, IOException, InterruptedException {
        List<String> response;
        ArrayList<HTTPGateway.HttpHeader> request = new ArrayList<HTTPGateway.HttpHeader>();
        request.add(new HTTPGateway.HttpHeader(this, "username", this.username, false));
        request.add(new HTTPGateway.HttpHeader(this, "password", this.password, false));
        request.add(new HTTPGateway.HttpHeader(this, "batch_id", refNo, false));
        String reqLine = this.ExpandHttpHeaders(request);
        URL url = new URL(this.providerUrl + "/eapi/status_reports/get_report/2/2.0" + "?" + reqLine);
        Object object = this.SYNC_Commander;
        synchronized (object) {
            response = this.HttpGet(url);
        }
        if (response.get(0).indexOf("0|Results to follow") == 0) {
            StringTokenizer tokens = new StringTokenizer(response.get(2), ":");
            tokens.nextToken();
            this.setDeliveryErrorCode(Integer.parseInt(tokens.nextToken()));
            switch (this.getDeliveryErrorCode()) {
                case 11: {
                    return StatusReportMessage.DeliveryStatuses.DELIVERED;
                }
                case 0: 
                case 10: 
                case 12: 
                case 63: 
                case 64: {
                    return StatusReportMessage.DeliveryStatuses.KEEPTRYING;
                }
            }
            return StatusReportMessage.DeliveryStatuses.ABORTED;
        }
        return StatusReportMessage.DeliveryStatuses.UNKNOWN;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean sendMessage(OutboundMessage msg) throws TimeoutException, GatewayException, IOException, InterruptedException {
        StringTokenizer tokens;
        List<String> response;
        URL url = null;
        ArrayList<HTTPGateway.HttpHeader> request = new ArrayList<HTTPGateway.HttpHeader>();
        boolean ok = false;
        request.add(new HTTPGateway.HttpHeader(this, "username", this.username, false));
        request.add(new HTTPGateway.HttpHeader(this, "password", this.password, false));
        request.add(new HTTPGateway.HttpHeader(this, "message", msg.getText(), false));
        request.add(new HTTPGateway.HttpHeader(this, "msisdn", msg.getRecipient().substring(1), false));
        request.add(new HTTPGateway.HttpHeader(this, "allow_concat_text_sms", "1", false));
        if (msg.getStatusReport()) {
            request.add(new HTTPGateway.HttpHeader(this, "want_report", "1", false));
        }
        if (msg.getFlashSms()) {
            request.add(new HTTPGateway.HttpHeader(this, "msg_class", "0", false));
        }
        if (msg.getFrom() != null && msg.getFrom().length() != 0) {
            request.add(new HTTPGateway.HttpHeader(this, "source_id", msg.getFrom(), false));
        } else if (this.getFrom() != null && this.getFrom().length() != 0) {
            request.add(new HTTPGateway.HttpHeader(this, "source_id", this.getFrom(), false));
        }
        String reqLine = this.ExpandHttpHeaders(request);
        url = new URL(this.providerUrl + "/eapi/submission/send_sms/2/2.0" + "?" + reqLine);
        Object object = this.SYNC_Commander;
        synchronized (object) {
            response = this.HttpGet(url);
        }
        if (response.get(0).charAt(0) == '0') {
            tokens = new StringTokenizer(response.get(0), "|");
            tokens.nextToken();
            tokens.nextToken();
            msg.setRefNo(tokens.nextToken());
            msg.setDispatchDate(new Date());
            msg.setGatewayId(this.getGatewayId());
            msg.setMessageStatus(OutboundMessage.MessageStatuses.SENT);
            this.incOutboundMessageCount();
            ok = true;
        } else {
            tokens = new StringTokenizer(response.get(0), "|");
            switch (Integer.parseInt(tokens.nextToken())) {
                case 22: {
                    msg.setFailureCause(OutboundMessage.FailureCauses.GATEWAY_FAILURE);
                    break;
                }
                case 23: {
                    msg.setFailureCause(OutboundMessage.FailureCauses.GATEWAY_AUTH);
                    break;
                }
                case 24: {
                    msg.setFailureCause(OutboundMessage.FailureCauses.BAD_FORMAT);
                    break;
                }
                case 25: 
                case 26: 
                case 27: 
                case 28: {
                    msg.setFailureCause(OutboundMessage.FailureCauses.NO_CREDIT);
                    break;
                }
                case 40: {
                    msg.setFailureCause(OutboundMessage.FailureCauses.GATEWAY_FAILURE);
                }
            }
            msg.setRefNo(null);
            msg.setDispatchDate(null);
            msg.setMessageStatus(OutboundMessage.MessageStatuses.FAILED);
            ok = false;
        }
        return ok;
    }

    void setRegion(Regions r) {
        switch (r) {
            case INTERNATIONAL: {
                this.providerUrl = "http://bulksms.vsms.net:5567";
                break;
            }
            case UNITEDKINGDOM: {
                this.providerUrl = "http://www.bulksms.co.uk:5567";
                break;
            }
            case SOUTHAFRICA: {
                this.providerUrl = "http://bulksms.2way.co.za:5567";
                break;
            }
            case SPAIN: {
                this.providerUrl = "http://bulksms.com.es:5567";
                break;
            }
            case USA: {
                this.providerUrl = "http://usa.bulksms.com:5567";
                break;
            }
            case GERMANY: {
                this.providerUrl = "http://bulksms.de:5567";
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Regions {
        INTERNATIONAL,
        UNITEDKINGDOM,
        SOUTHAFRICA,
        SPAIN,
        USA,
        GERMANY;

    }
}

