/*
 * Decompiled with CFR 0.152.
 */
package org.smslib.helper;

import org.slf4j.LoggerFactory;
import org.smslib.Settings;

public class Logger {
    org.slf4j.Logger logger;
    private Settings S;

    public Logger(Settings myS) {
        this.setSettings(myS);
        this.logger = LoggerFactory.getLogger((String)"smslib");
    }

    public Logger(org.slf4j.Logger myLogger) {
        this.logger = myLogger;
    }

    public org.slf4j.Logger getLogger() {
        return this.logger;
    }

    public void logInfo(String message, Exception e, String gatewayId) {
        if (e == null) {
            this.getLogger().info(this.formatMessage(message, gatewayId));
        } else {
            this.getLogger().info(this.formatMessage(message, gatewayId), (Throwable)e);
        }
    }

    public void logWarn(String message, Exception e, String gatewayId) {
        if (e == null) {
            this.getLogger().warn(this.formatMessage(message, gatewayId));
        } else {
            this.getLogger().warn(this.formatMessage(message, gatewayId), (Throwable)e);
        }
    }

    public void logDebug(String message, Exception e, String gatewayId) {
        if (e == null) {
            this.getLogger().debug(this.formatMessage(message, gatewayId));
        } else {
            this.getLogger().debug(this.formatMessage(message, gatewayId), (Throwable)e);
        }
    }

    public void logError(String message, Exception e, String gatewayId) {
        if (e == null) {
            this.getLogger().error(this.formatMessage(message, gatewayId));
        } else {
            this.getLogger().error(this.formatMessage(message, gatewayId), (Throwable)e);
        }
    }

    private String formatMessage(String message, String gatewayId) {
        return gatewayId == null ? message : "GTW: " + gatewayId + ": " + message;
    }

    Settings getSettings() {
        return this.S;
    }

    void setSettings(Settings myS) {
        this.S = myS;
    }
}

