/*
 * Decompiled with CFR 0.152.
 */
package org.smslib;

import java.util.ArrayList;
import java.util.List;
import org.smslib.USSDDatagram;
import org.smslib.USSDRequest;
import org.smslib.USSDResponse;
import org.smslib.USSDSessionStatus;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class USSDSession {
    private List<USSDDatagram> datagrams = new ArrayList<USSDDatagram>();
    private USSDSessionStatus sessionStatus;
    private String gtwId;

    public USSDSession() {
        this.gtwId = null;
    }

    public USSDSession(USSDDatagram initialDatagram, String aGtwId) throws IllegalArgumentException {
        if (!this.isGatewaySet(initialDatagram)) {
            initialDatagram.setGatewayId(aGtwId);
        }
        this.datagrams.add(initialDatagram);
    }

    public USSDSession(USSDDatagram initialDatagram) throws IllegalArgumentException {
        this.gtwId = this.isGatewaySet(initialDatagram) ? initialDatagram.getGatewayId() : null;
        this.datagrams.add(initialDatagram);
    }

    public USSDSession(String aGtwId) {
        this.gtwId = aGtwId;
    }

    public USSDResponse sendRequest(USSDRequest aRequest) {
        return null;
    }

    public String getGatewayId() {
        return this.gtwId;
    }

    public void setGatewayId(String aGtwId) {
        this.gtwId = aGtwId;
    }

    public List<USSDDatagram> getDatagrams() {
        return this.datagrams;
    }

    public void setDatagrams(List<USSDDatagram> aDatagramList) {
        this.datagrams = aDatagramList;
    }

    public USSDSessionStatus getSessionStatus() {
        return this.sessionStatus;
    }

    public void setSessionStatus(USSDSessionStatus aStatus) {
        this.sessionStatus = aStatus;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("Session status: ");
        buf.append((Object)this.sessionStatus).append("\n");
        buf.append("Datagrams:\n");
        for (USSDDatagram dgram : this.datagrams) {
            buf.append("\t").append(dgram.toString());
            buf.append("\n");
        }
        return buf.toString();
    }

    private boolean isGatewaySet(USSDDatagram dgram) {
        return !"".equals(dgram.getGatewayId()) && !"*".equals(dgram.getGatewayId());
    }
}

