/*
 * Decompiled with CFR 0.152.
 */
package org.smslib;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.smslib.InvalidMessageException;
import org.smslib.USSDDatagram;
import org.smslib.USSDDcs;
import org.smslib.USSDSessionStatus;

public class USSDResponse
extends USSDDatagram {
    private static final Pattern MSG_PATTERN = Pattern.compile("(?s)^\\+CUSD:\\s+(\\d)(?:,\\s*\"([^\"]*))?(?:\",\\s*(\\d+)\\s*)?\"?\r?$");
    private static final int STATUS_INDEX = 1;
    private static final int CONTENT_INDEX = 2;
    private static final int ENCODING_INDEX = 3;
    private String rawResponse;
    private USSDSessionStatus sessionStatus;

    public USSDResponse() {
        this.rawResponse = null;
        this.sessionStatus = null;
    }

    public USSDResponse(String rawResp, String gtwId) throws InvalidMessageException {
        Matcher matcher = MSG_PATTERN.matcher(rawResp);
        if (!matcher.matches()) {
            throw new InvalidMessageException("Not a well-formed +CUSD response: |" + rawResp + "|");
        }
        try {
            this.setGatewayId(gtwId);
            this.rawResponse = rawResp;
            this.sessionStatus = USSDSessionStatus.getByNumeric(Integer.valueOf(matcher.group(1)));
            if (matcher.groupCount() >= 2 && matcher.group(2) != null) {
                this.setContent(matcher.group(2));
            }
            if (matcher.groupCount() >= 3 && matcher.group(3) != null) {
                this.setDcs(USSDDcs.getByNumeric(Integer.valueOf(matcher.group(3))));
            }
        }
        catch (Exception e) {
            throw new InvalidMessageException("Session status: " + matcher.group(1) + "; DCS: " + matcher.group(3));
        }
    }

    public String getRawResponse() {
        return this.rawResponse;
    }

    public void setRawResponse(String aRawResponse) {
        this.rawResponse = aRawResponse;
    }

    public USSDSessionStatus getSessionStatus() {
        return this.sessionStatus;
    }

    public void setUSSDSessionStatus(USSDSessionStatus aUSSDSessionStatus) {
        this.sessionStatus = aUSSDSessionStatus;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("Gateway: ");
        buf.append(this.getGatewayId());
        buf.append("\n");
        buf.append("Session status: ");
        buf.append((Object)this.sessionStatus);
        buf.append("\n");
        buf.append("Data coding scheme: ");
        buf.append(this.getDcs() != null ? this.getDcs() : "Unspecified");
        buf.append("\n");
        buf.append("Content: ");
        buf.append(this.getContent() != null ? this.getContent() : "(EMPTY)");
        return buf.toString();
    }
}

