/*
 * Decompiled with CFR 0.152.
 */
package org.smslib;

import org.smslib.USSDDatagram;
import org.smslib.USSDDcs;
import org.smslib.USSDResultPresentation;

public class USSDRequest
extends USSDDatagram {
    private USSDResultPresentation presentation;

    public USSDRequest() {
        this.presentation = null;
    }

    public USSDRequest(USSDResultPresentation aPresentation, String aContent, USSDDcs aDcs, String aGatewayId) throws IllegalArgumentException {
        this.presentation = aPresentation;
        this.setContent(aContent);
        this.setDcs(aDcs);
        this.setGatewayId(aGatewayId);
    }

    public USSDRequest(String aContent) {
        this.presentation = USSDResultPresentation.PRESENTATION_ENABLED;
        this.setContent(aContent);
        this.setDcs(USSDDcs.UNSPECIFIED_7BIT);
    }

    public String getRawRequest() {
        StringBuffer buf = new StringBuffer();
        buf.append("AT+CUSD=");
        buf.append(this.presentation.getNumeric());
        buf.append(",");
        buf.append("\"");
        buf.append(this.getContent());
        buf.append("\"");
        buf.append(",");
        buf.append(this.getDcs().getNumeric());
        buf.append("\r");
        return buf.toString();
    }

    public void setUSSDResultPresentation(USSDResultPresentation aResultPresentation) {
        this.presentation = aResultPresentation;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("Gateway: ");
        buf.append(this.getGatewayId());
        buf.append("\n");
        buf.append("Result presentation: ");
        buf.append((Object)this.presentation);
        buf.append("\n");
        buf.append("Data coding scheme: ");
        buf.append((Object)this.getDcs());
        buf.append("\n");
        buf.append("Content: ");
        buf.append(this.getContent() != null ? this.getContent() : "(EMPTY)");
        return buf.toString();
    }
}

