/*
 * Decompiled with CFR 0.152.
 */
package org.smslib;

import java.util.Date;
import org.ajwcc.pduUtils.gsm3040.SmsStatusReportPdu;
import org.smslib.InboundMessage;
import org.smslib.Message;

public class StatusReportMessage
extends InboundMessage {
    private static final long serialVersionUID = -1219480715074817278L;
    private String recipient;
    private Date sent;
    private Date received;
    private DeliveryStatuses status;
    private String refNo;

    public StatusReportMessage(SmsStatusReportPdu pdu, int memIndex, String memLocation) {
        super(Message.MessageTypes.STATUSREPORT, memIndex, memLocation);
        this.refNo = String.valueOf(pdu.getMessageReference());
        this.recipient = pdu.getAddress();
        this.sent = pdu.getTimestamp();
        this.received = pdu.getDischargeTime();
        int i = pdu.getStatus();
        if ((i & 0x60) == 0) {
            this.setText("00 - Succesful Delivery.");
            this.status = DeliveryStatuses.DELIVERED;
        }
        if ((i & 0x20) == 32) {
            this.setText("01 - Errors, will retry dispatch.");
            this.status = DeliveryStatuses.KEEPTRYING;
        }
        if ((i & 0x40) == 64) {
            this.setText("02 - Errors, stopped retrying dispatch.");
            this.status = DeliveryStatuses.ABORTED;
        }
        if ((i & 0x60) == 96) {
            this.setText("03 - Errors, stopped retrying dispatch.");
            this.status = DeliveryStatuses.ABORTED;
        }
        this.setDate(null);
    }

    public StatusReportMessage(String myRefNo, int memIndex, String memLocation, Date dateOriginal, Date dateReceived) {
        super(Message.MessageTypes.STATUSREPORT, memIndex, memLocation);
        this.refNo = myRefNo;
        this.sent = dateOriginal;
        this.received = dateReceived;
        this.setText("");
        this.status = DeliveryStatuses.UNKNOWN;
        this.setDate(null);
    }

    public String getRecipient() {
        return this.recipient;
    }

    public Date getReceived() {
        return new Date(this.received.getTime());
    }

    public void setReceived(Date myReceived) {
        this.received = myReceived;
    }

    public Date getSent() {
        return new Date(this.sent.getTime());
    }

    public void setSent(Date mySent) {
        this.sent = mySent;
    }

    public DeliveryStatuses getStatus() {
        return this.status;
    }

    public void setStatus(DeliveryStatuses myStatus) {
        this.status = myStatus;
    }

    public String getRefNo() {
        return this.refNo;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DeliveryStatuses {
        UNKNOWN,
        DELIVERED,
        KEEPTRYING,
        ABORTED;

    }
}

