/*
 * Decompiled with CFR 0.152.
 */
package org.smslib;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.smslib.AGateway;
import org.smslib.GatewayException;
import org.smslib.Group;
import org.smslib.ICallNotification;
import org.smslib.IGatewayStatusNotification;
import org.smslib.IInboundMessageNotification;
import org.smslib.IOutboundMessageNotification;
import org.smslib.IQueueSendingNotification;
import org.smslib.IUSSDNotification;
import org.smslib.InboundMessage;
import org.smslib.Library;
import org.smslib.OutboundMessage;
import org.smslib.Phonebook;
import org.smslib.SMSLibException;
import org.smslib.Settings;
import org.smslib.TimeoutException;
import org.smslib.USSDRequest;
import org.smslib.balancing.LoadBalancer;
import org.smslib.balancing.RoundRobinLoadBalancer;
import org.smslib.crypto.KeyManager;
import org.smslib.helper.Logger;
import org.smslib.queues.QueueManager;
import org.smslib.routing.Router;
import org.smslib.threading.AServiceThread;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Service {
    private Logger logger;
    private List<AGateway> gatewayList;
    private Router router;
    private LoadBalancer loadBalancer;
    private WatchDog watchDog;
    private IInboundMessageNotification inboundNotification;
    private IOutboundMessageNotification outboundNotification;
    private ICallNotification callNotification;
    private IGatewayStatusNotification gatewayStatusNotification;
    private IQueueSendingNotification queueSendingNotification;
    protected QueueManager queueManager;
    private long startMillis;
    private Collection<Group> groups;
    private volatile ServiceStatus serviceStatus;
    private KeyManager keyManager;
    private Settings S;
    private IUSSDNotification ussdNotification;

    public Service() {
        this.setSettings(new Settings());
        this.logger = new Logger(this.getSettings());
        this.initializeService();
    }

    public Service(org.slf4j.Logger logger) {
        this.setSettings(new Settings());
        this.logger = new Logger(logger);
        this.initializeService();
    }

    protected void initializeService() {
        this.startMillis = System.currentTimeMillis();
        this.setServiceStatus(ServiceStatus.STOPPED);
        this.groups = new ArrayList<Group>();
        this.listSystemInformation();
        this.gatewayList = new ArrayList<AGateway>();
        this.keyManager = KeyManager.getInstance();
        this.setRouter(new Router(this));
        this.setLoadBalancer(new RoundRobinLoadBalancer(this));
        this.setQueueManager(new QueueManager(this));
    }

    private void listSystemInformation() {
        this.getLogger().logInfo(Library.getLibraryDescription(), null, null);
        this.getLogger().logInfo("Version: " + Library.getLibraryVersion(), null, null);
        this.getLogger().logInfo("JRE Version: " + System.getProperty("java.version"), null, null);
        this.getLogger().logInfo("JRE Impl Version: " + System.getProperty("java.vm.version"), null, null);
        this.getLogger().logInfo("O/S: " + System.getProperty("os.name") + " / " + System.getProperty("os.arch") + " / " + System.getProperty("os.version"), null, null);
    }

    public Logger getLogger() {
        return this.logger;
    }

    public void addGateway(AGateway gateway) throws GatewayException {
        if (this.getServiceStatus() != ServiceStatus.STOPPED) {
            throw new GatewayException("Cannot add gateways while Service is running!");
        }
        gateway.setService(this);
        this.getGateways().add(gateway);
    }

    public boolean removeGateway(AGateway gateway) throws GatewayException {
        if (this.getServiceStatus() != ServiceStatus.STOPPED) {
            throw new GatewayException("Cannot remove gateways while Service is running!");
        }
        return this.getGateways().remove(gateway);
    }

    public synchronized void startService() throws SMSLibException, TimeoutException, GatewayException, IOException, InterruptedException {
        try {
            this.setServiceStatus(ServiceStatus.STARTING);
            this.setWatchDog(new WatchDog("WatchDog", this, this.getSettings().WATCHDOG_INTERVAL * 1000));
            this.startService(true);
            this.setServiceStatus(ServiceStatus.STARTED);
        }
        catch (SMSLibException e) {
            this.stopService();
            throw e;
        }
        catch (IOException e) {
            this.stopService();
            throw e;
        }
        catch (InterruptedException e) {
            this.stopService();
            throw e;
        }
    }

    void startService(boolean startAll) throws SMSLibException, TimeoutException, GatewayException, IOException, InterruptedException {
        if (this.getSettings().CONCURRENT_GATEWAY_START) {
            class ExceptionPair {
                public Throwable e;
                public AGateway src;

                ExceptionPair() {
                }
            }
            LinkedList<ExceptionPair> eList = new LinkedList<ExceptionPair>();
            LinkedList<AGateway> gList = new LinkedList<AGateway>();
            if (this.getGateways().size() == 0) {
                throw new SMSLibException("No gateways are defined.");
            }
            for (AGateway gateway : this.getGateways()) {
                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                class Starter
                extends Thread {
                    AGateway gateway;
                    List<ExceptionPair> eList;
                    List<AGateway> gList;

                    public Starter(AGateway gateway, List<ExceptionPair> eList, List<AGateway> gList) {
                        this.gateway = gateway;
                        this.eList = eList;
                        this.gList = gList;
                    }

                    @Override
                    public void run() {
                        try {
                            this.gateway.startGateway();
                            this.gList.add(this.gateway);
                        }
                        catch (Exception e) {
                            ExceptionPair exc = new ExceptionPair();
                            exc.e = e;
                            exc.src = this.gateway;
                            this.eList.add(exc);
                        }
                    }
                }
                new Starter(gateway, eList, gList).start();
            }
            while (gList.size() != this.getGateways().size() && eList.size() == 0) {
                Thread.sleep(1000L);
            }
            for (ExceptionPair e : eList) {
                e.src.setStatus(AGateway.GatewayStatuses.RESTART);
            }
            if (startAll) {
                if (eList.size() != 0) {
                    ExceptionPair e = (ExceptionPair)eList.get(0);
                    if (e.e instanceof TimeoutException) {
                        throw (TimeoutException)e.e;
                    }
                    if (e.e instanceof GatewayException) {
                        throw (GatewayException)e.e;
                    }
                    if (e.e instanceof SMSLibException) {
                        throw (SMSLibException)e.e;
                    }
                    if (e.e instanceof IOException) {
                        throw (IOException)e.e;
                    }
                    if (e.e instanceof InterruptedException) {
                        throw (InterruptedException)e.e;
                    }
                } else {
                    eList.clear();
                    gList.clear();
                }
            }
        } else {
            if (this.getGateways().size() == 0) {
                throw new SMSLibException("No gateways are defined.");
            }
            for (AGateway gateway : this.getGateways()) {
                gateway.startGateway();
            }
        }
    }

    public synchronized void stopService() {
        this.setServiceStatus(ServiceStatus.STOPPING);
        if (this.getWatchDog() != null) {
            this.getWatchDog().cancel();
            this.setWatchDog(null);
        }
        for (AGateway gateway : this.getGateways()) {
            try {
                gateway.stopGateway();
            }
            catch (Exception exception) {}
        }
        this.setServiceStatus(ServiceStatus.STOPPED);
    }

    public int readMessages(Collection<InboundMessage> msgList, InboundMessage.MessageClasses msgClass) throws TimeoutException, GatewayException, IOException, InterruptedException {
        if (this.getServiceStatus() != ServiceStatus.STARTED) {
            return 0;
        }
        for (AGateway gateway : this.getGateways()) {
            if (!gateway.isInbound()) continue;
            try {
                this.readMessages(msgList, msgClass, gateway);
            }
            catch (TimeoutException e) {
                this.getLogger().logWarn("readMessages(): Gateway " + gateway.getGatewayId() + " does not respond, marking for restart.", null, null);
                gateway.setStatus(AGateway.GatewayStatuses.RESTART);
            }
            catch (IOException e) {
                this.getLogger().logWarn("readMessages(): Gateway " + gateway.getGatewayId() + " throws IO errors, marking for restart.", null, null);
                gateway.setStatus(AGateway.GatewayStatuses.RESTART);
            }
        }
        return msgList.size();
    }

    public InboundMessage[] readMessages(InboundMessage.MessageClasses msgClass) throws TimeoutException, GatewayException, IOException, InterruptedException {
        ArrayList<InboundMessage> messageList = new ArrayList<InboundMessage>();
        this.readMessages(messageList, msgClass);
        return messageList.toArray(new InboundMessage[0]);
    }

    public int readMessages(Collection<InboundMessage> msgList, InboundMessage.MessageClasses msgClass, String gatewayId) throws TimeoutException, GatewayException, IOException, InterruptedException {
        if (this.getServiceStatus() != ServiceStatus.STARTED) {
            return 0;
        }
        AGateway gateway = this.findGateway(gatewayId);
        if (gateway != null && gateway.isInbound()) {
            try {
                this.readMessages(msgList, msgClass, gateway);
            }
            catch (TimeoutException e) {
                this.getLogger().logWarn("readMessages(): Gateway " + gateway.getGatewayId() + " does not respond, marking for restart.", null, null);
                gateway.setStatus(AGateway.GatewayStatuses.RESTART);
            }
            catch (IOException e) {
                this.getLogger().logWarn("readMessages(): Gateway " + gateway.getGatewayId() + " throws IO errors, marking for restart.", null, null);
                gateway.setStatus(AGateway.GatewayStatuses.RESTART);
            }
        }
        return msgList.size();
    }

    public InboundMessage[] readMessages(InboundMessage.MessageClasses msgClass, String gatewayId) throws TimeoutException, GatewayException, IOException, InterruptedException {
        ArrayList<InboundMessage> messageList = new ArrayList<InboundMessage>();
        this.readMessages(messageList, msgClass, gatewayId);
        return messageList.toArray(new InboundMessage[0]);
    }

    public int readMessages(Collection<InboundMessage> msgList, InboundMessage.MessageClasses msgClass, AGateway gateway) throws TimeoutException, GatewayException, IOException, InterruptedException {
        if (this.getServiceStatus() != ServiceStatus.STARTED) {
            return 0;
        }
        try {
            gateway.readMessages(msgList, msgClass);
        }
        catch (TimeoutException e) {
            this.getLogger().logWarn("readMessages(): Gateway " + gateway.getGatewayId() + " does not respond, marking for restart.", null, null);
            gateway.setStatus(AGateway.GatewayStatuses.RESTART);
        }
        catch (IOException e) {
            this.getLogger().logWarn("readMessages(): Gateway " + gateway.getGatewayId() + " throws IO errors, marking for restart.", null, null);
            gateway.setStatus(AGateway.GatewayStatuses.RESTART);
        }
        return msgList.size();
    }

    public InboundMessage[] readMessages(InboundMessage.MessageClasses msgClass, AGateway gateway) throws TimeoutException, GatewayException, IOException, InterruptedException {
        ArrayList<InboundMessage> messageList = new ArrayList<InboundMessage>();
        this.readMessages(messageList, msgClass, gateway);
        return messageList.toArray(new InboundMessage[0]);
    }

    public InboundMessage readMessage(String gatewayId, String memLoc, int memIndex) throws TimeoutException, GatewayException, IOException, InterruptedException {
        if (this.getServiceStatus() != ServiceStatus.STARTED) {
            return null;
        }
        InboundMessage msg = null;
        AGateway gateway = this.findGateway(gatewayId);
        if (gateway != null && gateway.isInbound()) {
            try {
                msg = gateway.readMessage(memLoc, memIndex);
            }
            catch (TimeoutException e) {
                this.getLogger().logWarn("readMessages(): Gateway " + gateway.getGatewayId() + " does not respond, marking for restart.", null, null);
                gateway.setStatus(AGateway.GatewayStatuses.RESTART);
            }
            catch (IOException e) {
                this.getLogger().logWarn("readMessages(): Gateway " + gateway.getGatewayId() + " throws IO errors, marking for restart.", null, null);
                gateway.setStatus(AGateway.GatewayStatuses.RESTART);
            }
        }
        return msg;
    }

    public boolean sendMessage(OutboundMessage msg) throws TimeoutException, GatewayException, IOException, InterruptedException {
        if (this.getServiceStatus() != ServiceStatus.STARTED) {
            return false;
        }
        AGateway gateway = this.routeMessage(msg);
        if (gateway != null) {
            try {
                ArrayList<String> recipients = this.expandGroup(msg.getRecipient());
                if (recipients.size() == 0) {
                    return gateway.sendMessage(msg);
                }
                ArrayList<OutboundMessage> groupMessages = new ArrayList<OutboundMessage>();
                for (String to : recipients) {
                    OutboundMessage newMessage = new OutboundMessage();
                    msg.copyTo(newMessage);
                    newMessage.setRecipient(to);
                    groupMessages.add(newMessage);
                }
                this.sendMessages(groupMessages);
                return true;
            }
            catch (TimeoutException e) {
                this.getLogger().logWarn("sendMessage(): Gateway " + gateway.getGatewayId() + " does not respond, marking for restart.", null, null);
                gateway.setStatus(AGateway.GatewayStatuses.RESTART);
                msg.setMessageStatus(OutboundMessage.MessageStatuses.FAILED);
                msg.setFailureCause(OutboundMessage.FailureCauses.GATEWAY_FAILURE);
                return false;
            }
            catch (IOException e) {
                this.getLogger().logWarn("sendMessage(): Gateway " + gateway.getGatewayId() + " throws IO errors, marking for restart.", null, null);
                gateway.setStatus(AGateway.GatewayStatuses.RESTART);
                msg.setMessageStatus(OutboundMessage.MessageStatuses.FAILED);
                msg.setFailureCause(OutboundMessage.FailureCauses.GATEWAY_FAILURE);
                return false;
            }
        }
        return false;
    }

    public boolean sendMessage(OutboundMessage msg, String gatewayId) throws TimeoutException, GatewayException, IOException, InterruptedException {
        if (this.getServiceStatus() != ServiceStatus.STARTED) {
            return false;
        }
        msg.setGatewayId(gatewayId);
        return this.sendMessage(msg);
    }

    public int sendMessages(Collection<OutboundMessage> msgList) throws TimeoutException, GatewayException, IOException, InterruptedException {
        if (this.getServiceStatus() != ServiceStatus.STARTED) {
            return 0;
        }
        int counter = 0;
        for (OutboundMessage msg : msgList) {
            if (!this.sendMessage(msg)) continue;
            ++counter;
        }
        return counter;
    }

    public int sendMessages(OutboundMessage[] msgArray) throws TimeoutException, GatewayException, IOException, InterruptedException {
        int counter = 0;
        for (int i = 0; i < msgArray.length; ++i) {
            if (!this.sendMessage(msgArray[i])) continue;
            ++counter;
        }
        return counter;
    }

    public int sendMessages(Collection<OutboundMessage> msgList, String gatewayId) throws TimeoutException, GatewayException, IOException, InterruptedException {
        if (this.getServiceStatus() != ServiceStatus.STARTED) {
            return 0;
        }
        int counter = 0;
        for (OutboundMessage msg : msgList) {
            msg.setGatewayId(gatewayId);
            if (!this.sendMessage(msg)) continue;
            ++counter;
        }
        return counter;
    }

    public int sendMessages(OutboundMessage[] msgArray, String gatewayId) throws TimeoutException, GatewayException, IOException, InterruptedException {
        int counter = 0;
        for (int i = 0; i < msgArray.length; ++i) {
            msgArray[i].setGatewayId(gatewayId);
            if (!this.sendMessage(msgArray[i])) continue;
            ++counter;
        }
        return counter;
    }

    public boolean queueMessage(OutboundMessage msg) {
        if (this.getServiceStatus() != ServiceStatus.STARTED) {
            return false;
        }
        ArrayList<String> recipients = this.expandGroup(msg.getRecipient());
        if (recipients.size() == 0) {
            return this.getQueueManager().queueMessage(msg);
        }
        for (String to : recipients) {
            OutboundMessage newMessage = new OutboundMessage();
            msg.copyTo(newMessage);
            newMessage.setRecipient(to);
            this.getQueueManager().queueMessage(msg);
        }
        return true;
    }

    public boolean queueMessage(OutboundMessage msg, String gatewayId) {
        if (this.getServiceStatus() != ServiceStatus.STARTED) {
            return false;
        }
        msg.setGatewayId(gatewayId);
        return this.queueMessage(msg);
    }

    public int queueMessages(Collection<OutboundMessage> msgList) {
        int counter = 0;
        if (this.getServiceStatus() != ServiceStatus.STARTED) {
            return 0;
        }
        for (OutboundMessage msg : msgList) {
            if (!this.queueMessage(msg)) continue;
            ++counter;
        }
        return counter;
    }

    public int queueMessages(OutboundMessage[] msgArray) {
        int counter = 0;
        if (this.getServiceStatus() != ServiceStatus.STARTED) {
            return 0;
        }
        for (int i = 0; i < msgArray.length; ++i) {
            if (!this.queueMessage(msgArray[i])) continue;
            ++counter;
        }
        return counter;
    }

    public int queueMessages(Collection<OutboundMessage> msgList, String gatewayId) {
        if (this.getServiceStatus() != ServiceStatus.STARTED) {
            return 0;
        }
        int counter = 0;
        for (OutboundMessage msg : msgList) {
            msg.setGatewayId(gatewayId);
            if (!this.queueMessage(msg)) continue;
            ++counter;
        }
        return counter;
    }

    public int queueMessages(OutboundMessage[] msgArray, String gatewayId) {
        int counter = 0;
        if (this.getServiceStatus() != ServiceStatus.STARTED) {
            return 0;
        }
        for (int i = 0; i < msgArray.length; ++i) {
            msgArray[i].setGatewayId(gatewayId);
            if (!this.queueMessage(msgArray[i])) continue;
            ++counter;
        }
        return counter;
    }

    public boolean queueMessageAt(OutboundMessage msg, Date at) {
        if (this.getServiceStatus() != ServiceStatus.STARTED) {
            return false;
        }
        ArrayList<String> recipients = this.expandGroup(msg.getRecipient());
        if (recipients.size() == 0) {
            return this.getQueueManager().queueDelayedMessage(msg, at);
        }
        for (String to : recipients) {
            OutboundMessage newMessage = new OutboundMessage();
            msg.copyTo(newMessage);
            newMessage.setRecipient(to);
            this.getQueueManager().queueDelayedMessage(msg, at);
        }
        return true;
    }

    public boolean removeMessage(OutboundMessage msg) {
        if (this.getServiceStatus() != ServiceStatus.STARTED) {
            return false;
        }
        return this.getQueueManager().removeMessage(msg);
    }

    public boolean deleteMessage(InboundMessage msg) throws TimeoutException, GatewayException, IOException, InterruptedException {
        if (this.getServiceStatus() != ServiceStatus.STARTED) {
            return false;
        }
        AGateway gateway = this.findGateway(msg.getGatewayId());
        if (gateway != null) {
            try {
                return gateway.deleteMessage(msg);
            }
            catch (TimeoutException e) {
                this.getLogger().logWarn("deleteMessage(): Gateway " + gateway.getGatewayId() + " does not respond, marking for restart.", null, null);
                gateway.setStatus(AGateway.GatewayStatuses.RESTART);
                return false;
            }
            catch (IOException e) {
                this.getLogger().logWarn("deleteMessage(): Gateway " + gateway.getGatewayId() + " throws IO errors, marking for restart.", null, null);
                gateway.setStatus(AGateway.GatewayStatuses.RESTART);
                return false;
            }
        }
        return false;
    }

    public boolean sendUSSDRequest(USSDRequest request, String gatewayId) throws GatewayException, TimeoutException, IOException, InterruptedException {
        if (this.getServiceStatus() != ServiceStatus.STARTED) {
            throw new GatewayException("Service is not started");
        }
        AGateway gateway = this.findGateway(gatewayId);
        if (request == null) {
            throw new IllegalArgumentException("Cannot use a null request object");
        }
        if (gateway == null) {
            throw new GatewayException("Cannot use a null gateway");
        }
        return gateway.sendUSSDRequest(request);
    }

    public int readPhonebook(Phonebook phonebook, String gatewayId) throws TimeoutException, GatewayException, IOException, InterruptedException {
        if (this.getServiceStatus() != ServiceStatus.STARTED) {
            return 0;
        }
        AGateway gateway = this.findGateway(gatewayId);
        if (gateway != null) {
            return gateway.readPhonebook(phonebook);
        }
        return 0;
    }

    public int getInboundMessageCount(String gatewayId) {
        return this.getInboundMessageCount(this.findGateway(gatewayId));
    }

    public int getInboundMessageCount(AGateway gateway) {
        return gateway != null ? gateway.getInboundMessageCount() : -1;
    }

    public int getOutboundMessageCount(String gatewayId) {
        return this.getOutboundMessageCount(this.findGateway(gatewayId));
    }

    public int getOutboundMessageCount(AGateway gateway) {
        return gateway != null ? gateway.getOutboundMessageCount() : -1;
    }

    public int getInboundMessageCount() {
        int total = 0;
        for (AGateway gateway : this.getGateways()) {
            total += gateway.getInboundMessageCount();
        }
        return total;
    }

    public int getOutboundMessageCount() {
        int total = 0;
        for (AGateway gateway : this.getGateways()) {
            total += gateway.getOutboundMessageCount();
        }
        return total;
    }

    public AGateway findGateway(String gatewayId) {
        for (AGateway gateway : this.getGateways()) {
            if (!gateway.getGatewayId().equals(gatewayId)) continue;
            return gateway;
        }
        return null;
    }

    public Collection<AGateway> getGateways() {
        return this.gatewayList;
    }

    public AGateway[] getGatewaysNET() {
        return this.getGateways().toArray(new AGateway[0]);
    }

    public LoadBalancer getLoadBalancer() {
        return this.loadBalancer;
    }

    public void setLoadBalancer(LoadBalancer loadBalancer) {
        this.loadBalancer = loadBalancer;
    }

    public Router getRouter() {
        return this.router;
    }

    public void setRouter(Router router) {
        this.router = router;
    }

    public synchronized AGateway routeMessage(OutboundMessage msg) {
        return this.getRouter().route(msg);
    }

    public IInboundMessageNotification getInboundNotification() {
        return this.inboundNotification;
    }

    public void setInboundNotification(IInboundMessageNotification inboundNotification) {
        this.inboundNotification = inboundNotification;
    }

    public IOutboundMessageNotification getOutboundNotification() {
        return this.outboundNotification;
    }

    public void setOutboundNotification(IOutboundMessageNotification outboundNotification) {
        this.outboundNotification = outboundNotification;
    }

    public ICallNotification getCallNotification() {
        return this.callNotification;
    }

    public void setCallNotification(ICallNotification callNotification) {
        this.callNotification = callNotification;
    }

    public IUSSDNotification getUSSDNotification() {
        return this.ussdNotification;
    }

    public void setUSSDNotification(IUSSDNotification ussdNotification) {
        this.ussdNotification = ussdNotification;
    }

    public IGatewayStatusNotification getGatewayStatusNotification() {
        return this.gatewayStatusNotification;
    }

    public void setGatewayStatusNotification(IGatewayStatusNotification gatewayStatusNotification) {
        this.gatewayStatusNotification = gatewayStatusNotification;
    }

    public IQueueSendingNotification getQueueSendingNotification() {
        return this.queueSendingNotification;
    }

    public void setQueueSendingNotification(IQueueSendingNotification queueSendingNotification) {
        this.queueSendingNotification = queueSendingNotification;
    }

    public long getStartMillis() {
        return this.startMillis;
    }

    void setSettings(Settings settings) {
        this.S = settings;
    }

    public ServiceStatus getServiceStatus() {
        return this.serviceStatus;
    }

    void setServiceStatus(ServiceStatus myServiceStatus) {
        this.serviceStatus = myServiceStatus;
    }

    public Settings getSettings() {
        return this.S;
    }

    public boolean createGroup(String groupName) {
        this.groups.add(new Group(groupName));
        return true;
    }

    public boolean removeGroup(String groupName) {
        for (Group a : this.groups) {
            if (!a.getName().equalsIgnoreCase(groupName)) continue;
            a.clear();
            this.groups.remove(a);
            return true;
        }
        return false;
    }

    public ArrayList<String> expandGroup(String groupName) {
        for (Group a : this.groups) {
            if (!a.getName().equalsIgnoreCase(groupName)) continue;
            return new ArrayList<String>(a.getNumbers());
        }
        return new ArrayList<String>();
    }

    public boolean addToGroup(String groupName, String number) {
        for (Group a : this.groups) {
            if (!a.getName().equalsIgnoreCase(groupName)) continue;
            a.addNumber(number);
            return true;
        }
        return false;
    }

    public boolean removeFromGroup(String groupName, String number) {
        for (Group a : this.groups) {
            if (!a.getName().equalsIgnoreCase(groupName)) continue;
            return a.removeNumber(number);
        }
        return false;
    }

    void setQueueManager(QueueManager myQueueManager) {
        this.queueManager = myQueueManager;
    }

    public QueueManager getQueueManager() {
        return this.queueManager;
    }

    public KeyManager getKeyManager() {
        return this.keyManager;
    }

    WatchDog getWatchDog() {
        return this.watchDog;
    }

    void setWatchDog(WatchDog myWatchDog) {
        this.watchDog = myWatchDog;
    }

    public static void main(String[] args) {
        System.out.println(Library.getLibraryDescription());
        System.out.println("\nSMSLib API Version: " + Library.getLibraryVersion());
    }

    private class WatchDog
    extends AServiceThread {
        public WatchDog(String name, Service service2, int delay) {
            super(name, service2, delay, 0, true);
        }

        public void process() throws Exception {
            if (Service.this.getServiceStatus() != ServiceStatus.STARTED) {
                return;
            }
            for (AGateway gateway : Service.this.getGateways()) {
                if (gateway.getStatus() != AGateway.GatewayStatuses.RESTART) continue;
                Service.this.getLogger().logWarn("Gateway: " + gateway.getGatewayId() + " restarting.", null, null);
                try {
                    gateway.stopGateway();
                    gateway.setStatus(AGateway.GatewayStatuses.RESTART);
                }
                catch (Exception e) {
                    gateway.setStatus(AGateway.GatewayStatuses.RESTART);
                    Service.this.getLogger().logWarn("Error while shutting down Gateway: " + gateway.getGatewayId(), e, null);
                }
                try {
                    gateway.startGateway();
                }
                catch (Exception e) {
                    gateway.setStatus(AGateway.GatewayStatuses.RESTART);
                    Service.this.getLogger().logError("Error while starting Gateway: " + gateway.getGatewayId(), e, null);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ServiceStatus {
        STARTING,
        STARTED,
        STOPPING,
        STOPPED;

    }
}

