/*
 * Decompiled with CFR 0.152.
 */
package org.smslib;

import java.net.URL;
import java.util.Date;
import org.ajwcc.pduUtils.gsm3040.PduFactory;
import org.ajwcc.pduUtils.gsm3040.SmsSubmitPdu;
import org.ajwcc.pduUtils.wappush.WapSiPdu;
import org.smslib.Message;
import org.smslib.OutboundBinaryMessage;

public class OutboundWapSIMessage
extends OutboundBinaryMessage {
    private static final long serialVersionUID = -4652109048225090671L;
    protected URL url;
    protected Date createDate;
    protected Date expireDate;
    protected WapSISignals signal;
    protected String siId;
    protected String indicationText;

    public OutboundWapSIMessage(String myRecipient, URL myUrl, Date myCreateDate, Date myExpireDate, WapSISignals mySignal, String myIndicationText) {
        this.url = myUrl;
        this.createDate = new Date(myCreateDate.getTime());
        this.expireDate = new Date(myExpireDate.getTime());
        this.signal = mySignal;
        this.setIndicationText(myIndicationText);
        this.setSrcPort(9200);
        this.setDstPort(2948);
        this.setType(Message.MessageTypes.WAPSI);
        this.setEncoding(Message.MessageEncodings.ENC8BIT);
        this.setRecipient(myRecipient);
    }

    public OutboundWapSIMessage(String myRecipient, URL myUrl, String text) {
        this(myRecipient, myUrl, new Date(), new Date(), WapSISignals.MEDIUM, text);
    }

    public OutboundWapSIMessage(String myRecipient, URL myUrl, String text, Date myExpireDate, WapSISignals mySignal) {
        this(myRecipient, myUrl, new Date(), myExpireDate, mySignal, text);
    }

    public void setIndicationText(String s) {
        this.indicationText = s;
    }

    public String getIndicationText() {
        return this.indicationText;
    }

    public Date getCreateDate() {
        return new Date(this.createDate.getTime());
    }

    public void setCreateDate(Date myCreateDate) {
        this.createDate = new Date(myCreateDate.getTime());
    }

    public Date getExpireDate() {
        return new Date(this.expireDate.getTime());
    }

    public void setExpireDate(Date myExpireDate) {
        this.expireDate = new Date(myExpireDate.getTime());
    }

    public WapSISignals getSignal() {
        return this.signal;
    }

    public void setSignal(WapSISignals mySignal) {
        this.signal = mySignal;
    }

    public URL getUrl() {
        return this.url;
    }

    public void setUrl(URL myUrl) {
        this.url = myUrl;
    }

    public String getSiId() {
        return this.siId;
    }

    public void setSiId(String mySiId) {
        this.siId = mySiId;
    }

    protected WapSiPdu createPduObject() {
        WapSiPdu pdu = this.getStatusReport() ? PduFactory.newWapSiPdu(48) : PduFactory.newWapSiPdu();
        return pdu;
    }

    protected void initPduObject(SmsSubmitPdu pdu, String smscNumber) {
        super.initPduObject(pdu, smscNumber);
        WapSiPdu wapSiPdu = (WapSiPdu)pdu;
        wapSiPdu.setIndicationText(this.indicationText);
        wapSiPdu.setUrl(this.url.toString());
        wapSiPdu.setCreateDate(this.createDate);
        wapSiPdu.setExpireDate(this.expireDate);
        wapSiPdu.setWapSignalFromString(this.signal.toString());
        wapSiPdu.setSiId(this.siId);
        super.setDataBytes(wapSiPdu.getDataBytes());
    }

    public byte[] getDataBytes() {
        WapSiPdu pdu = this.createPduObject();
        this.initPduObject(pdu, "");
        return super.getDataBytes();
    }

    public void setDataBytes(byte[] b) {
        throw new RuntimeException("setDataBytes() not supported for WapSi Message");
    }

    public void addDataBytes(byte[] b) {
        throw new RuntimeException("addDataBytes() not supported for WapSi Message");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum WapSISignals {
        NONE,
        LOW,
        MEDIUM,
        HIGH,
        DELETE;

    }
}

