/*
 * Decompiled with CFR 0.152.
 */
package org.smslib;

import java.util.Date;
import java.util.List;
import org.ajwcc.pduUtils.gsm3040.Pdu;
import org.ajwcc.pduUtils.gsm3040.PduFactory;
import org.ajwcc.pduUtils.gsm3040.PduGenerator;
import org.ajwcc.pduUtils.gsm3040.PduParser;
import org.ajwcc.pduUtils.gsm3040.PduUtils;
import org.ajwcc.pduUtils.gsm3040.SmsSubmitPdu;
import org.ajwcc.pduUtils.gsm3040.ie.InformationElementFactory;
import org.smslib.Message;
import org.smslib.OutboundBinaryMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OutboundMessage
extends Message {
    private static final long serialVersionUID = 6449191177648891554L;
    protected String recipient;
    private Date dispatchDate;
    private int validityPeriod;
    private boolean statusReport;
    private String from;
    private MessageStatuses messageStatus;
    private FailureCauses failureCause;
    private int retryCount;
    private int priority;
    private String refNo;

    public OutboundMessage() {
        super(Message.MessageTypes.OUTBOUND, null, null);
        this.setRecipient("");
        this.setValidityPeriod(-1);
        this.setStatusReport(false);
        this.setDCSMessageClass(Message.MessageClasses.MSGCLASS_NONE);
        this.setFrom("");
        this.setDispatchDate(null);
        this.setDate(new Date());
        this.setEncoding(Message.MessageEncodings.ENC7BIT);
        this.setMessageStatus(MessageStatuses.UNSENT);
        this.setFailureCause(FailureCauses.NO_ERROR);
        this.setPriority(0);
        this.setRefNo("");
        this.setGatewayId("*");
        this.setRetryCount(0);
    }

    public OutboundMessage(String myRecipient, String text) {
        super(Message.MessageTypes.OUTBOUND, new Date(), text);
        this.setRecipient(myRecipient);
        this.setValidityPeriod(-1);
        this.setStatusReport(false);
        this.setDCSMessageClass(Message.MessageClasses.MSGCLASS_NONE);
        this.setFrom("");
        this.setDispatchDate(null);
        this.setDate(new Date());
        this.setEncoding(Message.MessageEncodings.ENC7BIT);
        this.setMessageStatus(MessageStatuses.UNSENT);
        this.setFailureCause(FailureCauses.NO_ERROR);
        this.setPriority(0);
        this.setRefNo("");
        this.setGatewayId("*");
        this.setRetryCount(0);
    }

    public String getRecipient() {
        return this.recipient;
    }

    public void setRecipient(String myRecipient) {
        this.recipient = myRecipient;
    }

    public Date getDispatchDate() {
        if (this.dispatchDate != null) {
            return new Date(this.dispatchDate.getTime());
        }
        return null;
    }

    public void setDispatchDate(Date myDispatchDate) {
        this.dispatchDate = myDispatchDate;
    }

    public boolean getFlashSms() {
        return this.getDCSMessageClass() == Message.MessageClasses.MSGCLASS_FLASH;
    }

    public void setFlashSms(boolean flashSms) {
        if (flashSms) {
            this.setDCSMessageClass(Message.MessageClasses.MSGCLASS_FLASH);
        } else {
            this.setDCSMessageClass(Message.MessageClasses.MSGCLASS_NONE);
        }
    }

    public boolean getStatusReport() {
        return this.statusReport;
    }

    public void setStatusReport(boolean myStatusReport) {
        this.statusReport = myStatusReport;
    }

    public int getValidityPeriod() {
        return this.validityPeriod;
    }

    public void setValidityPeriod(int myValidityPeriod) {
        this.validityPeriod = myValidityPeriod;
    }

    public String getFrom() {
        return this.from;
    }

    public void setFrom(String myFrom) {
        this.from = myFrom;
    }

    public MessageStatuses getMessageStatus() {
        return this.messageStatus;
    }

    public void setMessageStatus(MessageStatuses myMessageStatus) {
        this.messageStatus = myMessageStatus;
    }

    public FailureCauses getFailureCause() {
        return this.failureCause;
    }

    public void setFailureCause(FailureCauses myFailureCause) {
        if (myFailureCause != FailureCauses.NO_ERROR) {
            this.messageStatus = MessageStatuses.FAILED;
        }
        this.failureCause = myFailureCause;
    }

    public int getRetryCount() {
        return this.retryCount;
    }

    public void setRetryCount(int myRetryCount) {
        this.retryCount = myRetryCount;
    }

    void incrementRetryCount() {
        ++this.retryCount;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int myPriority) {
        this.priority = myPriority;
    }

    public String getRefNo() {
        return this.refNo;
    }

    public void setRefNo(String myRefNo) {
        this.refNo = myRefNo;
    }

    public String toString() {
        String str = "";
        str = str + "===============================================================================";
        str = str + "\n";
        str = str + "<< " + this.getClass().getSimpleName() + " >>";
        str = str + "\n";
        str = str + "-------------------------------------------------------------------------------";
        str = str + "\n";
        str = str + " Gateway Id: " + this.getGatewayId();
        str = str + "\n";
        str = str + " Encoding: " + (this.getEncoding() == Message.MessageEncodings.ENC7BIT ? "7-bit" : (this.getEncoding() == Message.MessageEncodings.ENC8BIT ? "8-bit" : "UCS2 (Unicode)"));
        str = str + "\n";
        str = str + " Date: " + this.getDate();
        str = str + "\n";
        str = str + " SMSC Ref No: " + this.getRefNo();
        str = str + "\n";
        str = str + " Recipient: " + this.getRecipient();
        str = str + "\n";
        str = str + " Dispatch Date: " + this.getDispatchDate();
        str = str + "\n";
        str = str + " Message Status: " + (Object)((Object)this.getMessageStatus());
        str = str + "\n";
        str = str + " Validity Period (Hours): " + this.getValidityPeriod();
        str = str + "\n";
        str = str + " Status Report: " + this.getStatusReport();
        str = str + "\n";
        str = str + " Source / Destination Ports: " + this.getSrcPort() + " / " + this.getDstPort();
        str = str + "\n";
        str = str + " Flash SMS: " + this.getFlashSms();
        str = str + "\n";
        if (this instanceof OutboundBinaryMessage) {
            OutboundBinaryMessage binaryMessage = (OutboundBinaryMessage)this;
            if (binaryMessage.getDataBytes() != null) {
                String binaryString = PduUtils.bytesToPdu(binaryMessage.getDataBytes());
                str = str + " Binary: " + binaryString;
                str = str + "\n";
            } else {
                str = str + " Binary: null";
                str = str + "\n";
            }
        } else {
            str = str + " Text: " + this.getText();
            str = str + "\n";
            try {
                str = str + " PDU data: " + this.getPduUserData();
                str = str + "\n";
            }
            catch (Exception e) {
                str = str + " PDU data: <cannot extract properly, udh present>";
                str = str + "\n";
            }
        }
        str = str + "===============================================================================";
        str = str + "\n";
        return str;
    }

    public List<String> getPdus(String smscNumber, int mpRefNo) {
        PduGenerator pduGenerator = new PduGenerator();
        SmsSubmitPdu pdu = this.createPduObject();
        this.initPduObject(pdu, smscNumber);
        return pduGenerator.generatePduList(pdu, mpRefNo);
    }

    protected SmsSubmitPdu createPduObject() {
        SmsSubmitPdu pdu = this.statusReport ? PduFactory.newSmsSubmitPdu(48) : PduFactory.newSmsSubmitPdu();
        return pdu;
    }

    protected void initPduObject(SmsSubmitPdu pdu, String smscNumber) {
        if (this.getDstPort() > -1 && this.getSrcPort() > -1) {
            pdu.addInformationElement(InformationElementFactory.generatePortInfo(this.getDstPort(), this.getSrcPort()));
        }
        String smscNumberForLengthCheck = smscNumber;
        if (smscNumber.startsWith("+")) {
            smscNumberForLengthCheck = smscNumber.substring(1);
        }
        pdu.setSmscInfoLength(1 + smscNumberForLengthCheck.length() / 2 + (smscNumberForLengthCheck.length() % 2 == 1 ? 1 : 0));
        pdu.setSmscAddress(smscNumber);
        pdu.setSmscAddressType(PduUtils.getAddressTypeFor(smscNumber));
        pdu.setMessageReference(0);
        pdu.setAddress(this.getRecipient());
        pdu.setProtocolIdentifier(0);
        if (!pdu.isBinary()) {
            int dcs = 0;
            if (this.getEncoding() == Message.MessageEncodings.ENC7BIT) {
                dcs = 0;
            } else if (this.getEncoding() == Message.MessageEncodings.ENC8BIT) {
                dcs = 4;
            } else if (this.getEncoding() == Message.MessageEncodings.ENCUCS2) {
                dcs = 8;
            } else if (this.getEncoding() == Message.MessageEncodings.ENCCUSTOM) {
                dcs = 0;
            }
            if (this.getDCSMessageClass() == Message.MessageClasses.MSGCLASS_FLASH) {
                dcs |= 0x10;
            } else if (this.getDCSMessageClass() == Message.MessageClasses.MSGCLASS_ME) {
                dcs |= 0x11;
            } else if (this.getDCSMessageClass() == Message.MessageClasses.MSGCLASS_SIM) {
                dcs |= 0x12;
            } else if (this.getDCSMessageClass() == Message.MessageClasses.MSGCLASS_TE) {
                dcs |= 0x13;
            }
            pdu.setDataCodingScheme(dcs);
        }
        pdu.setValidityPeriod(this.validityPeriod);
        this.setPduPayload(pdu);
    }

    protected void setPduPayload(SmsSubmitPdu pdu) {
        pdu.setDecodedText(this.getText());
    }

    @Override
    public String getPduUserData() {
        PduGenerator pduGenerator = new PduGenerator();
        SmsSubmitPdu pdu = this.createPduObject();
        this.initPduObject(pdu, "");
        List<String> pdus = pduGenerator.generatePduList(pdu, 1);
        if (pdu.hasTpUdhi() && this.getEncoding() == Message.MessageEncodings.ENC7BIT) {
            throw new RuntimeException("getPduUserData() not supported for 7-bit messages with UDH");
        }
        StringBuffer ud = new StringBuffer();
        for (String pduString : pdus) {
            Pdu newPdu = new PduParser().parsePdu(pduString);
            ud.append(PduUtils.bytesToPdu(newPdu.getUserDataAsBytes()));
        }
        return ud.toString();
    }

    @Override
    public String getPduUserDataHeader() {
        PduGenerator pduGenerator = new PduGenerator();
        SmsSubmitPdu pdu = this.createPduObject();
        this.initPduObject(pdu, "");
        List<String> pdus = pduGenerator.generatePduList(pdu, 1);
        Pdu newPdu = new PduParser().parsePdu(pdus.get(0));
        byte[] udh = newPdu.getUDHData();
        if (udh != null) {
            return PduUtils.bytesToPdu(udh);
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setEncoding(Message.MessageEncodings encoding) {
        if (encoding == Message.MessageEncodings.ENC8BIT) {
            if (!(this instanceof OutboundBinaryMessage)) throw new RuntimeException("Cannot use 8-bit encoding with OutgoingMessage, use OutgoingBinaryMessage instead");
            super.setEncoding(encoding);
            return;
        } else {
            super.setEncoding(encoding);
        }
    }

    protected void copyTo(OutboundMessage msg) {
        super.copyTo(msg);
        msg.setRecipient(this.getRecipient());
        msg.setDispatchDate(this.getDispatchDate());
        msg.setValidityPeriod(this.getValidityPeriod());
        msg.setStatusReport(this.getStatusReport());
        msg.setFlashSms(this.getFlashSms());
        msg.setFrom(this.getFrom());
        msg.setMessageStatus(this.getMessageStatus());
        msg.setFailureCause(this.getFailureCause());
        msg.retryCount = this.getRetryCount();
        msg.setPriority(this.getPriority());
        msg.setRefNo(this.getRefNo());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum MessageStatuses {
        UNSENT,
        SENT,
        FAILED;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum FailureCauses {
        NO_ERROR,
        BAD_NUMBER,
        BAD_FORMAT,
        GATEWAY_FAILURE,
        NO_CREDIT,
        GATEWAY_AUTH,
        NO_ROUTE,
        UNKNOWN;

    }
}

