/*
 * Decompiled with CFR 0.152.
 */
package org.smslib;

public class Contact {
    private String name;
    private String number;
    private String memLoc;
    private int memIndex;

    public Contact(String myName, String myNumber, String myMemLoc, int myMemIndex) {
        this.name = myName;
        this.number = myNumber;
        this.memLoc = myMemLoc;
        this.memIndex = myMemIndex;
    }

    String getName() {
        return this.name;
    }

    void setName(String name) {
        this.name = name;
    }

    String getNumber() {
        return this.number;
    }

    void setNumber(String number) {
        this.number = number;
    }

    ContactLocation getLocation() {
        return Contact.convertLocationToType(this.memLoc);
    }

    String getMemLoc() {
        return this.memLoc;
    }

    void setMemLoc(String memLoc) {
        this.memLoc = memLoc;
    }

    int getMemIndex() {
        return this.memIndex;
    }

    void setMemIndex(int myMemIndex) {
        this.memIndex = myMemIndex;
    }

    public String toString() {
        return String.format("Name: %s, Phone: %s, Loc: %s [%s:%d]", new Object[]{this.getName(), this.getNumber(), this.getLocation(), this.getMemLoc(), this.getMemIndex()});
    }

    public static String convertTypeToLocation(ContactLocation type) {
        switch (type) {
            case DIALLED_CALLS: {
                return "DC";
            }
            case MISSED_CALLS: {
                return "MC";
            }
            case PHONE_ENTRIES: {
                return "ME";
            }
            case SIM_ENTRIES: {
                return "SM";
            }
            case ALL_ENTRIES: {
                return "MT";
            }
        }
        return "";
    }

    public static ContactLocation convertLocationToType(String loc) {
        if (loc.equalsIgnoreCase("DC")) {
            return ContactLocation.DIALLED_CALLS;
        }
        if (loc.equalsIgnoreCase("MC")) {
            return ContactLocation.MISSED_CALLS;
        }
        if (loc.equalsIgnoreCase("ME")) {
            return ContactLocation.PHONE_ENTRIES;
        }
        if (loc.equalsIgnoreCase("SM")) {
            return ContactLocation.SIM_ENTRIES;
        }
        if (loc.equalsIgnoreCase("MT")) {
            return ContactLocation.ALL_ENTRIES;
        }
        return ContactLocation.UNKNOWN_ENTRY;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ContactLocation {
        DIALLED_CALLS,
        MISSED_CALLS,
        PHONE_ENTRIES,
        SIM_ENTRIES,
        ALL_ENTRIES,
        UNKNOWN_ENTRY;

    }
}

