/*
 * Decompiled with CFR 0.152.
 */
package org.smslib;

import java.io.IOException;
import java.util.Collection;
import org.smslib.GatewayException;
import org.smslib.InboundMessage;
import org.smslib.OutboundMessage;
import org.smslib.Phonebook;
import org.smslib.Service;
import org.smslib.StatusReportMessage;
import org.smslib.TimeoutException;
import org.smslib.USSDRequest;
import org.smslib.threading.AServiceThread;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AGateway {
    private String gatewayId;
    private int attributes;
    private boolean inbound;
    private boolean outbound;
    private Service srv;
    private Protocols protocol;
    private Statistics statistics;
    private String from;
    private int deliveryErrorCode;
    private GatewayStatuses status;
    private int restartCount;
    private QueueManager queueManager;

    public AGateway(String id) {
        this.gatewayId = id;
        this.srv = null;
        this.inbound = false;
        this.outbound = false;
        this.attributes = 0;
        this.protocol = Protocols.PDU;
        this.from = "";
        this.statistics = new Statistics();
        this.from = "";
        this.deliveryErrorCode = -1;
        this.status = GatewayStatuses.STOPPED;
        this.restartCount = 0;
    }

    public void setAttributes(int myAttributes) {
        this.attributes = myAttributes;
    }

    public int getAttributes() {
        return this.attributes;
    }

    public Service getService() {
        return this.srv;
    }

    public void setService(Service mySrv) {
        this.srv = mySrv;
    }

    public boolean isInbound() {
        return this.inbound;
    }

    public void setInbound(boolean value) {
        if ((this.attributes & 2) != 0) {
            this.inbound = value;
        }
    }

    public boolean isOutbound() {
        return this.outbound;
    }

    public void setOutbound(boolean value) {
        if ((this.attributes & 1) != 0) {
            this.outbound = value;
        }
    }

    public void setProtocol(Protocols myProtocoll) {
        this.protocol = myProtocoll;
    }

    public Protocols getProtocol() {
        return this.protocol;
    }

    public String getGatewayId() {
        return this.gatewayId;
    }

    public GatewayStatuses getStatus() {
        return this.status;
    }

    public void setStatus(GatewayStatuses myStatus) {
        if (this.getService().getGatewayStatusNotification() != null) {
            this.getService().getGatewayStatusNotification().process(this.getGatewayId(), this.getStatus(), myStatus);
        }
        this.status = myStatus;
    }

    public int getInboundMessageCount() {
        return this.statistics.inbound;
    }

    public void incInboundMessageCount() {
        ++this.statistics.inbound;
    }

    public int getOutboundMessageCount() {
        return this.statistics.outbound;
    }

    public void incOutboundMessageCount() {
        ++this.statistics.outbound;
    }

    public String getFrom() {
        return this.from;
    }

    public void setFrom(String myFrom) {
        this.from = myFrom;
    }

    public void startGateway() throws TimeoutException, GatewayException, IOException, InterruptedException {
        this.setStatus(GatewayStatuses.STARTING);
        this.queueManager = new QueueManager("QueueManager [" + this.gatewayId + "]", this.getService(), this.getQueueSchedulingInterval());
        ++this.restartCount;
        this.setStatus(GatewayStatuses.STARTED);
    }

    public void stopGateway() throws TimeoutException, GatewayException, IOException, InterruptedException {
        if (this.queueManager != null) {
            this.queueManager.cancel();
            this.queueManager = null;
        }
        this.setStatus(GatewayStatuses.STOPPING);
        this.setStatus(GatewayStatuses.STOPPED);
    }

    public void readMessages(Collection<InboundMessage> msgList, InboundMessage.MessageClasses msgClass) throws TimeoutException, GatewayException, IOException, InterruptedException {
        throw new GatewayException("Feature not supported.");
    }

    public InboundMessage readMessage(String memLoc, int memIndex) throws TimeoutException, GatewayException, IOException, InterruptedException {
        throw new GatewayException("Feature not supported.");
    }

    public boolean sendMessage(OutboundMessage msg) throws TimeoutException, GatewayException, IOException, InterruptedException {
        throw new GatewayException("Feature not supported.");
    }

    public int sendMessages(Collection<OutboundMessage> msgList) throws TimeoutException, GatewayException, IOException, InterruptedException {
        int cnt = 0;
        for (OutboundMessage msg : msgList) {
            if (!this.sendMessage(msg)) continue;
            ++cnt;
        }
        return cnt;
    }

    public boolean deleteMessage(InboundMessage msg) throws TimeoutException, GatewayException, IOException, InterruptedException {
        throw new GatewayException("Feature not supported.");
    }

    public float queryBalance() throws TimeoutException, GatewayException, IOException, InterruptedException {
        throw new GatewayException("Feature not supported.");
    }

    public boolean queryCoverage(OutboundMessage msg) throws TimeoutException, GatewayException, IOException, InterruptedException {
        throw new GatewayException("Feature not supported.");
    }

    public StatusReportMessage.DeliveryStatuses queryMessage(OutboundMessage msg) throws TimeoutException, GatewayException, IOException, InterruptedException {
        return this.queryMessage(msg.getRefNo());
    }

    public StatusReportMessage.DeliveryStatuses queryMessage(String refNo) throws TimeoutException, GatewayException, IOException, InterruptedException {
        throw new GatewayException("Feature not supported.");
    }

    public int readPhonebook(Phonebook phonebook) throws TimeoutException, GatewayException, IOException, InterruptedException {
        throw new GatewayException("Feature not supported.");
    }

    public int getDeliveryErrorCode() {
        return this.deliveryErrorCode;
    }

    public void setDeliveryErrorCode(int error) {
        this.deliveryErrorCode = error;
    }

    boolean isCapableOf(int att) {
        return (att & this.attributes) == att;
    }

    boolean conformsTo(int attrib, boolean required) {
        return !required || this.isCapableOf(attrib);
    }

    public int getRestartCount() {
        return this.restartCount;
    }

    public abstract int getQueueSchedulingInterval();

    public String sendUSSDCommand(String ussdCommand) throws GatewayException, TimeoutException, IOException, InterruptedException {
        throw new GatewayException("Feature not supported");
    }

    public String sendUSSDCommand(String ussdCommand, boolean interactive) throws GatewayException, TimeoutException, IOException, InterruptedException {
        throw new GatewayException("Feature not supported");
    }

    public boolean sendUSSDRequest(USSDRequest request) throws GatewayException, TimeoutException, IOException, InterruptedException {
        throw new GatewayException("Feature not supported");
    }

    private class QueueManager
    extends AServiceThread {
        public QueueManager(String name, Service service, int delay) {
            super(name, service, delay, 0, true);
        }

        public void process() throws Exception {
            OutboundMessage msg = null;
            try {
                if (AGateway.this.getStatus() == GatewayStatuses.STARTED && (msg = this.getService().getQueueManager().getGatewayQueue(AGateway.this.getGatewayId()).poll()) != null) {
                    if (this.getService().getQueueSendingNotification() != null) {
                        this.getService().getQueueSendingNotification().process(AGateway.this.getGatewayId(), msg);
                    }
                    if (!AGateway.this.sendMessage(msg)) {
                        if (msg.getRetryCount() < this.getService().getSettings().QUEUE_RETRIES) {
                            this.getService().getLogger().logInfo("Reinserting message to queue.", null, AGateway.this.getGatewayId());
                            msg.incrementRetryCount();
                            this.getService().getQueueManager().queueMessage(msg);
                        } else {
                            this.getService().getLogger().logWarn("Maximum number of queue retries exceeded, message lost.", null, AGateway.this.getGatewayId());
                            msg.setFailureCause(OutboundMessage.FailureCauses.UNKNOWN);
                            if (this.getService().getOutboundNotification() != null) {
                                this.getService().getOutboundNotification().process(AGateway.this.getGatewayId(), msg);
                            }
                        }
                    } else if (this.getService().getOutboundNotification() != null) {
                        this.getService().getOutboundNotification().process(AGateway.this.getGatewayId(), msg);
                    }
                }
            }
            catch (InterruptedException e) {
                if (msg != null && msg.getMessageStatus() != OutboundMessage.MessageStatuses.SENT) {
                    this.getService().getQueueManager().queueMessage(msg);
                }
                this.getService().getLogger().logInfo("QueueManager interrupted.", e, AGateway.this.getGatewayId());
            }
            catch (Exception e) {
                this.getService().getLogger().logWarn("Queue exception, marking gateway for reset.", e, AGateway.this.getGatewayId());
                AGateway.this.setStatus(GatewayStatuses.RESTART);
                try {
                    if (msg != null && msg.getMessageStatus() != OutboundMessage.MessageStatuses.SENT) {
                        this.getService().getQueueManager().queueMessage(msg);
                    }
                }
                catch (Exception e1) {
                    this.getService().getLogger().logError("Fatal error during restart of the queue.", e1, AGateway.this.getGatewayId());
                }
            }
        }
    }

    static class Statistics {
        public int inbound = 0;
        public int outbound = 0;
    }

    public static class GatewayAttributes {
        public static final int SEND = 1;
        public static final int RECEIVE = 2;
        public static final int CUSTOMFROM = 4;
        public static final int BIGMESSAGES = 8;
        public static final int WAPSI = 16;
        public static final int PORTADDRESSING = 32;
        public static final int FLASHSMS = 64;
        public static final int DELIVERYREPORTS = 128;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum AsyncEvents {
        DELETE,
        NOTHING,
        INBOUNDMESSAGE,
        INBOUNDSTATUSREPORTMESSAGE,
        INBOUNDCALL,
        USSDRESPONSE;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum GatewayStatuses {
        STOPPED,
        STOPPING,
        STARTING,
        STARTED,
        FAILURE,
        RESTART;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Protocols {
        PDU,
        TEXT;

    }
}

