/*
 * Decompiled with CFR 0.152.
 */
package org.ajwcc.pduUtils.wappush;

import java.util.Date;
import org.ajwcc.pduUtils.gsm3040.SmsSubmitPdu;
import org.ajwcc.pduUtils.wappush.WapSiUserDataGenerator;

public class WapSiPdu
extends SmsSubmitPdu {
    public static final int WAP_SIGNAL_NONE = 5;
    public static final int WAP_SIGNAL_LOW = 6;
    public static final int WAP_SIGNAL_MEDIUM = 7;
    public static final int WAP_SIGNAL_HIGH = 8;
    public static final int WAP_SIGNAL_DELETE = 9;
    private int wapSignal = 7;
    private String indicationText;
    private String url;
    private Date createDate;
    private Date expireDate;
    private String siId;
    private String siClass;

    public WapSiPdu() {
        this.setDataCodingScheme(244);
    }

    public String getSiId() {
        return this.siId;
    }

    public void setSiId(String siId) {
        this.siId = siId;
    }

    public String getSiClass() {
        return this.siClass;
    }

    public void setSiClass(String siClass) {
        this.siClass = siClass;
    }

    public String getIndicationText() {
        return this.indicationText;
    }

    public void setIndicationText(String indicationText) {
        this.indicationText = indicationText;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public Date getCreateDate() {
        return this.createDate;
    }

    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    public Date getExpireDate() {
        return this.expireDate;
    }

    public void setExpireDate(Date expireDate) {
        this.expireDate = expireDate;
    }

    public int getWapSignal() {
        return this.wapSignal;
    }

    public void setWapSignalFromString(String s) {
        if (s == null) {
            this.wapSignal = 7;
            return;
        }
        if ((s = s.trim()).equalsIgnoreCase("none")) {
            this.wapSignal = 5;
        } else if (s.equalsIgnoreCase("low")) {
            this.wapSignal = 6;
        } else if (s.equalsIgnoreCase("medium") || s.equals("")) {
            this.wapSignal = 7;
        } else if (s.equalsIgnoreCase("high")) {
            this.wapSignal = 8;
        } else if (s.equalsIgnoreCase("delete")) {
            this.wapSignal = 9;
        } else {
            throw new RuntimeException("Cannot determine WAP signal to use");
        }
    }

    public void setWapSignal(int i) {
        switch (i) {
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                this.wapSignal = i;
                break;
            }
            default: {
                throw new RuntimeException("Invalid wap signal value: " + i);
            }
        }
    }

    public byte[] getDataBytes() {
        if (super.getDataBytes() == null) {
            WapSiUserDataGenerator udGenerator = new WapSiUserDataGenerator();
            udGenerator.setWapSiPdu(this);
            this.setDataBytes(udGenerator.generateWapSiUDBytes());
        }
        return super.getDataBytes();
    }
}

