/*
 * Decompiled with CFR 0.152.
 */
package org.ajwcc.pduUtils.test.integration;

import org.smslib.ICallNotification;
import org.smslib.IInboundMessageNotification;
import org.smslib.IOutboundMessageNotification;
import org.smslib.InboundMessage;
import org.smslib.Library;
import org.smslib.Message;
import org.smslib.OutboundMessage;
import org.smslib.Service;
import org.smslib.modem.SerialModemGateway;

public abstract class AbstractTester {
    protected Service srv;
    protected static final String MODEM_NUMBER = "xxxx";
    protected static final String PHONE_NUMBER = "xxxx";

    protected void initModem() throws Exception {
        System.out.println(Library.getLibraryDescription());
        System.out.println("Version: " + Library.getLibraryVersion());
        this.srv = new Service();
        SerialModemGateway gateway = new SerialModemGateway("modem.com1", "COM10", 115200, "Wavecom", "");
        gateway.setSimPin("0000");
        gateway.setOutbound(true);
        OutboundNotification outboundNotification = new OutboundNotification();
        this.srv.setOutboundNotification(outboundNotification);
        gateway.setInbound(true);
        InboundNotification inboundNotification = new InboundNotification();
        this.srv.setInboundNotification(inboundNotification);
        this.srv.addGateway(gateway);
        this.srv.startService();
        System.out.println();
        System.out.println("Modem Information:");
        System.out.println("  Manufacturer: " + gateway.getManufacturer());
        System.out.println("  Model: " + gateway.getModel());
        System.out.println("  Serial No: " + gateway.getSerialNo());
        System.out.println("  SIM IMSI: " + gateway.getImsi());
        System.out.println("  Signal Level: " + gateway.getSignalLevel() + "%");
        System.out.println("  Battery Level: " + gateway.getBatteryLevel() + "%");
        System.out.println();
    }

    protected abstract void test() throws Exception;

    public class OutboundNotification
    implements IOutboundMessageNotification {
        public void process(String gatewayId, OutboundMessage msg) {
            System.out.println("Outbound handler called from Gateway: " + gatewayId);
            System.out.println(msg);
        }
    }

    public class CallNotification
    implements ICallNotification {
        public void process(String gatewayId, String callerId) {
            System.out.println(">>> New call detected from Gateway: " + gatewayId + " : " + callerId);
        }
    }

    public class InboundNotification
    implements IInboundMessageNotification {
        public void process(String gatewayId, Message.MessageTypes msgType, InboundMessage msg) {
            if (msgType == Message.MessageTypes.INBOUND) {
                System.out.println(">>> New Inbound message detected from Gateway: " + gatewayId);
            } else if (msgType == Message.MessageTypes.STATUSREPORT) {
                System.out.println(">>> New Inbound Status Report message detected from Gateway: " + gatewayId);
            }
            System.out.println(msg);
            try {
                AbstractTester.this.srv.deleteMessage(msg);
            }
            catch (Exception e) {
                System.out.println("Oops!!! Something gone bad...");
                e.printStackTrace();
            }
        }
    }
}

