/*
 * Decompiled with CFR 0.152.
 */
package org.ajwcc.pduUtils.gsm3040;

import java.util.Calendar;
import java.util.TimeZone;
import org.ajwcc.pduUtils.gsm3040.Pdu;
import org.ajwcc.pduUtils.gsm3040.PduFactory;
import org.ajwcc.pduUtils.gsm3040.PduUtils;
import org.ajwcc.pduUtils.gsm3040.SmsDeliveryPdu;
import org.ajwcc.pduUtils.gsm3040.SmsStatusReportPdu;
import org.ajwcc.pduUtils.gsm3040.SmsSubmitPdu;
import org.ajwcc.pduUtils.gsm3040.ie.InformationElement;
import org.ajwcc.pduUtils.gsm3040.ie.InformationElementFactory;

public class PduParser {
    private int position;
    private byte[] pduByteArray;

    private int readByte() {
        int retVal = this.pduByteArray[this.position] & 0xFF;
        ++this.position;
        return retVal;
    }

    private int readSwappedNibbleBCDByte() {
        int data = this.readByte();
        data = PduUtils.swapNibbles((byte)data);
        int retVal = 0;
        retVal += (data >>> 4 & 0xF) * 10;
        return retVal += data & 0xF;
    }

    private Calendar readTimeStamp() {
        int bcdTimeZone;
        int year = this.readSwappedNibbleBCDByte();
        int month = this.readSwappedNibbleBCDByte();
        int day = this.readSwappedNibbleBCDByte();
        int hour = this.readSwappedNibbleBCDByte();
        int minute = this.readSwappedNibbleBCDByte();
        int second = this.readSwappedNibbleBCDByte();
        int timestamp = this.readByte();
        boolean negative = (timestamp & 8) == 8;
        int timezone = PduUtils.swapNibbles(timestamp) & 0x7F;
        TimeZone tz = null;
        if (negative) {
            bcdTimeZone = 0;
            bcdTimeZone += (timezone >>> 4 & 0xF) * 10;
            bcdTimeZone += timezone & 0xF;
            timezone = bcdTimeZone;
            int totalMinutes = timezone * 15;
            int hours = totalMinutes / 60;
            int minutes = totalMinutes % 60;
            String gmtString = "GMT-" + hours + ":" + (minutes < 10 ? "0" : "") + minutes;
            tz = TimeZone.getTimeZone(gmtString);
        } else {
            bcdTimeZone = 0;
            bcdTimeZone += (timezone >>> 4 & 0xF) * 10;
            bcdTimeZone += timezone & 0xF;
            timezone = bcdTimeZone;
            int totalMinutes = timezone * 15;
            int hours = totalMinutes / 60;
            int minutes = totalMinutes % 60;
            String gmtString = "GMT+" + hours + ":" + (minutes < 10 ? "0" : "") + minutes;
            tz = TimeZone.getTimeZone(gmtString);
        }
        Calendar cal = Calendar.getInstance(tz);
        cal.set(1, year + 2000);
        cal.set(2, month - 1);
        cal.set(5, day);
        cal.set(11, hour);
        cal.set(12, minute);
        cal.set(13, second);
        return cal;
    }

    private String readAddress(int addressLength, int addressType) {
        if (addressLength > 0) {
            int addressDataOctetLength = addressLength / 2 + (addressLength % 2 == 1 ? 1 : 0);
            byte[] addressData = new byte[addressDataOctetLength];
            System.arraycopy(this.pduByteArray, this.position, addressData, 0, addressDataOctetLength);
            this.position += addressDataOctetLength;
            switch (PduUtils.extractAddressType(addressType)) {
                case 80: {
                    return PduUtils.decode7bitEncoding(addressData);
                }
            }
            return PduUtils.readBCDNumbers(addressLength, addressData);
        }
        return null;
    }

    private int readValidityPeriodInt() {
        int validity = this.readByte();
        int minutes = 0;
        if (validity > 0 && validity <= 143) {
            minutes = (validity + 1) * 5;
        } else if (validity > 143 && validity <= 167) {
            minutes = 720 + (validity - 143) * 30;
        } else if (validity > 167 && validity <= 196) {
            minutes = (validity - 166) * 24 * 60;
        } else if (validity > 197 && validity <= 255) {
            minutes = (validity - 192) * 7 * 24 * 60;
        }
        return minutes;
    }

    public Pdu parsePdu(String rawPdu) {
        this.pduByteArray = PduUtils.pduToBytes(rawPdu);
        this.position = 0;
        Pdu pdu = this.parseStart();
        pdu.setRawPdu(rawPdu);
        switch (pdu.getTpMti()) {
            case 0: {
                this.parseSmsDeliverMessage((SmsDeliveryPdu)pdu);
                break;
            }
            case 1: {
                this.parseSmsSubmitMessage((SmsSubmitPdu)pdu);
                break;
            }
            case 2: {
                this.parseSmsStatusReportMessage((SmsStatusReportPdu)pdu);
            }
        }
        return pdu;
    }

    private Pdu parseStart() {
        int addressLength = this.readByte();
        Pdu pdu = null;
        if (addressLength > 0) {
            int addressType = this.readByte();
            String smscAddress = this.readAddress((addressLength - 1) * 2, addressType);
            int firstOctet = this.readByte();
            pdu = PduFactory.createPdu(firstOctet);
            pdu.setSmscAddressType(addressType);
            pdu.setSmscAddress(smscAddress);
            pdu.setSmscInfoLength(addressLength);
        } else {
            int firstOctet = this.readByte();
            pdu = PduFactory.createPdu(firstOctet);
        }
        return pdu;
    }

    private void parseUserData(Pdu pdu) {
        int udLength = this.readByte();
        pdu.setUDLength(udLength);
        int udOctetLength = this.pduByteArray.length - this.position;
        byte[] udData = new byte[udOctetLength];
        System.arraycopy(this.pduByteArray, this.position, udData, 0, udOctetLength);
        pdu.setUDData(udData);
        if (pdu.hasTpUdhi()) {
            int udhLength = this.readByte();
            int endUdh = this.position + udhLength;
            while (this.position < endUdh) {
                int iei = this.readByte();
                int iedl = this.readByte();
                byte[] ieData = new byte[iedl];
                System.arraycopy(this.pduByteArray, this.position, ieData, 0, iedl);
                InformationElement ie = InformationElementFactory.createInformationElement(iei, ieData);
                pdu.addInformationElement(ie);
                this.position += iedl;
                if (this.position <= endUdh) continue;
                throw new RuntimeException("UDH is shorter than expected endUdh=" + endUdh + ", position=" + this.position);
            }
        }
    }

    private void parseSmsDeliverMessage(SmsDeliveryPdu pdu) {
        int addressLength = this.readByte();
        int addressType = this.readByte();
        String originatorAddress = this.readAddress(addressLength, addressType);
        pdu.setAddressType(addressType);
        pdu.setAddress(originatorAddress);
        int protocolId = this.readByte();
        pdu.setProtocolIdentifier(protocolId);
        int dcs = this.readByte();
        pdu.setDataCodingScheme(dcs);
        Calendar timestamp = this.readTimeStamp();
        pdu.setTimestamp(timestamp);
        this.parseUserData(pdu);
    }

    private void parseSmsStatusReportMessage(SmsStatusReportPdu pdu) {
        int messageReference = this.readByte();
        pdu.setMessageReference(messageReference);
        int addressLength = this.readByte();
        int addressType = this.readByte();
        String destinationAddress = this.readAddress(addressLength, addressType);
        pdu.setAddressType(addressType);
        pdu.setAddress(destinationAddress);
        Calendar timestamp = this.readTimeStamp();
        pdu.setTimestamp(timestamp);
        Calendar timestamp2 = this.readTimeStamp();
        pdu.setDischargeTime(timestamp2);
        int status = this.readByte();
        pdu.setStatus(status);
    }

    private void parseSmsSubmitMessage(SmsSubmitPdu pdu) {
        int messageReference = this.readByte();
        pdu.setMessageReference(messageReference);
        int addressLength = this.readByte();
        int addressType = this.readByte();
        String destinationAddress = this.readAddress(addressLength, addressType);
        pdu.setAddressType(addressType);
        pdu.setAddress(destinationAddress);
        int protocolId = this.readByte();
        pdu.setProtocolIdentifier(protocolId);
        int dcs = this.readByte();
        pdu.setDataCodingScheme(dcs);
        switch (pdu.getTpVpf()) {
            case 0: {
                break;
            }
            case 16: {
                int validityInt = this.readValidityPeriodInt();
                pdu.setValidityPeriod(validityInt / 60);
                break;
            }
            case 24: {
                Calendar validityDate = this.readTimeStamp();
                pdu.setValidityTimestamp(validityDate);
            }
        }
        this.parseUserData(pdu);
    }
}

