/*
 * Decompiled with CFR 0.152.
 */
package twitter4j;

import java.util.LinkedList;
import java.util.List;
import twitter4j.ExecuteThread;

class Dispatcher {
    private ExecuteThread[] threads;
    private List<Runnable> q = new LinkedList<Runnable>();
    Object ticket = new Object();
    private boolean active = true;

    public Dispatcher(String name) {
        this(name, 1);
    }

    public Dispatcher(String name, int threadcount) {
        this.threads = new ExecuteThread[threadcount];
        for (int i = 0; i < this.threads.length; ++i) {
            this.threads[i] = new ExecuteThread(name, this, i);
            this.threads[i].setDaemon(true);
            this.threads[i].start();
        }
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                if (Dispatcher.this.active) {
                    Dispatcher.this.shutdown();
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void invokeLater(Runnable task) {
        Object object = this.q;
        synchronized (object) {
            this.q.add(task);
        }
        object = this.ticket;
        synchronized (object) {
            this.ticket.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Runnable poll() {
        while (this.active) {
            Object object = this.q;
            synchronized (object) {
                Runnable task;
                if (this.q.size() > 0 && null != (task = this.q.remove(0))) {
                    return task;
                }
            }
            object = this.ticket;
            synchronized (object) {
                try {
                    this.ticket.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void shutdown() {
        if (this.active) {
            this.active = false;
            ExecuteThread[] arr$ = this.threads;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                ExecuteThread thread = arr$[i$];
                thread.shutdown();
            }
            Object object = this.ticket;
            synchronized (object) {
                this.ticket.notify();
            }
        } else {
            throw new IllegalStateException("Already shutdown");
        }
    }
}

