/*
 * Decompiled with CFR 0.152.
 */
package org.drools.xml;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.ListIterator;
import org.drools.lang.descr.AccumulateDescr;
import org.drools.lang.descr.AndDescr;
import org.drools.lang.descr.CollectDescr;
import org.drools.lang.descr.ConditionalElementDescr;
import org.drools.lang.descr.EvalDescr;
import org.drools.lang.descr.ExistsDescr;
import org.drools.lang.descr.ForallDescr;
import org.drools.lang.descr.NotDescr;
import org.drools.lang.descr.OrDescr;
import org.drools.lang.descr.PatternDescr;
import org.drools.lang.descr.PatternDestinationDescr;
import org.drools.xml.BaseAbstractHandler;
import org.drools.xml.Configuration;
import org.drools.xml.Handler;
import org.drools.xml.XmlPackageReader;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

class PatternHandler
extends BaseAbstractHandler
implements Handler {
    PatternHandler(XmlPackageReader xmlPackageReader) {
        this.xmlPackageReader = xmlPackageReader;
        if (this.validParents == null && this.validPeers == null) {
            this.validParents = new HashSet();
            this.validParents.add(AndDescr.class);
            this.validParents.add(OrDescr.class);
            this.validParents.add(NotDescr.class);
            this.validParents.add(ExistsDescr.class);
            this.validParents.add(CollectDescr.class);
            this.validParents.add(ForallDescr.class);
            this.validParents.add(AccumulateDescr.class);
            this.validPeers = new HashSet();
            this.validPeers.add(null);
            this.validPeers.add(AndDescr.class);
            this.validPeers.add(OrDescr.class);
            this.validPeers.add(NotDescr.class);
            this.validPeers.add(ExistsDescr.class);
            this.validPeers.add(EvalDescr.class);
            this.validPeers.add(PatternDescr.class);
            this.validPeers.add(ForallDescr.class);
            this.allowNesting = true;
        }
    }

    public Object start(String uri, String localName, Attributes attrs) throws SAXException {
        this.xmlPackageReader.startConfiguration(localName, attrs);
        String objectType = attrs.getValue("object-type");
        if (objectType == null || objectType.trim().equals("")) {
            throw new SAXParseException("<pattern> requires an 'object-type' attribute", this.xmlPackageReader.getLocator());
        }
        PatternDescr patternDescr = null;
        String identifier = attrs.getValue("identifier");
        patternDescr = identifier == null || identifier.trim().equals("") ? new PatternDescr(objectType) : new PatternDescr(objectType, identifier);
        return patternDescr;
    }

    public Object end(String uri, String localName) throws SAXException {
        Configuration config = this.xmlPackageReader.endConfiguration();
        PatternDescr patternDescr = (PatternDescr)this.xmlPackageReader.getCurrent();
        LinkedList parents = this.xmlPackageReader.getParents();
        ListIterator ite = parents.listIterator(parents.size());
        ite.previous();
        Object parent = ite.previous();
        if (parent instanceof PatternDestinationDescr) {
            PatternDestinationDescr parentDescr = (PatternDestinationDescr)parent;
            parentDescr.setInputPattern(patternDescr);
        } else {
            ConditionalElementDescr parentDescr = (ConditionalElementDescr)parent;
            parentDescr.addDescr(patternDescr);
        }
        return null;
    }

    public Class generateNodeFor() {
        return PatternDescr.class;
    }
}

