/*
 * Decompiled with CFR 0.152.
 */
package org.drools.lang.descr;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.drools.lang.descr.AttributeDescr;
import org.drools.lang.descr.BaseDescr;
import org.drools.lang.descr.FactTemplateDescr;
import org.drools.lang.descr.FunctionDescr;
import org.drools.lang.descr.FunctionImportDescr;
import org.drools.lang.descr.GlobalDescr;
import org.drools.lang.descr.ImportDescr;
import org.drools.lang.descr.RuleDescr;

public class PackageDescr
extends BaseDescr {
    private static final long serialVersionUID = 400L;
    private final String name;
    private final String documentation;
    private List imports = Collections.EMPTY_LIST;
    private List functionImports = Collections.EMPTY_LIST;
    private List attributes = Collections.EMPTY_LIST;
    private List globals = Collections.EMPTY_LIST;
    private List factTemplates = Collections.EMPTY_LIST;
    private List functions = Collections.EMPTY_LIST;
    private List rules = Collections.EMPTY_LIST;

    public PackageDescr(String name) {
        this(name, "");
    }

    public PackageDescr(String name, String documentation) {
        this.name = name;
        this.documentation = documentation;
    }

    public String getName() {
        return this.name;
    }

    public String getDocumentation() {
        return this.documentation;
    }

    public void addImport(ImportDescr importEntry) {
        if (this.imports == Collections.EMPTY_LIST) {
            this.imports = new ArrayList();
        }
        this.imports.add(importEntry);
    }

    public List getImports() {
        return this.imports;
    }

    public void addFunctionImport(FunctionImportDescr importFunction) {
        if (this.functionImports == Collections.EMPTY_LIST) {
            this.functionImports = new ArrayList();
        }
        this.functionImports.add(importFunction);
    }

    public List getFunctionImports() {
        return this.functionImports;
    }

    public void addGlobal(GlobalDescr global) {
        if (this.globals == Collections.EMPTY_LIST) {
            this.globals = new ArrayList();
        }
        this.globals.add(global);
    }

    public List getGlobals() {
        return this.globals;
    }

    public void addAttribute(AttributeDescr attribute) {
        if (this.attributes == Collections.EMPTY_LIST) {
            this.attributes = new ArrayList();
        }
        this.attributes.add(attribute);
    }

    public List getAttributes() {
        return this.attributes;
    }

    public void addFactTemplate(FactTemplateDescr factTemplate) {
        if (this.factTemplates == Collections.EMPTY_LIST) {
            this.factTemplates = new ArrayList(1);
        }
        this.factTemplates.add(factTemplate);
    }

    public List getFactTemplates() {
        return this.factTemplates;
    }

    public void addFunction(FunctionDescr function) {
        if (this.functions == Collections.EMPTY_LIST) {
            this.functions = new ArrayList(1);
        }
        this.functions.add(function);
    }

    public List getFunctions() {
        return this.functions;
    }

    public void addRule(RuleDescr rule) {
        if (this.rules == Collections.EMPTY_LIST) {
            this.rules = new ArrayList(1);
        }
        Iterator iter = this.attributes.iterator();
        while (iter.hasNext()) {
            AttributeDescr at = (AttributeDescr)iter.next();
            boolean overridden = false;
            Iterator iterator = rule.getAttributes().iterator();
            while (iterator.hasNext()) {
                AttributeDescr ruleAt = (AttributeDescr)iterator.next();
                if (!ruleAt.getName().equals(at.getName())) continue;
                overridden = true;
            }
            if (overridden) continue;
            rule.addAttribute(at);
        }
        this.rules.add(rule);
    }

    public List getRules() {
        return this.rules;
    }
}

