/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.xml;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.castor.mapping.BindingType;
import org.castor.mapping.MappingUnmarshaller;
import org.exolab.castor.mapping.Mapping;
import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.mapping.MappingLoader;
import org.exolab.castor.util.Configuration;
import org.exolab.castor.util.LocalConfiguration;
import org.exolab.castor.util.ObjectFactory;
import org.exolab.castor.xml.ClassDescriptorResolverFactory;
import org.exolab.castor.xml.EventProducer;
import org.exolab.castor.xml.IDResolver;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.SAX2EventProducer;
import org.exolab.castor.xml.UnmarshalHandler;
import org.exolab.castor.xml.UnmarshalListener;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.XMLClassDescriptorResolver;
import org.exolab.castor.xml.location.FileLocation;
import org.exolab.castor.xml.util.DOMEventProducer;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class Unmarshaller {
    private static final Log LOG = LogFactory.getLog((Class)(class$org$exolab$castor$xml$Unmarshaller == null ? (class$org$exolab$castor$xml$Unmarshaller = Unmarshaller.class$("org.exolab.castor.xml.Unmarshaller")) : class$org$exolab$castor$xml$Unmarshaller));
    private XMLClassDescriptorResolver _cdResolver = null;
    private Class _class = null;
    private boolean _clearCollections = false;
    private Configuration _config = null;
    private IDResolver _idResolver = null;
    private boolean _ignoreExtraAtts = true;
    private boolean _ignoreExtraElements = false;
    private Object _instanceObj = null;
    EntityResolver entityResolver = null;
    private ClassLoader _loader = null;
    private boolean _reuseObjects = false;
    private UnmarshalListener _unmarshalListener = null;
    private boolean _validate = false;
    private boolean _wsPreserve = false;
    private HashMap _namespaceToPackage = null;
    private ObjectFactory _objectFactory;
    static /* synthetic */ Class class$org$exolab$castor$xml$Unmarshaller;

    public Unmarshaller() {
        this(null, null);
    }

    public Unmarshaller(Class c) {
        this(c, null);
    }

    public Unmarshaller(Class c, ClassLoader loader) {
        this.initConfig();
        this.setClass(c);
        this._loader = loader;
        if (loader == null && c != null) {
            this._loader = c.getClassLoader();
        }
        this._cdResolver = (XMLClassDescriptorResolver)ClassDescriptorResolverFactory.createClassDescriptorResolver(BindingType.XML);
        this._cdResolver.setClassLoader(loader);
    }

    public Unmarshaller(Mapping mapping) throws MappingException {
        this.initConfig();
        if (mapping != null) {
            this.setMapping(mapping);
            this._loader = mapping.getClassLoader();
        }
    }

    public Unmarshaller(Object root) {
        this.initConfig();
        if (root != null) {
            Class<?> clazz = root.getClass();
            this.setClass(clazz);
            this._loader = clazz.getClassLoader();
        }
        this._instanceObj = root;
    }

    private void initConfig() {
        this._config = LocalConfiguration.getInstance();
        this._validate = this._config.marshallingValidation();
        this._ignoreExtraElements = !this._config.strictElements();
        String mappings = this._config.getProperty("org.exolab.castor.xml.nspackages", null);
        if (mappings != null) {
            StringTokenizer tokens = new StringTokenizer(mappings, ",");
            while (tokens.hasMoreTokens()) {
                String token = tokens.nextToken();
                int sepIdx = token.indexOf(61);
                if (sepIdx < 0) continue;
                String ns = token.substring(0, sepIdx).trim();
                String javaPackage = token.substring(sepIdx + 1).trim();
                this.addNamespaceToPackageMapping(ns, javaPackage);
            }
        }
    }

    public void addNamespaceToPackageMapping(String nsURI, String packageName) {
        if (this._namespaceToPackage == null) {
            this._namespaceToPackage = new HashMap();
        }
        if (nsURI == null) {
            nsURI = "";
        }
        if (packageName == null) {
            packageName = "";
        }
        this._namespaceToPackage.put(nsURI, packageName);
    }

    public UnmarshalHandler createHandler() {
        UnmarshalHandler handler = new UnmarshalHandler(this._class);
        if (this._cdResolver == null) {
            this._cdResolver = (XMLClassDescriptorResolver)ClassDescriptorResolverFactory.createClassDescriptorResolver(BindingType.XML);
            this._cdResolver.setClassLoader(this._loader);
        }
        handler.setResolver(this._cdResolver);
        handler.setClearCollections(this._clearCollections);
        handler.setReuseObjects(this._reuseObjects);
        handler.setValidation(this._validate);
        handler.setIgnoreExtraAttributes(this._ignoreExtraAtts);
        handler.setIgnoreExtraElements(this._ignoreExtraElements);
        handler.setConfiguration(this._config);
        handler.setWhitespacePreserve(this._wsPreserve);
        if (this._objectFactory != null) {
            handler.setObjectFactory(this._objectFactory);
        }
        if (this._namespaceToPackage != null) {
            Iterator keys = this._namespaceToPackage.keySet().iterator();
            while (keys.hasNext()) {
                String nsURI = (String)keys.next();
                String pkgName = (String)this._namespaceToPackage.get(nsURI);
                handler.addNamespaceToPackageMapping(nsURI, pkgName);
            }
        }
        if (this._instanceObj != null) {
            handler.setRootObject(this._instanceObj);
        }
        if (this._idResolver != null) {
            handler.setIDResolver(this._idResolver);
        }
        if (this._loader != null) {
            handler.setClassLoader(this._loader);
        }
        if (this._unmarshalListener != null) {
            handler.setUnmarshalListener(this._unmarshalListener);
        }
        return handler;
    }

    public boolean isValidating() {
        return this._validate;
    }

    public void setClass(Class clazz) {
        this._class = clazz;
    }

    public void setObject(Object root) {
        this._instanceObj = root;
    }

    public void setClassLoader(ClassLoader loader) {
        this._loader = loader;
    }

    public void setClearCollections(boolean clear) {
        this._clearCollections = clear;
    }

    public void setDebug(boolean debug) {
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this.entityResolver = entityResolver;
    }

    public void setIDResolver(IDResolver idResolver) {
        this._idResolver = idResolver;
    }

    public void setIgnoreExtraAttributes(boolean ignoreExtraAtts) {
        this._ignoreExtraAtts = ignoreExtraAtts;
    }

    public void setIgnoreExtraElements(boolean ignoreExtraElements) {
        this._ignoreExtraElements = ignoreExtraElements;
    }

    public void setLogWriter(PrintWriter printWriter) {
    }

    public void setMapping(Mapping mapping) throws MappingException {
        if (this._loader == null) {
            this._loader = mapping.getClassLoader();
        }
        if (this._cdResolver == null) {
            this._cdResolver = (XMLClassDescriptorResolver)ClassDescriptorResolverFactory.createClassDescriptorResolver(BindingType.XML);
            this._cdResolver.setClassLoader(this._loader);
        }
        MappingUnmarshaller mum = new MappingUnmarshaller();
        MappingLoader resolver = mum.getMappingLoader(mapping, BindingType.XML);
        this._cdResolver.setMappingLoader(resolver);
    }

    public void setReuseObjects(boolean reuse) {
        this._reuseObjects = reuse;
    }

    public void setResolver(XMLClassDescriptorResolver cdr) {
        if (cdr != null) {
            this._cdResolver = cdr;
        } else {
            this._cdResolver = (XMLClassDescriptorResolver)ClassDescriptorResolverFactory.createClassDescriptorResolver(BindingType.XML);
            this._cdResolver.setClassLoader(this._loader);
        }
    }

    public void setUnmarshalListener(UnmarshalListener listener) {
        this._unmarshalListener = listener;
    }

    public void setValidation(boolean validate) {
        this._validate = validate;
    }

    public void setWhitespacePreserve(boolean preserve) {
        this._wsPreserve = preserve;
    }

    public Object unmarshal(Reader reader) throws MarshalException, ValidationException {
        return this.unmarshal(new InputSource(reader));
    }

    public Object unmarshal(EventProducer eventProducer) throws MarshalException, ValidationException {
        UnmarshalHandler handler = this.createHandler();
        eventProducer.setDocumentHandler(handler);
        try {
            eventProducer.start();
        }
        catch (SAXException sx) {
            this.convertSAXExceptionToMarshalException(handler, sx);
        }
        return handler.getObject();
    }

    public Object unmarshal(SAX2EventProducer eventProducer) throws MarshalException, ValidationException {
        UnmarshalHandler handler = this.createHandler();
        eventProducer.setContentHandler(handler);
        try {
            eventProducer.start();
        }
        catch (SAXException sx) {
            this.convertSAXExceptionToMarshalException(handler, sx);
        }
        return handler.getObject();
    }

    public Object unmarshal(InputSource source) throws MarshalException, ValidationException {
        XMLReader reader = null;
        Parser parser = null;
        try {
            reader = this._config.getXMLReader();
            if (this.entityResolver != null) {
                reader.setEntityResolver(this.entityResolver);
            }
        }
        catch (RuntimeException rx) {
            LOG.debug((Object)"Unable to create SAX XMLReader, attempting SAX Parser.");
        }
        if (reader == null) {
            parser = this._config.getParser();
            if (parser == null) {
                throw new MarshalException("Unable to create SAX Parser.");
            }
            if (this.entityResolver != null) {
                parser.setEntityResolver(this.entityResolver);
            }
        }
        UnmarshalHandler handler = this.createHandler();
        try {
            if (reader != null) {
                reader.setContentHandler(handler);
                reader.setErrorHandler(handler);
                reader.parse(source);
            } else {
                parser.setDocumentHandler(handler);
                parser.setErrorHandler(handler);
                parser.parse(source);
            }
        }
        catch (IOException ioe) {
            throw new MarshalException(ioe);
        }
        catch (SAXException sx) {
            this.convertSAXExceptionToMarshalException(handler, sx);
        }
        return handler.getObject();
    }

    public Object unmarshal(Node node) throws MarshalException, ValidationException {
        return this.unmarshal(new DOMEventProducer(node));
    }

    private void convertSAXExceptionToMarshalException(UnmarshalHandler handler, SAXException sex) throws MarshalException {
        Exception except = sex.getException();
        if (except == null) {
            except = sex;
        }
        MarshalException marshalEx = new MarshalException(except);
        if (handler.getDocumentLocator() != null) {
            FileLocation location = new FileLocation();
            location.setFilename(handler.getDocumentLocator().getSystemId());
            location.setLineNumber(handler.getDocumentLocator().getLineNumber());
            location.setColumnNumber(handler.getDocumentLocator().getColumnNumber());
            marshalEx.setLocation(location);
        }
        throw marshalEx;
    }

    public static ContentHandler getContentHandler(UnmarshalHandler handler) throws SAXException {
        return handler;
    }

    public static Object unmarshal(Class c, Reader reader) throws MarshalException, ValidationException {
        Unmarshaller unmarshaller = new Unmarshaller(c);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"*static* unmarshal method called, this will ignore any mapping files or changes made to an Unmarshaller instance.");
        }
        unmarshaller.setWhitespacePreserve(true);
        return unmarshaller.unmarshal(reader);
    }

    public static Object unmarshal(Class c, InputSource source) throws MarshalException, ValidationException {
        Unmarshaller unmarshaller = new Unmarshaller(c);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"*static* unmarshal method called, this will ignore any mapping files or changes made to an Unmarshaller instance.");
        }
        unmarshaller.setWhitespacePreserve(true);
        return unmarshaller.unmarshal(source);
    }

    public static Object unmarshal(Class c, Node node) throws MarshalException, ValidationException {
        Unmarshaller unmarshaller = new Unmarshaller(c);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"*static* unmarshal method called, this will ignore any mapping files or changes made to an Unmarshaller instance.");
        }
        unmarshaller.setWhitespacePreserve(true);
        return unmarshaller.unmarshal(node);
    }

    public void setObjectFactory(ObjectFactory objectFactory) {
        this._objectFactory = objectFactory;
    }

    public String getProperty(String name) {
        return this._config.getProperties().getProperty(name);
    }

    public void setProperty(String name, String value) {
        this._config.getProperties().setProperty(name, value);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

