/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.types;

import java.io.Serializable;
import java.text.ParseException;
import org.exolab.castor.types.OperationNotSupportedException;
import org.exolab.castor.types.RecurringDuration;
import org.exolab.castor.types.TimeDuration;
import org.exolab.castor.xml.ValidationException;

public abstract class RecurringDurationBase
implements Serializable {
    private TimeDuration _period = null;
    private TimeDuration _duration = null;
    private short _hour = 0;
    private short _minute = 0;
    private short _second = 0;
    private short _millsecond = 0;
    private short _zoneHour = 0;
    private short _zoneMinute = 0;
    private boolean _UTC = false;
    private boolean _zoneNegative = false;
    private boolean _isNegative = false;

    protected RecurringDurationBase() {
    }

    protected RecurringDurationBase(TimeDuration duration, TimeDuration period) {
        try {
            this.setDuration(duration);
            this.setPeriodInternal(period);
        }
        catch (OperationNotSupportedException e) {
            String err = "Recurring Duration: " + e;
            throw new IllegalArgumentException(err);
        }
    }

    protected RecurringDurationBase(String duration, String period) throws IllegalArgumentException {
        try {
            this.setDuration(TimeDuration.parseTimeDuration(duration));
            this.setPeriodInternal(TimeDuration.parseTimeDuration(period));
        }
        catch (Exception e) {
            String err = "In RecurringDurationBase: " + e;
            throw new IllegalArgumentException(err);
        }
    }

    protected RecurringDurationBase(String duration, String period, short[] values) throws OperationNotSupportedException {
        new RecurringDuration(duration, period);
        if (values.length != 6) {
            throw new IllegalArgumentException("Wrong numbers of values");
        }
        this.setValues(values);
    }

    private void setPeriodInternal(TimeDuration period) {
        this._period = period;
    }

    public void setPeriod(TimeDuration period) throws OperationNotSupportedException {
        this.setPeriodInternal(period);
    }

    public void setPeriod(String period) throws OperationNotSupportedException {
        try {
            this.setPeriodInternal(TimeDuration.parseTimeDuration(period));
        }
        catch (ParseException e) {
            String err = "RecurringDuration, setPeriod: " + e;
            throw new IllegalArgumentException(err);
        }
    }

    public void setDuration(TimeDuration duration) throws OperationNotSupportedException {
        this._duration = duration;
    }

    public void setDuration(String duration) throws OperationNotSupportedException {
        try {
            this._duration = TimeDuration.parseTimeDuration(duration);
        }
        catch (ParseException e) {
            String err = "RecurringDuration, setDuration: " + e;
            throw new IllegalArgumentException(err);
        }
    }

    public void setHour(short hour) throws OperationNotSupportedException {
        String err = "";
        if (hour > 23) {
            err = "the hour field (" + hour + ")must be strictly lower than 24";
            throw new IllegalArgumentException(err);
        }
        this._hour = hour;
    }

    public void setMinute(short minute) throws OperationNotSupportedException {
        String err = "";
        if (minute == -1 && this._hour != -1) {
            err = "minute cannot be omitted if the previous field is not omitted.";
            throw new IllegalArgumentException(err);
        }
        if (minute > 59) {
            err = "the minute field (" + minute + ") must be lower than 59";
            throw new IllegalArgumentException(err);
        }
        this._minute = minute;
    }

    public void setSecond(short second, short millsecond) throws OperationNotSupportedException {
        String err = "";
        if (second == -1 && this._minute != -1) {
            err = "second cannot be omitted if the previous field is not omitted.";
            throw new IllegalArgumentException(err);
        }
        if (second > 60) {
            err = "the second field (" + second + ")must be lower than 60";
            throw new IllegalArgumentException(err);
        }
        this._second = second;
        this._millsecond = millsecond;
    }

    public void setZone(short hour, short minute) throws OperationNotSupportedException {
        String err = "";
        if (hour > 23) {
            err = "the zone hour field (" + hour + ")must be strictly lower than 24";
            throw new IllegalArgumentException(err);
        }
        this._zoneHour = hour;
        if (minute > 59) {
            err = "the minute field (" + minute + ")must be lower than 59";
            throw new IllegalArgumentException(err);
        }
        this._zoneMinute = minute;
    }

    public void setValues(short[] values) throws OperationNotSupportedException {
        this.setHour(values[0]);
        this.setMinute(values[1]);
        this.setSecond(values[2], values[3]);
        this.setZone(values[4], values[5]);
    }

    public void setNegative() {
        this._isNegative = true;
    }

    public void setZoneNegative() throws OperationNotSupportedException {
        this._zoneNegative = true;
    }

    public void setUTC() {
        this._UTC = true;
    }

    public TimeDuration getPeriod() {
        return this._period;
    }

    public TimeDuration getDuration() {
        return this._duration;
    }

    public short getHour() {
        return this._hour;
    }

    public short getMinute() {
        return this._minute;
    }

    public short getSeconds() {
        return this._second;
    }

    public short getMilli() {
        return this._millsecond;
    }

    public short getZoneHour() {
        return this._zoneHour;
    }

    public short getZoneMinute() {
        return this._zoneMinute;
    }

    public short[] getValues() {
        short[] result = new short[]{this.getHour(), this.getMinute(), this.getSeconds(), this.getMilli(), this.getZoneHour(), this.getZoneMinute()};
        return result;
    }

    public boolean isUTC() {
        this._UTC = this._zoneHour == 0 && this._zoneMinute == 0;
        return this._UTC;
    }

    public boolean isNegative() {
        return this._isNegative;
    }

    public boolean isZoneNegative() {
        return this._zoneNegative;
    }

    public boolean equals(Object object) {
        if (object instanceof RecurringDurationBase) {
            try {
                return this.equal((RecurringDurationBase)object);
            }
            catch (ValidationException e) {
                e.printStackTrace();
                return false;
            }
        }
        return false;
    }

    public boolean equal(RecurringDurationBase reccD) throws ValidationException {
        boolean result = false;
        if (!this.getPeriod().equals(reccD.getPeriod()) || !this.getDuration().equals(reccD.getDuration())) {
            String err = "Recurring Duration which have different values for the duration and period can not be compared";
            throw new ValidationException(err);
        }
        result = this.getHour() == reccD.getHour();
        result = result && this.getMinute() == reccD.getMinute();
        result = result && this.getSeconds() == reccD.getSeconds();
        result = result && this.getMilli() == reccD.getMilli();
        boolean bl = result = result && this.isNegative() == this.isNegative();
        if (!reccD.isUTC()) {
            result = result && !this.isUTC();
            result = result && this.getZoneHour() == reccD.getZoneHour();
            result = result && this.getZoneMinute() == reccD.getZoneMinute();
        }
        return result;
    }

    public boolean isGreater(RecurringDurationBase reccD) throws ValidationException {
        if (!this.getPeriod().equals(reccD.getPeriod()) || !this.getDuration().equals(reccD.getDuration())) {
            String err = "Recurring Duration which have different values for the duration and period can not be compared";
            throw new ValidationException(err);
        }
        boolean result = false;
        short[] val_this = this.getValues();
        short[] val_reccD = reccD.getValues();
        for (int i = 0; !result || i < val_this.length; ++i) {
            boolean bl = result = val_this[i] > val_reccD[i];
            if (val_this[i] >= val_reccD[i]) continue;
            return false;
        }
        return result;
    }
}

