/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.snmp.snmp4j;

import java.net.InetAddress;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.snmp.SnmpObjId;
import org.opennms.netmgt.snmp.SnmpValue;
import org.opennms.netmgt.snmp.TrapIdentity;
import org.opennms.netmgt.snmp.TrapInformation;
import org.opennms.netmgt.snmp.TrapNotification;
import org.opennms.netmgt.snmp.TrapNotificationListener;
import org.opennms.netmgt.snmp.TrapProcessor;
import org.opennms.netmgt.snmp.TrapProcessorFactory;
import org.opennms.netmgt.snmp.snmp4j.Snmp4JValue;
import org.snmp4j.CommandResponder;
import org.snmp4j.CommandResponderEvent;
import org.snmp4j.MessageException;
import org.snmp4j.PDU;
import org.snmp4j.PDUv1;
import org.snmp4j.mp.StateReference;
import org.snmp4j.mp.StatusInformation;
import org.snmp4j.smi.Integer32;
import org.snmp4j.smi.IpAddress;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.TimeTicks;
import org.snmp4j.smi.Variable;
import org.snmp4j.smi.VariableBinding;

public class Snmp4JTrapNotifier
implements CommandResponder {
    private TrapProcessorFactory m_trapProcessorFactory;
    private TrapNotificationListener m_listener;

    public Snmp4JTrapNotifier(TrapNotificationListener listener, TrapProcessorFactory processorFactory) {
        this.m_listener = listener;
        this.m_trapProcessorFactory = processorFactory;
    }

    public void processPdu(CommandResponderEvent e) {
        PDU command = new PDU(e.getPDU());
        IpAddress addr = (IpAddress)e.getPeerAddress();
        if (command != null && command.getType() == -90) {
            PDU response = new PDU(command);
            response.setErrorIndex(0);
            response.setErrorStatus(0);
            response.setType(-94);
            StatusInformation statusInformation = new StatusInformation();
            StateReference ref = e.getStateReference();
            try {
                e.getMessageDispatcher().returnResponsePdu(e.getMessageProcessingModel(), e.getSecurityModel(), e.getSecurityName(), e.getSecurityLevel(), response, e.getMaxSizeResponsePDU(), ref, statusInformation);
                if (this.log().isDebugEnabled()) {
                    this.log().debug("Sent RESPONSE PDU to peer " + addr + " acknowledging receipt of INFORM (reqId=" + command.getRequestID() + ")");
                }
            }
            catch (MessageException ex) {
                this.log().error("Error while sending RESPONSE PDU to peer " + addr + ": " + ex.getMessage() + "acknowledging receipt of INFORM (reqId=" + command.getRequestID() + ")");
            }
        }
        if (e.getPDU() instanceof PDUv1) {
            this.m_listener.trapReceived((TrapNotification)new Snmp4JV1TrapInformation(addr.getInetAddress(), new String(e.getSecurityName()), (PDUv1)e.getPDU(), this.m_trapProcessorFactory.createTrapProcessor()));
        } else {
            this.m_listener.trapReceived((TrapNotification)new Snmp4JV2TrapInformation(addr.getInetAddress(), new String(e.getSecurityName()), e.getPDU(), this.m_trapProcessorFactory.createTrapProcessor()));
        }
    }

    private ThreadCategory log() {
        return ThreadCategory.getInstance(this.getClass());
    }

    public static class Snmp4JV2TrapInformation
    extends TrapInformation {
        private PDU m_pdu;
        private String m_pduTypeString;
        static final int SNMP_SYSUPTIME_OID_INDEX = 0;
        static final int SNMP_TRAP_OID_INDEX = 1;
        static final OID SNMP_SYSUPTIME_OID = new OID(".1.3.6.1.2.1.1.3.0");
        static final OID EXTREME_SNMP_SYSUPTIME_OID = new OID(".1.3.6.1.2.1.1.3");
        static final OID SNMP_TRAP_OID = new OID(".1.3.6.1.6.3.1.1.4.1.0");

        public Snmp4JV2TrapInformation(InetAddress agent, String community, PDU pdu, TrapProcessor trapProcessor) {
            super(agent, community, trapProcessor);
            this.m_pdu = pdu;
            this.m_pduTypeString = PDU.getTypeString((int)this.m_pdu.getType());
        }

        private PDU getPdu() {
            return this.m_pdu;
        }

        protected int getPduLength() {
            return this.getPdu().size();
        }

        protected long getTimeStamp() {
            if (this.log().isDebugEnabled()) {
                this.log().debug("V2 " + this.m_pduTypeString + " first varbind value: " + this.getVarBindAt(0).getVariable().toString());
            }
            switch (this.getVarBindAt(0).getVariable().getSyntax()) {
                case 67: {
                    this.log().debug("V2 " + this.m_pduTypeString + " first varbind value is of type TIMETICKS (correct)");
                    return ((TimeTicks)this.getVarBindAt(0).getVariable()).getValue();
                }
                case 2: {
                    this.log().debug("V2 " + this.m_pduTypeString + " first varbind value is of type INTEGER, casting to TIMETICKS");
                    return ((Integer32)this.getVarBindAt(0).getVariable()).getValue();
                }
            }
            throw new IllegalArgumentException("V2 " + this.m_pduTypeString + " does not have the required first varbind as TIMETICKS - cannot process " + this.m_pduTypeString);
        }

        protected TrapIdentity getTrapIdentity() {
            OID snmpTrapOid = (OID)this.getVarBindAt(1).getVariable();
            OID lastVarBindOid = this.getVarBindAt(this.getPduLength() - 1).getOid();
            Variable lastVarBindValue = this.getVarBindAt(this.getPduLength() - 1).getVariable();
            return new TrapIdentity(SnmpObjId.get((int[])snmpTrapOid.getValue()), SnmpObjId.get((int[])lastVarBindOid.getValue()), (SnmpValue)new Snmp4JValue(lastVarBindValue));
        }

        public InetAddress getTrapAddress() {
            return this.getAgentAddress();
        }

        protected VariableBinding getVarBindAt(int index) {
            return this.getPdu().get(index);
        }

        protected String getVersion() {
            return "v2";
        }

        protected void validate() {
            int pduType = this.getPdu().getType();
            if (pduType != -89 && pduType != -90) {
                throw new IllegalArgumentException("Received not SNMPv2 Trap|Inform from host " + this.getTrapAddress() + " PDU Type = " + PDU.getTypeString((int)this.getPdu().getType()));
            }
            if (this.log().isDebugEnabled()) {
                this.log().debug("V2 " + this.m_pduTypeString + " numVars or pdu length: " + this.getPduLength());
            }
            if (this.getPduLength() < 2) {
                throw new IllegalArgumentException("V2 " + this.m_pduTypeString + " from " + this.getTrapAddress() + " IGNORED due to not having the required varbinds.  Have " + this.getPduLength() + ", needed at least 2");
            }
            OID varBindName0 = this.getVarBindAt(0).getOid();
            OID varBindName1 = this.getVarBindAt(1).getOid();
            if (varBindName0.equals((Object)EXTREME_SNMP_SYSUPTIME_OID)) {
                this.log().info("V2 " + this.m_pduTypeString + " from " + this.getTrapAddress() + " has been corrected due to the sysUptime.0 varbind not having been sent with a trailing 0.\n\tVarbinds received are : " + varBindName0 + " and " + varBindName1);
                varBindName0 = SNMP_SYSUPTIME_OID;
            }
            if (!varBindName0.equals((Object)SNMP_SYSUPTIME_OID) || !varBindName1.equals((Object)SNMP_TRAP_OID)) {
                throw new IllegalArgumentException("V2 " + this.m_pduTypeString + " from " + this.getTrapAddress() + " IGNORED due to not having the required varbinds.\n\tThe first varbind must be sysUpTime.0 and the second snmpTrapOID.0\n\tVarbinds received are : " + varBindName0 + " and " + varBindName1);
            }
        }

        protected void processVarBindAt(int i) {
            if (i == 0) {
                this.log().debug("Skipping processing of varbind " + i + ": it is sysuptime and the first varbind, and is not processed as a parm per RFC2089");
            } else if (i == 1) {
                this.log().debug("Skipping processing of varbind " + i + ": it is the trap OID and the second varbind, and is not processed as a parm per RFC2089");
            } else {
                SnmpObjId name = SnmpObjId.get((int[])this.getVarBindAt(i).getOid().getValue());
                Snmp4JValue value = new Snmp4JValue(this.getVarBindAt(i).getVariable());
                this.processVarBind(name, value);
            }
        }
    }

    public static class Snmp4JV1TrapInformation
    extends TrapInformation {
        private PDUv1 m_pdu;

        protected Snmp4JV1TrapInformation(InetAddress agent, String community, PDUv1 pdu, TrapProcessor trapProcessor) {
            super(agent, community, trapProcessor);
            this.m_pdu = pdu;
        }

        protected InetAddress getTrapAddress() {
            return this.m_pdu.getAgentAddress().getInetAddress();
        }

        protected String getVersion() {
            return "v1";
        }

        protected int getPduLength() {
            return this.m_pdu.getVariableBindings().size();
        }

        protected long getTimeStamp() {
            return this.m_pdu.getTimestamp();
        }

        protected TrapIdentity getTrapIdentity() {
            return new TrapIdentity(SnmpObjId.get((int[])this.m_pdu.getEnterprise().getValue()), this.m_pdu.getGenericTrap(), this.m_pdu.getSpecificTrap());
        }

        protected VariableBinding getVarBindAt(int i) {
            return this.m_pdu.get(i);
        }

        protected void processVarBindAt(int i) {
            SnmpObjId name = SnmpObjId.get((int[])this.getVarBindAt(i).getOid().getValue());
            Snmp4JValue value = new Snmp4JValue(this.getVarBindAt(i).getVariable());
            this.processVarBind(name, value);
        }
    }
}

