/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.ping;

import java.io.IOException;
import java.net.InetAddress;
import java.util.List;
import org.opennms.netmgt.ping.IcmpMessenger;
import org.opennms.netmgt.ping.ParallelPingResponseCallback;
import org.opennms.netmgt.ping.PingReply;
import org.opennms.netmgt.ping.PingRequest;
import org.opennms.netmgt.ping.PingResponseCallback;
import org.opennms.netmgt.ping.SinglePingResponseCallback;
import org.opennms.protocols.rt.IDBasedRequestLocator;
import org.opennms.protocols.rt.Messenger;
import org.opennms.protocols.rt.Request;
import org.opennms.protocols.rt.RequestLocator;
import org.opennms.protocols.rt.RequestTracker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Pinger {
    private static RequestTracker<PingRequest, PingReply> s_pingTracker;

    public static synchronized void initialize() throws IOException {
        if (s_pingTracker != null) {
            return;
        }
        s_pingTracker = new RequestTracker("ICMP", (Messenger)new IcmpMessenger(), (RequestLocator)new IDBasedRequestLocator());
        s_pingTracker.start();
    }

    public static void ping(InetAddress host, long timeout, int retries, short sequenceId, PingResponseCallback cb) throws Exception {
        Pinger.initialize();
        s_pingTracker.sendRequest((Request)new PingRequest(host, sequenceId, timeout, retries, cb));
    }

    public static Long ping(InetAddress host, long timeout, int retries) throws Exception {
        SinglePingResponseCallback cb = new SinglePingResponseCallback(host);
        Pinger.ping(host, timeout, retries, (short)1, cb);
        cb.waitFor();
        return cb.getResponseTime();
    }

    public static Long ping(InetAddress host) throws Exception {
        SinglePingResponseCallback cb = new SinglePingResponseCallback(host);
        Pinger.ping(host, 800L, 2, (short)1, cb);
        cb.waitFor();
        return cb.getResponseTime();
    }

    public static List<Number> parallelPing(InetAddress host, int count, long timeout, long pingInterval) throws Exception {
        Pinger.initialize();
        ParallelPingResponseCallback cb = new ParallelPingResponseCallback(count);
        if (timeout == 0L) {
            timeout = 800L;
        }
        for (int i = 0; i < count; ++i) {
            PingRequest request = new PingRequest(host, (short)i, timeout, 0, cb);
            s_pingTracker.sendRequest((Request)request);
            Thread.sleep(pingInterval);
        }
        cb.waitFor();
        return cb.getResponseTimes();
    }
}

