/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.support;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.opennms.core.utils.BundleLists;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.dao.GraphDao;
import org.opennms.netmgt.dao.support.FileReloadCallback;
import org.opennms.netmgt.dao.support.FileReloadContainer;
import org.opennms.netmgt.model.AdhocGraphType;
import org.opennms.netmgt.model.OnmsResource;
import org.opennms.netmgt.model.PrefabGraph;
import org.opennms.netmgt.model.PrefabGraphType;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.Resource;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.orm.ObjectRetrievalFailureException;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertiesGraphDao
implements GraphDao,
InitializingBean {
    public static final String DEFAULT_GRAPH_LIST_KEY = "reports";
    private Map<String, Resource> m_prefabConfigs;
    private Map<String, Resource> m_adhocConfigs;
    private Map<String, FileReloadContainer<PrefabGraphType>> m_types = new HashMap<String, FileReloadContainer<PrefabGraphType>>();
    private HashMap<String, FileReloadContainer<AdhocGraphType>> m_adhocTypes = new HashMap();
    private PrefabGraphTypeCallback m_prefabCallback = new PrefabGraphTypeCallback();
    private AdhocGraphTypeCallback m_adhocCallback = new AdhocGraphTypeCallback();

    private void initPrefab() throws IOException {
        for (Map.Entry<String, Resource> configEntry : this.m_prefabConfigs.entrySet()) {
            this.loadProperties(configEntry.getKey(), configEntry.getValue());
        }
    }

    private void initAdhoc() throws IOException {
        for (Map.Entry<String, Resource> configEntry : this.m_adhocConfigs.entrySet()) {
            this.loadAdhocProperties(configEntry.getKey(), configEntry.getValue());
        }
    }

    @Override
    public PrefabGraphType findByName(String name) {
        return this.m_types.get(name).getObject();
    }

    @Override
    public AdhocGraphType findAdhocByName(String name) {
        return this.m_adhocTypes.get(name).getObject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadProperties(String type, Resource resource) throws IOException {
        PrefabGraphType t;
        InputStream in = resource.getInputStream();
        try {
            t = this.createPrefabGraphType(type, in);
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
        }
        this.m_types.put(t.getName(), new FileReloadContainer<PrefabGraphType>(t, resource, this.m_prefabCallback));
    }

    public void loadProperties(String type, InputStream in) throws IOException {
        PrefabGraphType t = this.createPrefabGraphType(type, in);
        this.m_types.put(t.getName(), new FileReloadContainer<PrefabGraphType>(t));
    }

    private PrefabGraphType createPrefabGraphType(String type, InputStream in) throws IOException {
        Properties properties = new Properties();
        properties.load(in);
        PrefabGraphType t = new PrefabGraphType();
        t.setName(type);
        t.setCommandPrefix(PropertiesGraphDao.getProperty(properties, "command.prefix"));
        t.setOutputMimeType(PropertiesGraphDao.getProperty(properties, "output.mime"));
        t.setDefaultReport(properties.getProperty("default.report", "none"));
        t.setReportMap(this.getPrefabGraphDefinitions(properties));
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadAdhocProperties(String type, Resource resource) throws IOException {
        AdhocGraphType t;
        InputStream in = resource.getInputStream();
        try {
            t = this.createAdhocGraphType(type, in);
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
        }
        this.m_adhocTypes.put(t.getName(), new FileReloadContainer<AdhocGraphType>(t, resource, this.m_adhocCallback));
    }

    public void loadAdhocProperties(String type, InputStream in) throws IOException {
        AdhocGraphType t = this.createAdhocGraphType(type, in);
        this.m_adhocTypes.put(t.getName(), new FileReloadContainer<AdhocGraphType>(t));
    }

    public AdhocGraphType createAdhocGraphType(String type, InputStream in) throws IOException {
        Properties properties = new Properties();
        properties.load(in);
        AdhocGraphType t = new AdhocGraphType();
        t.setName(type);
        t.setCommandPrefix(PropertiesGraphDao.getProperty(properties, "command.prefix"));
        t.setOutputMimeType(PropertiesGraphDao.getProperty(properties, "output.mime"));
        t.setTitleTemplate(PropertiesGraphDao.getProperty(properties, "adhoc.command.title"));
        t.setDataSourceTemplate(PropertiesGraphDao.getProperty(properties, "adhoc.command.ds"));
        t.setGraphLineTemplate(PropertiesGraphDao.getProperty(properties, "adhoc.command.graphline"));
        return t;
    }

    private Map<String, PrefabGraph> getPrefabGraphDefinitions(Properties properties) {
        Assert.notNull((Object)properties, (String)"properties argument cannot be null");
        String listString = PropertiesGraphDao.getProperty(properties, DEFAULT_GRAPH_LIST_KEY);
        String[] list = BundleLists.parseBundleList((String)listString);
        LinkedHashMap<String, PrefabGraph> map = new LinkedHashMap<String, PrefabGraph>();
        for (int i = 0; i < list.length; ++i) {
            String key = list[i];
            PrefabGraph graph = PropertiesGraphDao.makePrefabGraph(key, properties, i);
            map.put(key, graph);
        }
        return map;
    }

    private static PrefabGraph makePrefabGraph(String key, Properties props, int order) {
        Assert.notNull((Object)key, (String)"key argument cannot be null");
        Assert.notNull((Object)props, (String)"props argument cannot be null");
        String title = PropertiesGraphDao.getReportProperty(props, key, "name", true);
        String command = PropertiesGraphDao.getReportProperty(props, key, "command", true);
        String columnString = PropertiesGraphDao.getReportProperty(props, key, "columns", true);
        String[] columns = BundleLists.parseBundleList((String)columnString);
        String externalValuesString = PropertiesGraphDao.getReportProperty(props, key, "externalValues", false);
        String[] externalValues = externalValuesString == null ? new String[]{} : BundleLists.parseBundleList((String)externalValuesString);
        String propertiesValuesString = PropertiesGraphDao.getReportProperty(props, key, "propertiesValues", false);
        String[] propertiesValues = propertiesValuesString == null ? new String[]{} : BundleLists.parseBundleList((String)propertiesValuesString);
        String typesString = PropertiesGraphDao.getReportProperty(props, key, "type", false);
        String[] types = typesString == null ? new String[]{} : BundleLists.parseBundleList((String)typesString);
        String description = PropertiesGraphDao.getReportProperty(props, key, "description", false);
        Integer graphWidth = PropertiesGraphDao.getIntegerReportProperty(props, key, "width", false);
        Integer graphHeight = PropertiesGraphDao.getIntegerReportProperty(props, key, "height", false);
        String suppressString = PropertiesGraphDao.getReportProperty(props, key, "suppress", false);
        String[] suppress = suppressString == null ? new String[]{} : BundleLists.parseBundleList((String)suppressString);
        return new PrefabGraph(key, title, columns, command, externalValues, propertiesValues, order, types, description, graphWidth, graphHeight, suppress);
    }

    private static String getProperty(Properties props, String name) {
        String property = props.getProperty(name);
        if (property == null) {
            throw new DataAccessResourceFailureException("Properties must contain '" + name + "' property");
        }
        return property;
    }

    private static String getReportProperty(Properties props, String key, String suffix, boolean required) {
        String propertyName = "report." + key + "." + suffix;
        String property = props.getProperty(propertyName);
        if (property == null && required) {
            throw new DataAccessResourceFailureException("Properties for report '" + key + "' must contain '" + propertyName + "' property");
        }
        return property;
    }

    private static Integer getIntegerReportProperty(Properties props, String key, String suffix, boolean required) {
        String value = PropertiesGraphDao.getReportProperty(props, key, suffix, required);
        if (value == null) {
            return null;
        }
        try {
            return new Integer(value);
        }
        catch (NumberFormatException e) {
            throw new DataAccessResourceFailureException("Property value for '" + suffix + "' on report '" + key + "' must be an integer.  '" + value + "' is not a valid value");
        }
    }

    private ThreadCategory log() {
        return ThreadCategory.getInstance();
    }

    @Override
    public List<PrefabGraph> getAllPrefabGraphs() {
        ArrayList<PrefabGraph> graphs = new ArrayList<PrefabGraph>();
        for (FileReloadContainer<PrefabGraphType> container : this.m_types.values()) {
            graphs.addAll(container.getObject().getReportMap().values());
        }
        return graphs;
    }

    @Override
    public PrefabGraph getPrefabGraph(String name) {
        for (FileReloadContainer<PrefabGraphType> container : this.m_types.values()) {
            PrefabGraph graph = container.getObject().getQuery(name);
            if (graph == null) continue;
            return graph;
        }
        throw new ObjectRetrievalFailureException(PrefabGraph.class, (Object)name, "Could not find prefabricated graph report with name '" + name + "'", null);
    }

    @Override
    public PrefabGraph[] getPrefabGraphsForResource(OnmsResource resource) {
        Set attributes = resource.getAttributes();
        if (attributes.size() == 0) {
            this.log().debug("returning empty graph list for resource " + resource + " because its attribute list is empty");
            return new PrefabGraph[0];
        }
        Set<String> availableRrdAttributes = resource.getRrdGraphAttributes().keySet();
        Set<String> availableStringAttributes = resource.getStringPropertyAttributes().keySet();
        Set<String> availableExternalAttributes = resource.getExternalValueAttributes().keySet();
        if (availableRrdAttributes.size() == 0) {
            this.log().debug("returning empty graph list for resource " + resource + " because it has no RRD attributes");
            return new PrefabGraph[0];
        }
        String resourceType = resource.getResourceType().getName();
        LinkedHashMap<String, PrefabGraph> returnList = new LinkedHashMap<String, PrefabGraph>();
        for (PrefabGraph query : this.getAllPrefabGraphs()) {
            if (resourceType != null && !query.hasMatchingType(new String[]{resourceType})) {
                if (!this.log().isDebugEnabled()) continue;
                this.log().debug("skipping " + query.getName() + " because its types \"" + StringUtils.arrayToDelimitedString((Object[])query.getTypes(), (String)", ") + "\" does not match resourceType \"" + resourceType + "\"");
                continue;
            }
            if (!this.verifyAttributesExist(query, "RRD", Arrays.asList(query.getColumns()), availableRrdAttributes) || !this.verifyAttributesExist(query, "string property", Arrays.asList(query.getPropertiesValues()), availableStringAttributes) || !this.verifyAttributesExist(query, "external value", Arrays.asList(query.getExternalValues()), availableExternalAttributes)) continue;
            if (this.log().isDebugEnabled()) {
                this.log().debug("adding " + query.getName() + " to query list");
            }
            returnList.put(query.getName(), query);
        }
        if (this.log().isDebugEnabled()) {
            ArrayList<String> nameList = new ArrayList<String>(returnList.size());
            for (PrefabGraph graph : returnList.values()) {
                nameList.add(graph.getName());
            }
            this.log().debug("found " + nameList.size() + " prefabricated graphs for resource " + resource + ": " + StringUtils.collectionToDelimitedString(nameList, (String)", "));
        }
        HashSet<String> suppressReports = new HashSet<String>();
        for (Map.Entry entry : returnList.entrySet()) {
            suppressReports.addAll(Arrays.asList(((PrefabGraph)entry.getValue()).getSuppress()));
        }
        suppressReports.retainAll(returnList.keySet());
        if (suppressReports.size() > 0 && this.log().isDebugEnabled()) {
            this.log().debug("suppressing " + suppressReports.size() + " prefabricated graphs for resource " + resource + ": " + StringUtils.collectionToDelimitedString(suppressReports, (String)", "));
        }
        for (String suppressReport : suppressReports) {
            returnList.remove(suppressReport);
        }
        return returnList.values().toArray(new PrefabGraph[returnList.size()]);
    }

    private boolean verifyAttributesExist(PrefabGraph query, String type, List<String> requiredList, Set<String> availableRrdAttributes) {
        if (availableRrdAttributes.containsAll(requiredList)) {
            return true;
        }
        if (this.log().isDebugEnabled()) {
            String name = query.getName();
            this.log().debug("not adding " + name + " to prefab graph list because the required list of " + type + " attributes (" + StringUtils.collectionToDelimitedString(requiredList, (String)", ") + ") is not in the list of " + type + " attributes on the resource (" + StringUtils.collectionToDelimitedString(availableRrdAttributes, (String)", ") + ")");
        }
        return false;
    }

    public void afterPropertiesSet() throws IOException {
        Assert.notNull(this.m_prefabConfigs, (String)"property prefabConfigs must be set to a non-null value");
        Assert.notNull(this.m_adhocConfigs, (String)"property adhocConfigs must be set to a non-null value");
        this.initPrefab();
        this.initAdhoc();
    }

    public Map<String, Resource> getAdhocConfigs() {
        return this.m_adhocConfigs;
    }

    public void setAdhocConfigs(Map<String, Resource> adhocConfigs) {
        this.m_adhocConfigs = adhocConfigs;
    }

    public Map<String, Resource> getPrefabConfigs() {
        return this.m_prefabConfigs;
    }

    public void setPrefabConfigs(Map<String, Resource> prefabConfigs) {
        this.m_prefabConfigs = prefabConfigs;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AdhocGraphTypeCallback
    implements FileReloadCallback<AdhocGraphType> {
        private AdhocGraphTypeCallback() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public AdhocGraphType reload(AdhocGraphType object, Resource resource) {
            InputStream in = null;
            try {
                in = resource.getInputStream();
                AdhocGraphType adhocGraphType = PropertiesGraphDao.this.createAdhocGraphType(object.getName(), in);
                return adhocGraphType;
            }
            catch (Exception e) {
                PropertiesGraphDao.this.log().error("Could not reload configuration from '" + resource + "'; nested exception: " + e, (Throwable)e);
                AdhocGraphType adhocGraphType = null;
                return adhocGraphType;
            }
            finally {
                IOUtils.closeQuietly((InputStream)in);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PrefabGraphTypeCallback
    implements FileReloadCallback<PrefabGraphType> {
        private PrefabGraphTypeCallback() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public PrefabGraphType reload(PrefabGraphType object, Resource resource) {
            InputStream in = null;
            try {
                in = resource.getInputStream();
                PrefabGraphType prefabGraphType = PropertiesGraphDao.this.createPrefabGraphType(object.getName(), in);
                return prefabGraphType;
            }
            catch (Exception e) {
                PropertiesGraphDao.this.log().error("Could not reload configuration '" + resource + "'; nested exception: " + e, (Throwable)e);
                PrefabGraphType prefabGraphType = null;
                return prefabGraphType;
            }
            finally {
                if (in != null) {
                    IOUtils.closeQuietly((InputStream)in);
                }
            }
        }
    }
}

