/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.hibernate;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.ValidationException;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.opennms.netmgt.config.monitoringLocations.LocationDef;
import org.opennms.netmgt.config.monitoringLocations.Locations;
import org.opennms.netmgt.config.monitoringLocations.MonitoringLocationsConfiguration;
import org.opennms.netmgt.config.tags.Tag;
import org.opennms.netmgt.config.tags.Tags;
import org.opennms.netmgt.dao.CastorDataAccessFailureException;
import org.opennms.netmgt.dao.LocationMonitorDao;
import org.opennms.netmgt.dao.castor.CastorUtils;
import org.opennms.netmgt.dao.hibernate.AbstractDaoHibernate;
import org.opennms.netmgt.model.LocationMonitorIpInterface;
import org.opennms.netmgt.model.OnmsApplication;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsLocationMonitor;
import org.opennms.netmgt.model.OnmsLocationSpecificStatus;
import org.opennms.netmgt.model.OnmsMonitoredService;
import org.opennms.netmgt.model.OnmsMonitoringLocationDefinition;
import org.springframework.core.io.Resource;
import org.springframework.orm.hibernate3.HibernateCallback;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocationMonitorDaoHibernate
extends AbstractDaoHibernate<OnmsLocationMonitor, Integer>
implements LocationMonitorDao {
    private MonitoringLocationsConfiguration m_monitoringLocationsConfiguration;
    private Resource m_monitoringLocationConfigResource;

    public LocationMonitorDaoHibernate() {
        super(OnmsLocationMonitor.class);
        if (this.m_monitoringLocationConfigResource != null) {
            this.initializeConfigurations();
        }
    }

    @Override
    public List<OnmsMonitoringLocationDefinition> findAllMonitoringLocationDefinitions() {
        List locationDefCollection;
        this.assertPropertiesSet();
        Locations locations = this.m_monitoringLocationsConfiguration.getLocations();
        if (locations != null && (locationDefCollection = locations.getLocationDefCollection()) != null) {
            return this.convertDefs(locationDefCollection);
        }
        return new ArrayList<OnmsMonitoringLocationDefinition>();
    }

    private List<OnmsMonitoringLocationDefinition> convertDefs(List<LocationDef> defs) {
        LinkedList<OnmsMonitoringLocationDefinition> onmsDefs = new LinkedList<OnmsMonitoringLocationDefinition>();
        for (LocationDef def : defs) {
            OnmsMonitoringLocationDefinition onmsDef = new OnmsMonitoringLocationDefinition();
            onmsDef.setArea(def.getMonitoringArea());
            onmsDef.setName(def.getLocationName());
            onmsDef.setPollingPackageName(def.getPollingPackageName());
            onmsDef.setGeolocation(def.getGeolocation());
            onmsDef.setCoordinates(def.getCoordinates());
            onmsDef.setPriority(Long.valueOf(def.getPriority()));
            if (def.getTags() != null) {
                HashSet<String> tags = new HashSet<String>();
                for (Tag t : def.getTags().getTagCollection()) {
                    tags.add(t.getName());
                }
                onmsDef.setTags(tags);
            }
            onmsDefs.add(onmsDef);
        }
        return onmsDefs;
    }

    @Override
    public void saveMonitoringLocationDefinitions(Collection<OnmsMonitoringLocationDefinition> onmsDefs) {
        Locations locations = this.m_monitoringLocationsConfiguration.getLocations();
        if (locations != null) {
            List defs = locations.getLocationDefCollection();
            for (OnmsMonitoringLocationDefinition onmsDef : onmsDefs) {
                for (LocationDef def : defs) {
                    if (!def.getLocationName().equals(onmsDef.getName())) continue;
                    def.setMonitoringArea(onmsDef.getArea());
                    def.setPollingPackageName(onmsDef.getPollingPackageName());
                    def.setGeolocation(onmsDef.getGeolocation());
                    def.setCoordinates(onmsDef.getCoordinates());
                    def.setPriority(onmsDef.getPriority().longValue());
                    Tags tags = new Tags();
                    for (String tag : onmsDef.getTags()) {
                        Tag t = new Tag();
                        t.setName(tag);
                        tags.addTag(t);
                    }
                    def.setTags(tags);
                }
            }
        }
        this.saveMonitoringConfig();
    }

    @Override
    public void saveMonitoringLocationDefinition(OnmsMonitoringLocationDefinition onmsDef) {
        Locations locations = this.m_monitoringLocationsConfiguration.getLocations();
        if (locations != null) {
            List defs = locations.getLocationDefCollection();
            for (LocationDef def : defs) {
                if (!onmsDef.getName().equals(def.getLocationName())) continue;
                def.setMonitoringArea(onmsDef.getArea());
                def.setPollingPackageName(onmsDef.getPollingPackageName());
                def.setGeolocation(onmsDef.getGeolocation());
                def.setCoordinates(onmsDef.getCoordinates());
                def.setPriority(onmsDef.getPriority().longValue());
                Tags tags = new Tags();
                for (String tag : onmsDef.getTags()) {
                    Tag t = new Tag();
                    t.setName(tag);
                    tags.addTag(t);
                }
                def.setTags(tags);
            }
        }
        this.saveMonitoringConfig();
    }

    protected void saveMonitoringConfig() {
        String xml = null;
        StringWriter writer = new StringWriter();
        try {
            Marshaller.marshal((Object)this.m_monitoringLocationsConfiguration, (Writer)writer);
            xml = writer.toString();
            this.saveXml(xml);
        }
        catch (MarshalException e) {
            throw new CastorDataAccessFailureException("saveMonitoringConfig: couldn't marshal confg: \n" + (xml != null ? xml : ""), e);
        }
        catch (ValidationException e) {
            throw new CastorDataAccessFailureException("saveMonitoringConfig: couldn't validate confg: \n" + (xml != null ? xml : ""), e);
        }
        catch (IOException e) {
            throw new CastorDataAccessFailureException("saveMonitoringConfig: couldn't write confg: \n" + (xml != null ? xml : ""), e);
        }
    }

    protected void saveXml(String xml) throws IOException {
        if (xml != null) {
            OutputStreamWriter fileWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(this.m_monitoringLocationConfigResource.getFile()), "UTF-8");
            fileWriter.write(xml);
            ((Writer)fileWriter).flush();
            ((Writer)fileWriter).close();
        }
    }

    private LocationDef getLocationDef(String definitionName) {
        Locations locations = this.m_monitoringLocationsConfiguration.getLocations();
        if (locations != null) {
            for (LocationDef def : locations.getLocationDefCollection()) {
                if (!def.getLocationName().equals(definitionName)) continue;
                return def;
            }
        }
        return null;
    }

    private void initializeConfigurations() {
        this.initializeMonitoringLocationDefinition();
    }

    private void initializeMonitoringLocationDefinition() {
        this.m_monitoringLocationsConfiguration = CastorUtils.unmarshalWithTranslatedExceptions(MonitoringLocationsConfiguration.class, this.m_monitoringLocationConfigResource);
    }

    public Collection<OnmsMonitoringLocationDefinition> findAllLocationDefinitions() {
        this.assertPropertiesSet();
        LinkedList<OnmsMonitoringLocationDefinition> eDefs = new LinkedList<OnmsMonitoringLocationDefinition>();
        for (LocationDef def : this.m_monitoringLocationsConfiguration.getLocations().getLocationDefCollection()) {
            eDefs.add(this.createEntityDef(def));
        }
        return eDefs;
    }

    private void assertPropertiesSet() {
        if (this.m_monitoringLocationConfigResource == null && this.m_monitoringLocationsConfiguration == null) {
            throw new IllegalStateException("either monitoringLocationConfigResource or monitorLocationsConfiguration must be set but is not");
        }
    }

    private OnmsMonitoringLocationDefinition createEntityDef(LocationDef def) {
        OnmsMonitoringLocationDefinition eDef = new OnmsMonitoringLocationDefinition();
        eDef.setArea(def.getMonitoringArea());
        eDef.setName(def.getLocationName());
        eDef.setPollingPackageName(def.getPollingPackageName());
        eDef.setGeolocation(def.getGeolocation());
        eDef.setCoordinates(def.getCoordinates());
        eDef.setPriority(Long.valueOf(def.getPriority()));
        if (def.getTags() != null) {
            HashSet<String> tags = new HashSet<String>();
            for (Tag t : def.getTags().getTagCollection()) {
                tags.add(t.getName());
            }
            eDef.setTags(tags);
        }
        return eDef;
    }

    public MonitoringLocationsConfiguration getMonitoringLocationsConfiguration() {
        return this.m_monitoringLocationsConfiguration;
    }

    public void setMonitoringLocationsConfiguration(MonitoringLocationsConfiguration monitoringLocationsConfiguration) {
        this.m_monitoringLocationsConfiguration = monitoringLocationsConfiguration;
    }

    public Resource getMonitoringLocationConfigResource() {
        return this.m_monitoringLocationConfigResource;
    }

    public void setMonitoringLocationConfigResource(Resource monitoringLocationResource) {
        this.m_monitoringLocationConfigResource = monitoringLocationResource;
        this.initializeMonitoringLocationDefinition();
    }

    @Override
    public OnmsMonitoringLocationDefinition findMonitoringLocationDefinition(String monitoringLocationDefinitionName) {
        if (monitoringLocationDefinitionName == null) {
            throw new IllegalArgumentException("monitoringLocationDefinitionName must not be null");
        }
        this.assertPropertiesSet();
        LocationDef locationDef = this.getLocationDef(monitoringLocationDefinitionName);
        if (locationDef == null) {
            return null;
        }
        return this.createEntityDef(locationDef);
    }

    @Override
    public OnmsLocationSpecificStatus getMostRecentStatusChange(final OnmsLocationMonitor locationMonitor, final OnmsMonitoredService monSvc) {
        HibernateCallback<OnmsLocationSpecificStatus> callback = new HibernateCallback<OnmsLocationSpecificStatus>(){

            public OnmsLocationSpecificStatus doInHibernate(Session session) throws HibernateException, SQLException {
                return (OnmsLocationSpecificStatus)session.createQuery("from OnmsLocationSpecificStatus status where status.locationMonitor = :locationMonitor and status.monitoredService = :monitoredService order by status.pollResult.timestamp desc").setEntity("locationMonitor", (Object)locationMonitor).setEntity("monitoredService", (Object)monSvc).setMaxResults(1).uniqueResult();
            }
        };
        return (OnmsLocationSpecificStatus)this.getHibernateTemplate().execute((HibernateCallback)callback);
    }

    @Override
    public void saveStatusChange(OnmsLocationSpecificStatus statusChange) {
        this.getHibernateTemplate().save((Object)statusChange);
    }

    @Override
    public Collection<OnmsLocationMonitor> findByApplication(OnmsApplication application) {
        HashSet<OnmsLocationMonitor> monitors = new HashSet<OnmsLocationMonitor>();
        for (OnmsLocationSpecificStatus status : this.getAllMostRecentStatusChanges()) {
            if (status.getMonitoredService().getApplications() == null || !status.getMonitoredService().getApplications().contains(application)) continue;
            monitors.add(status.getLocationMonitor());
        }
        return monitors;
    }

    @Override
    public Collection<OnmsLocationMonitor> findByLocationDefinition(OnmsMonitoringLocationDefinition locationDefinition) {
        return this.find("from OnmsLocationMonitor as mon where mon.definitionName = ?", locationDefinition.getName());
    }

    @Override
    public Collection<OnmsLocationSpecificStatus> getAllMostRecentStatusChanges() {
        return this.getAllStatusChangesAt(new Date());
    }

    @Override
    public Collection<OnmsLocationSpecificStatus> getAllStatusChangesAt(Date timestamp) {
        return this.findObjects(OnmsLocationSpecificStatus.class, "from OnmsLocationSpecificStatus as status where status.pollResult.timestamp = (     select max(recentStatus.pollResult.timestamp)     from OnmsLocationSpecificStatus as recentStatus     where recentStatus.pollResult.timestamp < ?     group by recentStatus.locationMonitor, recentStatus.monitoredService     having recentStatus.locationMonitor = status.locationMonitor     and recentStatus.monitoredService = status.monitoredService )", timestamp);
    }

    @Override
    public Collection<OnmsLocationSpecificStatus> getStatusChangesBetween(Date startDate, Date endDate) {
        return this.findObjects(OnmsLocationSpecificStatus.class, "from OnmsLocationSpecificStatus as status where ? <= status.pollResult.timestamp and status.pollResult.timestamp < ?", startDate, endDate);
    }

    @Override
    public Collection<OnmsLocationSpecificStatus> getStatusChangesForLocationBetween(Date startDate, Date endDate, String locationName) {
        Collection<OnmsLocationSpecificStatus> statuses = this.getMostRecentStatusChangesForDateAndLocation(startDate, locationName);
        statuses.addAll(this.findObjects(OnmsLocationSpecificStatus.class, "from OnmsLocationSpecificStatus as status where ? <= status.pollResult.timestamp and status.pollResult.timestamp < ? and status.locationMonitor.definitionName = ?", startDate, endDate, locationName));
        return statuses;
    }

    @Override
    public Collection<OnmsLocationSpecificStatus> getMostRecentStatusChangesForLocation(String locationName) {
        return this.getMostRecentStatusChangesForDateAndLocation(new Date(), locationName);
    }

    private Collection<OnmsLocationSpecificStatus> getMostRecentStatusChangesForDateAndLocation(Date date, String locationName) {
        return this.findObjects(OnmsLocationSpecificStatus.class, "from OnmsLocationSpecificStatus as status where status.pollResult.timestamp = (     select max(recentStatus.pollResult.timestamp)     from OnmsLocationSpecificStatus as recentStatus     where recentStatus.pollResult.timestamp < ?     group by recentStatus.locationMonitor, recentStatus.monitoredService     having recentStatus.locationMonitor = status.locationMonitor     and recentStatus.monitoredService = status.monitoredService ) and status.locationMonitor.definitionName = ?", date, locationName);
    }

    @Override
    public Collection<LocationMonitorIpInterface> findStatusChangesForNodeForUniqueMonitorAndInterface(int nodeId) {
        List l = this.getHibernateTemplate().find("select distinct status.locationMonitor, status.monitoredService.ipInterface from OnmsLocationSpecificStatus as status where status.monitoredService.ipInterface.node.id = ?", (Object)nodeId);
        HashSet<LocationMonitorIpInterface> ret = new HashSet<LocationMonitorIpInterface>();
        for (Object o : l) {
            OnmsLocationMonitor mon = (OnmsLocationMonitor)((Object[])o)[0];
            OnmsIpInterface ip = (OnmsIpInterface)((Object[])o)[1];
            ret.add(new LocationMonitorIpInterface(mon, ip));
        }
        return ret;
    }
}

