/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.hibernate;

import java.io.Serializable;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.criterion.Projections;
import org.opennms.netmgt.dao.OnmsDao;
import org.opennms.netmgt.model.OnmsCriteria;
import org.springframework.dao.DataAccessException;
import org.springframework.orm.hibernate3.HibernateCallback;
import org.springframework.orm.hibernate3.support.HibernateDaoSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDaoHibernate<T, K extends Serializable>
extends HibernateDaoSupport
implements OnmsDao<T, K> {
    Class<T> m_entityClass;

    public AbstractDaoHibernate(Class<T> entityClass) {
        this.m_entityClass = entityClass;
    }

    @Override
    public void initialize(Object obj) {
        this.getHibernateTemplate().initialize(obj);
    }

    @Override
    public void flush() {
        this.getHibernateTemplate().flush();
    }

    @Override
    public void clear() {
        this.getHibernateTemplate().clear();
    }

    public void evict(T entity) {
        this.getHibernateTemplate().evict(entity);
    }

    public void merge(T entity) {
        this.getHibernateTemplate().merge(entity);
    }

    public List<T> find(String query) {
        return this.getHibernateTemplate().find(query);
    }

    public List<T> find(String query, Object ... values) {
        return this.getHibernateTemplate().find(query, values);
    }

    public <S> List<S> findObjects(Class<S> clazz, String query, Object ... values) {
        List notifs = this.getHibernateTemplate().find(query, values);
        return notifs;
    }

    protected int queryInt(final String query) {
        HibernateCallback<Number> callback = new HibernateCallback<Number>(){

            public Number doInHibernate(Session session) throws HibernateException {
                return (Number)session.createQuery(query).uniqueResult();
            }
        };
        return ((Number)this.getHibernateTemplate().execute((HibernateCallback)callback)).intValue();
    }

    protected int queryInt(final String queryString, final Object ... args) {
        HibernateCallback<Number> callback = new HibernateCallback<Number>(){

            public Number doInHibernate(Session session) throws HibernateException, SQLException {
                Query query = session.createQuery(queryString);
                for (int i = 0; i < args.length; ++i) {
                    query.setParameter(i, args[i]);
                }
                return (Number)query.uniqueResult();
            }
        };
        return ((Number)this.getHibernateTemplate().execute((HibernateCallback)callback)).intValue();
    }

    protected T findUnique(String query) {
        return this.findUnique(this.m_entityClass, query, new Object[0]);
    }

    protected T findUnique(String queryString, Object ... args) {
        return this.findUnique(this.m_entityClass, queryString, args);
    }

    protected <S> S findUnique(final Class<? extends S> type, final String queryString, final Object ... args) {
        HibernateCallback callback = new HibernateCallback<S>(){

            public S doInHibernate(Session session) throws HibernateException, SQLException {
                Query query = session.createQuery(queryString);
                for (int i = 0; i < args.length; ++i) {
                    query.setParameter(i, args[i]);
                }
                Object result = query.uniqueResult();
                return result == null ? null : (Object)type.cast(result);
            }
        };
        return (S)this.getHibernateTemplate().execute(callback);
    }

    @Override
    public int countAll() {
        return this.queryInt("select count(*) from " + this.m_entityClass.getName());
    }

    @Override
    public void delete(T entity) throws DataAccessException {
        this.getHibernateTemplate().delete(entity);
    }

    public void deleteAll(Collection<T> entities) throws DataAccessException {
        this.getHibernateTemplate().deleteAll(entities);
    }

    @Override
    public List<T> findAll() throws DataAccessException {
        return this.getHibernateTemplate().loadAll(this.m_entityClass);
    }

    public <S> List<S> findMatchingObjects(Class<S> type, final OnmsCriteria onmsCrit) {
        onmsCrit.resultsOfType(type);
        HibernateCallback callback = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Criteria attachedCrit = onmsCrit.getDetachedCriteria().getExecutableCriteria(session);
                if (onmsCrit.getFirstResult() != null) {
                    attachedCrit.setFirstResult(onmsCrit.getFirstResult().intValue());
                }
                if (onmsCrit.getMaxResults() != null) {
                    attachedCrit.setMaxResults(onmsCrit.getMaxResults().intValue());
                }
                return attachedCrit.list();
            }
        };
        return this.getHibernateTemplate().executeFind(callback);
    }

    @Override
    public List<T> findMatching(final OnmsCriteria onmsCrit) throws DataAccessException {
        onmsCrit.resultsOfType(this.m_entityClass);
        HibernateCallback callback = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Criteria attachedCrit = onmsCrit.getDetachedCriteria().getExecutableCriteria(session);
                if (onmsCrit.getFirstResult() != null) {
                    attachedCrit.setFirstResult(onmsCrit.getFirstResult().intValue());
                }
                if (onmsCrit.getMaxResults() != null) {
                    attachedCrit.setMaxResults(onmsCrit.getMaxResults().intValue());
                }
                return attachedCrit.list();
            }
        };
        return this.getHibernateTemplate().executeFind(callback);
    }

    @Override
    public int countMatching(final OnmsCriteria onmsCrit) throws DataAccessException {
        HibernateCallback<Integer> callback = new HibernateCallback<Integer>(){

            public Integer doInHibernate(Session session) throws HibernateException, SQLException {
                Criteria attachedCrit = onmsCrit.getDetachedCriteria().getExecutableCriteria(session).setProjection(Projections.rowCount());
                return (Integer)attachedCrit.uniqueResult();
            }
        };
        return (Integer)this.getHibernateTemplate().execute((HibernateCallback)callback);
    }

    public int bulkDelete(String hql, Object[] values) throws DataAccessException {
        return this.getHibernateTemplate().bulkUpdate(hql, values);
    }

    @Override
    public T get(K id) throws DataAccessException {
        return this.m_entityClass.cast(this.getHibernateTemplate().get(this.m_entityClass, id));
    }

    @Override
    public T load(K id) throws DataAccessException {
        return this.m_entityClass.cast(this.getHibernateTemplate().load(this.m_entityClass, id));
    }

    @Override
    public void save(T entity) throws DataAccessException {
        this.getHibernateTemplate().save(entity);
    }

    @Override
    public void saveOrUpdate(T entity) throws DataAccessException {
        this.getHibernateTemplate().saveOrUpdate(entity);
    }

    @Override
    public void update(T entity) throws DataAccessException {
        this.getHibernateTemplate().update(entity);
    }
}

