/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.ValidationException;
import org.opennms.core.utils.IPLike;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.ConfigFileConstants;
import org.opennms.netmgt.config.PeerFactory;
import org.opennms.netmgt.config.SnmpConfigManager;
import org.opennms.netmgt.config.SnmpEventInfo;
import org.opennms.netmgt.config.common.Range;
import org.opennms.netmgt.config.snmp.Definition;
import org.opennms.netmgt.config.snmp.SnmpConfig;
import org.opennms.netmgt.dao.SnmpAgentConfigFactory;
import org.opennms.netmgt.dao.castor.CastorUtils;
import org.opennms.netmgt.snmp.SnmpAgentConfig;
import org.opennms.protocols.ip.IPv4Address;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;

public final class SnmpPeerFactory
extends PeerFactory
implements SnmpAgentConfigFactory {
    private static SnmpPeerFactory m_singleton = null;
    private static SnmpConfig m_config;
    private static File m_configFile;
    private static boolean m_loaded;
    private static final int VERSION_UNSPECIFIED = -1;

    private SnmpPeerFactory(File configFile) throws IOException, MarshalException, ValidationException {
        this((Resource)new FileSystemResource(configFile));
    }

    public SnmpPeerFactory(Resource resource) {
        m_config = CastorUtils.unmarshalWithTranslatedExceptions(SnmpConfig.class, resource);
    }

    @Deprecated
    public SnmpPeerFactory(Reader rdr) throws IOException, MarshalException, ValidationException {
        m_config = CastorUtils.unmarshalWithTranslatedExceptions(SnmpConfig.class, rdr);
    }

    public SnmpPeerFactory(InputStream stream) {
        m_config = CastorUtils.unmarshalWithTranslatedExceptions(SnmpConfig.class, stream);
    }

    public static synchronized void init() throws IOException, MarshalException, ValidationException {
        if (m_loaded) {
            return;
        }
        File cfgFile = SnmpPeerFactory.getFile();
        SnmpPeerFactory.log().debug("init: config file path: " + cfgFile.getPath());
        m_singleton = new SnmpPeerFactory(cfgFile);
        m_loaded = true;
    }

    private static ThreadCategory log() {
        return ThreadCategory.getInstance(SnmpPeerFactory.class);
    }

    public static synchronized void reload() throws IOException, MarshalException, ValidationException {
        m_singleton = null;
        m_loaded = false;
        SnmpPeerFactory.init();
    }

    public static synchronized void saveCurrent() throws IOException, MarshalException, ValidationException {
        String marshalledConfig = SnmpPeerFactory.marshallConfig();
        if (marshalledConfig != null) {
            OutputStreamWriter fileWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(SnmpPeerFactory.getFile()), "UTF-8");
            fileWriter.write(marshalledConfig);
            ((Writer)fileWriter).flush();
            ((Writer)fileWriter).close();
        }
        SnmpPeerFactory.reload();
    }

    public static synchronized SnmpPeerFactory getInstance() {
        if (!m_loaded) {
            throw new IllegalStateException("The factory has not been initialized");
        }
        return m_singleton;
    }

    public static synchronized void setFile(File configFile) {
        File oldFile = m_configFile;
        m_configFile = configFile;
        if (oldFile == null || m_configFile == null || !oldFile.equals(m_configFile)) {
            m_singleton = null;
            m_loaded = false;
        }
    }

    public static synchronized File getFile() throws IOException {
        if (m_configFile == null) {
            m_configFile = ConfigFileConstants.getFile((int)ConfigFileConstants.SNMP_CONF_FILE_NAME);
        }
        return m_configFile;
    }

    public static synchronized void setInstance(SnmpPeerFactory singleton) {
        m_singleton = singleton;
        m_loaded = true;
    }

    private void define(InetAddress ip, String community) throws UnknownHostException {
        ThreadCategory log = SnmpPeerFactory.log();
        int address = new IPv4Address(ip).getAddress();
        ArrayList<Definition> definitions = new ArrayList<Definition>(m_config.getDefinitionCollection());
        Definition definition = null;
        for (Definition currentDefinition : definitions) {
            if ((currentDefinition.getReadCommunity() == null || !currentDefinition.getReadCommunity().equals(community)) && (currentDefinition.getReadCommunity() != null || m_config.getReadCommunity() == null || !m_config.getReadCommunity().equals(community))) continue;
            if (log.isDebugEnabled()) {
                log.debug("define: Found existing definition with read-community " + community);
            }
            definition = currentDefinition;
            break;
        }
        if (definition == null) {
            if (log.isDebugEnabled()) {
                log.debug("define: Creating new definition");
            }
            definition = new Definition();
            definition.setReadCommunity(community);
            definitions.add(definition);
        }
        definition.addSpecific(ip.getHostAddress());
        for (Definition currentDefinition : definitions) {
            Range[] rangesArray;
            if (currentDefinition == definition) continue;
            while (currentDefinition.removeSpecific(ip.getHostAddress())) {
                if (!log.isDebugEnabled()) continue;
                log.debug("define: Removed an existing specific element with IP " + ip);
            }
            ArrayList<Range> ranges = new ArrayList<Range>(currentDefinition.getRangeCollection());
            for (Range range : rangesArray = currentDefinition.getRange()) {
                int begin = new IPv4Address(range.getBegin()).getAddress();
                int end = new IPv4Address(range.getEnd()).getAddress();
                if (address < begin || address > end) continue;
                if (log.isDebugEnabled()) {
                    log.debug("define: Splitting range element with begin " + range.getBegin() + " and " + "end " + range.getEnd());
                }
                if (begin == end) {
                    ranges.remove(range);
                    continue;
                }
                if (address == begin) {
                    range.setBegin(IPv4Address.addressToString((int)(address + 1)));
                    continue;
                }
                if (address == end) {
                    range.setEnd(IPv4Address.addressToString((int)(address - 1)));
                    continue;
                }
                Range head = new Range();
                head.setBegin(range.getBegin());
                head.setEnd(IPv4Address.addressToString((int)(address - 1)));
                Range tail = new Range();
                tail.setBegin(IPv4Address.addressToString((int)(address + 1)));
                tail.setEnd(range.getEnd());
                ranges.remove(range);
                ranges.add(head);
                ranges.add(tail);
            }
            currentDefinition.setRange(ranges);
        }
        m_config.setDefinition(definitions);
    }

    public synchronized SnmpAgentConfig getAgentConfig(InetAddress agentAddress) {
        return this.getAgentConfig(agentAddress, -1);
    }

    private synchronized SnmpAgentConfig getAgentConfig(InetAddress agentInetAddress, int requestedSnmpVersion) {
        if (m_config == null) {
            SnmpAgentConfig agentConfig = new SnmpAgentConfig(agentInetAddress);
            if (requestedSnmpVersion == -1) {
                agentConfig.setVersion(1);
            } else {
                agentConfig.setVersion(requestedSnmpVersion);
            }
            return agentConfig;
        }
        SnmpAgentConfig agentConfig = new SnmpAgentConfig(agentInetAddress);
        this.setSnmpAgentConfig(agentConfig, new Definition(), requestedSnmpVersion);
        block4: for (Definition def : m_config.getDefinitionCollection()) {
            for (String saddr : def.getSpecificCollection()) {
                try {
                    InetAddress addr = InetAddress.getByName(saddr);
                    if (!addr.equals(agentConfig.getAddress())) continue;
                    this.setSnmpAgentConfig(agentConfig, def, requestedSnmpVersion);
                    break block4;
                }
                catch (UnknownHostException e) {
                    SnmpPeerFactory.log().warn("SnmpPeerFactory: could not convert host " + saddr + " to InetAddress", (Throwable)e);
                }
            }
            long lhost = InetAddressUtils.toIpAddrLong((InetAddress)agentConfig.getAddress());
            for (Range rng : def.getRangeCollection()) {
                try {
                    InetAddress begin = InetAddress.getByName(rng.getBegin());
                    InetAddress end = InetAddress.getByName(rng.getEnd());
                    long start = InetAddressUtils.toIpAddrLong((InetAddress)begin);
                    long stop = InetAddressUtils.toIpAddrLong((InetAddress)end);
                    if (start > lhost || lhost > stop) continue;
                    this.setSnmpAgentConfig(agentConfig, def, requestedSnmpVersion);
                    break block4;
                }
                catch (UnknownHostException e) {
                    SnmpPeerFactory.log().warn("SnmpPeerFactory: could not convert host(s) " + rng.getBegin() + " - " + rng.getEnd() + " to InetAddress", (Throwable)e);
                }
            }
            for (String ipMatch : def.getIpMatchCollection()) {
                if (!IPLike.matches((String)agentInetAddress.getHostAddress(), (String)ipMatch)) continue;
                this.setSnmpAgentConfig(agentConfig, def, requestedSnmpVersion);
                break block4;
            }
        }
        if (agentConfig == null) {
            Definition def = new Definition();
            this.setSnmpAgentConfig(agentConfig, def, requestedSnmpVersion);
        }
        return agentConfig;
    }

    private void setSnmpAgentConfig(SnmpAgentConfig agentConfig, Definition def, int requestedSnmpVersion) {
        int version = this.determineVersion(def, requestedSnmpVersion);
        this.setCommonAttributes(agentConfig, def, version);
        agentConfig.setSecurityLevel(this.determineSecurityLevel(def));
        agentConfig.setSecurityName(this.determineSecurityName(def));
        agentConfig.setAuthProtocol(this.determineAuthProtocol(def));
        agentConfig.setAuthPassPhrase(this.determineAuthPassPhrase(def));
        agentConfig.setPrivPassPhrase(this.determinePrivPassPhrase(def));
        agentConfig.setPrivProtocol(this.determinePrivProtocol(def));
        agentConfig.setReadCommunity(this.determineReadCommunity(def));
        agentConfig.setWriteCommunity(this.determineWriteCommunity(def));
    }

    private void setCommonAttributes(SnmpAgentConfig agentConfig, Definition def, int version) {
        agentConfig.setVersion(version);
        agentConfig.setPort(this.determinePort(def));
        agentConfig.setRetries(this.determineRetries(def));
        agentConfig.setTimeout((int)this.determineTimeout(def));
        agentConfig.setMaxRequestSize(this.determineMaxRequestSize(def));
        agentConfig.setMaxVarsPerPdu(this.determineMaxVarsPerPdu(def));
        agentConfig.setMaxRepetitions(this.determineMaxRepetitions(def));
        InetAddress proxyHost = this.determineProxyHost(def);
        if (proxyHost != null) {
            agentConfig.setProxyFor(agentConfig.getAddress());
            agentConfig.setAddress(this.determineProxyHost(def));
        }
    }

    private int determineMaxRepetitions(Definition def) {
        return !def.hasMaxRepetitions() ? (!m_config.hasMaxRepetitions() ? 2 : m_config.getMaxRepetitions()) : def.getMaxRepetitions();
    }

    private InetAddress determineProxyHost(Definition def) {
        String address;
        InetAddress inetAddr = null;
        Object object = def.getProxyHost() == null ? (m_config.getProxyHost() == null ? null : m_config.getProxyHost()) : (address = def.getProxyHost());
        if (address != null) {
            try {
                inetAddr = InetAddress.getByName(address);
            }
            catch (UnknownHostException e) {
                SnmpPeerFactory.log().error("determineProxyHost: Problem converting proxy host string to InetAddress", (Throwable)e);
            }
        }
        return inetAddr;
    }

    private int determineMaxVarsPerPdu(Definition def) {
        return !def.hasMaxVarsPerPdu() ? (!m_config.hasMaxVarsPerPdu() ? 10 : m_config.getMaxVarsPerPdu()) : def.getMaxVarsPerPdu();
    }

    private String determineReadCommunity(Definition def) {
        return def.getReadCommunity() == null ? (m_config.getReadCommunity() == null ? "public" : m_config.getReadCommunity()) : def.getReadCommunity();
    }

    private String determineWriteCommunity(Definition def) {
        return def.getWriteCommunity() == null ? (m_config.getWriteCommunity() == null ? "private" : m_config.getWriteCommunity()) : def.getWriteCommunity();
    }

    private int determineMaxRequestSize(Definition def) {
        return !def.hasMaxRequestSize() ? (!m_config.hasMaxRequestSize() ? 65535 : m_config.getMaxRequestSize()) : def.getMaxRequestSize();
    }

    private String determineSecurityName(Definition def) {
        String securityName;
        String string = securityName = def.getSecurityName() == null ? m_config.getSecurityName() : def.getSecurityName();
        if (securityName == null) {
            securityName = "opennmsUser";
        }
        return securityName;
    }

    private String determineAuthProtocol(Definition def) {
        String authProtocol;
        String string = authProtocol = def.getAuthProtocol() == null ? m_config.getAuthProtocol() : def.getAuthProtocol();
        if (authProtocol == null) {
            authProtocol = "MD5";
        }
        return authProtocol;
    }

    private String determineAuthPassPhrase(Definition def) {
        String authPassPhrase;
        String string = authPassPhrase = def.getAuthPassphrase() == null ? m_config.getAuthPassphrase() : def.getAuthPassphrase();
        if (authPassPhrase == null) {
            authPassPhrase = "0p3nNMSv3";
        }
        return authPassPhrase;
    }

    private String determinePrivPassPhrase(Definition def) {
        String privPassPhrase;
        String string = privPassPhrase = def.getPrivacyPassphrase() == null ? m_config.getPrivacyPassphrase() : def.getPrivacyPassphrase();
        if (privPassPhrase == null) {
            privPassPhrase = "0p3nNMSv3";
        }
        return privPassPhrase;
    }

    private String determinePrivProtocol(Definition def) {
        String authPrivProtocol;
        String string = authPrivProtocol = def.getPrivacyProtocol() == null ? m_config.getPrivacyProtocol() : def.getPrivacyProtocol();
        if (authPrivProtocol == null) {
            authPrivProtocol = "DES";
        }
        return authPrivProtocol;
    }

    private int determineSecurityLevel(Definition def) {
        String privPassPhrase;
        if (def.hasSecurityLevel()) {
            return def.getSecurityLevel();
        }
        if (m_config.hasSecurityLevel()) {
            return m_config.getSecurityLevel();
        }
        int securityLevel = 1;
        String authPassPhrase = def.getAuthPassphrase() == null ? m_config.getAuthPassphrase() : def.getAuthPassphrase();
        String string = privPassPhrase = def.getPrivacyPassphrase() == null ? m_config.getPrivacyPassphrase() : def.getPrivacyPassphrase();
        securityLevel = authPassPhrase == null ? 1 : (privPassPhrase == null ? 2 : 3);
        return securityLevel;
    }

    private int determinePort(Definition def) {
        int port = 161;
        return def.getPort() == 0 ? (m_config.getPort() == 0 ? port : m_config.getPort()) : def.getPort();
    }

    private long determineTimeout(Definition def) {
        long timeout = 3000L;
        return def.getTimeout() == 0 ? (m_config.getTimeout() == 0 ? timeout : (long)m_config.getTimeout()) : (long)def.getTimeout();
    }

    private int determineRetries(Definition def) {
        int retries = 1;
        return def.getRetry() == 0 ? (m_config.getRetry() == 0 ? retries : m_config.getRetry()) : def.getRetry();
    }

    private int determineVersion(Definition def, int requestedSnmpVersion) {
        int version = 1;
        String cfgVersion = "v1";
        if (requestedSnmpVersion == -1) {
            if (def.getVersion() == null) {
                if (m_config.getVersion() == null) {
                    return version;
                }
                cfgVersion = m_config.getVersion();
            } else {
                cfgVersion = def.getVersion();
            }
        } else {
            return requestedSnmpVersion;
        }
        if (cfgVersion.equals("v1")) {
            version = 1;
        } else if (cfgVersion.equals("v2c")) {
            version = 2;
        } else if (cfgVersion.equals("v3")) {
            version = 3;
        }
        return version;
    }

    public static synchronized SnmpConfig getSnmpConfig() {
        return m_config;
    }

    private static synchronized void setSnmpConfig(SnmpConfig m_config) {
        SnmpPeerFactory.m_config = m_config;
    }

    public synchronized void define(SnmpEventInfo info) {
        SnmpConfigManager mgr = new SnmpConfigManager(SnmpPeerFactory.getSnmpConfig());
        mgr.mergeIntoConfig(info.createDef());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized String marshallConfig() {
        String marshalledConfig = null;
        StringWriter writer = null;
        try {
            writer = new StringWriter();
            Marshaller.marshal((Object)m_config, (Writer)writer);
            marshalledConfig = writer.toString();
        }
        catch (MarshalException e) {
            SnmpPeerFactory.log().error("marshallConfig: Error marshalling configuration", (Throwable)e);
        }
        catch (ValidationException e) {
            SnmpPeerFactory.log().error("marshallConfig: Error validating configuration", (Throwable)e);
        }
        finally {
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (IOException e) {
                SnmpPeerFactory.log().error("marshallConfig: I/O Error closing string writer!", (Throwable)e);
            }
        }
        return marshalledConfig;
    }

    static {
        m_loaded = false;
    }
}

