/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.apache.bcel.classfile;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.aspectj.apache.bcel.classfile.Attribute;
import org.aspectj.apache.bcel.classfile.ClassVisitor;
import org.aspectj.apache.bcel.classfile.ConstantPool;
import org.aspectj.apache.bcel.classfile.ConstantUtf8;
import org.aspectj.apache.bcel.classfile.GenericSignatureParser;

public final class Signature
extends Attribute {
    private int signature_index;
    private ClassSignature classSig;
    private MethodTypeSignature methodSig;
    private FieldTypeSignature fieldSig;

    public Signature(Signature c) {
        this(c.getNameIndex(), c.getLength(), c.getSignatureIndex(), c.getConstantPool());
    }

    Signature(int name_index, int length, DataInputStream file, ConstantPool constant_pool) throws IOException {
        this(name_index, length, file.readUnsignedShort(), constant_pool);
    }

    public Signature(int name_index, int length, int signature_index, ConstantPool constant_pool) {
        super((byte)10, name_index, length, constant_pool);
        this.signature_index = signature_index;
    }

    public void accept(ClassVisitor v) {
        System.err.println("Visiting non-standard Signature object");
        v.visitSignature(this);
    }

    public final void dump(DataOutputStream file) throws IOException {
        super.dump(file);
        file.writeShort(this.signature_index);
    }

    public final int getSignatureIndex() {
        return this.signature_index;
    }

    public final void setSignatureIndex(int signature_index) {
        this.signature_index = signature_index;
    }

    public final String getSignature() {
        ConstantUtf8 c = (ConstantUtf8)this.constantPool.getConstant(this.signature_index, (byte)1);
        return c.getBytes();
    }

    private static boolean identStart(int ch) {
        return ch == 84 || ch == 76;
    }

    private static final void matchIdent(MyByteArrayInputStream in, StringBuffer buf) {
        int ch = in.read();
        if (ch == -1) {
            throw new RuntimeException("Illegal signature: " + in.getData() + " no ident, reaching EOF");
        }
        if (!Signature.identStart(ch)) {
            StringBuffer buf2 = new StringBuffer();
            int count = 1;
            while (Character.isJavaIdentifierPart((char)ch)) {
                buf2.append((char)ch);
                ++count;
                ch = in.read();
            }
            if (ch == 58) {
                in.skip("Ljava/lang/Object".length());
                buf.append(buf2);
                ch = in.read();
                in.unread();
            } else {
                int i = 0;
                while (i < count) {
                    in.unread();
                    ++i;
                }
            }
            return;
        }
        StringBuffer buf2 = new StringBuffer();
        ch = in.read();
        do {
            buf2.append((char)ch);
        } while ((ch = in.read()) != -1 && (Character.isJavaIdentifierPart((char)ch) || ch == 47));
        buf.append(buf2.toString().replace('/', '.'));
        if (ch != -1) {
            in.unread();
        }
    }

    private static final void matchGJIdent(MyByteArrayInputStream in, StringBuffer buf) {
        Signature.matchIdent(in, buf);
        int ch = in.read();
        if (ch == 60 || ch == 40) {
            buf.append((char)ch);
            Signature.matchGJIdent(in, buf);
            while ((ch = in.read()) != 62 && ch != 41) {
                if (ch == -1) {
                    throw new RuntimeException("Illegal signature: " + in.getData() + " reaching EOF");
                }
                buf.append(", ");
                in.unread();
                Signature.matchGJIdent(in, buf);
            }
            buf.append((char)ch);
        } else {
            in.unread();
        }
        ch = in.read();
        if (Signature.identStart(ch)) {
            in.unread();
            Signature.matchGJIdent(in, buf);
        } else {
            if (ch == 41) {
                in.unread();
                return;
            }
            if (ch != 59) {
                throw new RuntimeException("Illegal signature: " + in.getData() + " read " + (char)ch);
            }
        }
    }

    public static String translate(String s) {
        StringBuffer buf = new StringBuffer();
        Signature.matchGJIdent(new MyByteArrayInputStream(s), buf);
        return buf.toString();
    }

    public static final boolean isFormalParameterList(String s) {
        return s.startsWith("<") && s.indexOf(58) > 0;
    }

    public static final boolean isActualParameterList(String s) {
        return s.startsWith("L") && s.endsWith(">;");
    }

    public final String toString() {
        String s = this.getSignature();
        return "Signature(" + s + ")";
    }

    public Attribute copy(ConstantPool constant_pool) {
        return (Signature)this.clone();
    }

    public ClassSignature asClassSignature() {
        if (this.classSig == null) {
            GenericSignatureParser parser = new GenericSignatureParser();
            this.classSig = parser.parseAsClassSignature(this.getSignature());
        }
        return this.classSig;
    }

    public MethodTypeSignature asMethodTypeSignature() {
        if (this.methodSig == null) {
            GenericSignatureParser parser = new GenericSignatureParser();
            this.methodSig = parser.parseAsMethodSignature(this.getSignature());
        }
        return this.methodSig;
    }

    public FieldTypeSignature asFieldTypeSignature() {
        if (this.fieldSig == null) {
            GenericSignatureParser parser = new GenericSignatureParser();
            this.fieldSig = parser.parseAsFieldSignature(this.getSignature());
        }
        return this.fieldSig;
    }

    public static class ArrayTypeSignature
    extends FieldTypeSignature {
        public TypeSignature typeSig;

        public ArrayTypeSignature(TypeSignature aTypeSig) {
            this.typeSig = aTypeSig;
        }

        public boolean isArrayTypeSignature() {
            return true;
        }

        public String toString() {
            return "[" + this.typeSig.toString();
        }
    }

    public static class BaseTypeSignature
    extends TypeSignature {
        private String sig;

        public BaseTypeSignature(String aPrimitiveType) {
            this.sig = aPrimitiveType;
        }

        public boolean isBaseType() {
            return true;
        }

        public String toString() {
            return this.sig;
        }
    }

    public static class ClassSignature {
        public FormalTypeParameter[] formalTypeParameters = new FormalTypeParameter[0];
        public ClassTypeSignature superclassSignature;
        public ClassTypeSignature[] superInterfaceSignatures = new ClassTypeSignature[0];

        public String toString() {
            StringBuffer ret = new StringBuffer();
            ret.append(this.formalTypeParameters.toString());
            ret.append(this.superclassSignature.toString());
            int i = 0;
            while (i < this.superInterfaceSignatures.length) {
                ret.append(this.superInterfaceSignatures[i].toString());
                ++i;
            }
            return ret.toString();
        }
    }

    public static class ClassTypeSignature
    extends FieldTypeSignature {
        public String classSignature;
        public SimpleClassTypeSignature outerType;
        public SimpleClassTypeSignature[] nestedTypes;

        public ClassTypeSignature(String sig, String identifier) {
            this.classSignature = sig;
            this.outerType = new SimpleClassTypeSignature(identifier);
            this.nestedTypes = new SimpleClassTypeSignature[0];
        }

        public ClassTypeSignature(String sig, SimpleClassTypeSignature outer, SimpleClassTypeSignature[] inners) {
            this.classSignature = sig;
            this.outerType = outer;
            this.nestedTypes = inners;
        }

        public boolean isClassTypeSignature() {
            return true;
        }

        public String toString() {
            return this.classSignature;
        }
    }

    public static abstract class FieldTypeSignature
    extends TypeSignature {
        public boolean isClassTypeSignature() {
            return false;
        }

        public boolean isTypeVariableSignature() {
            return false;
        }

        public boolean isArrayTypeSignature() {
            return false;
        }
    }

    public static class FormalTypeParameter {
        public String identifier;
        public FieldTypeSignature classBound;
        public FieldTypeSignature[] interfaceBounds;

        public String toString() {
            StringBuffer ret = new StringBuffer();
            ret.append("T");
            ret.append(this.identifier);
            ret.append(":");
            ret.append(this.classBound.toString());
            int i = 0;
            while (i < this.interfaceBounds.length) {
                ret.append(":");
                ret.append(this.interfaceBounds[i].toString());
                ++i;
            }
            return ret.toString();
        }
    }

    public static class MethodTypeSignature {
        public FormalTypeParameter[] formalTypeParameters = new FormalTypeParameter[0];
        public TypeSignature[] parameters = new TypeSignature[0];
        public TypeSignature returnType;
        public FieldTypeSignature[] throwsSignatures = new FieldTypeSignature[0];

        public MethodTypeSignature(FormalTypeParameter[] aFormalParameterList, TypeSignature[] aParameterList, TypeSignature aReturnType, FieldTypeSignature[] aThrowsSignatureList) {
            this.formalTypeParameters = aFormalParameterList;
            this.parameters = aParameterList;
            this.returnType = aReturnType;
            this.throwsSignatures = aThrowsSignatureList;
        }

        public String toString() {
            int i;
            StringBuffer sb = new StringBuffer();
            if (this.formalTypeParameters.length > 0) {
                sb.append("<");
                i = 0;
                while (i < this.formalTypeParameters.length) {
                    sb.append(this.formalTypeParameters[i].toString());
                    ++i;
                }
                sb.append(">");
            }
            sb.append("(");
            i = 0;
            while (i < this.parameters.length) {
                sb.append(this.parameters[i].toString());
                ++i;
            }
            sb.append(")");
            sb.append(this.returnType.toString());
            i = 0;
            while (i < this.throwsSignatures.length) {
                sb.append("^");
                sb.append(this.throwsSignatures[i].toString());
                ++i;
            }
            return sb.toString();
        }
    }

    private static final class MyByteArrayInputStream
    extends ByteArrayInputStream {
        MyByteArrayInputStream(String data) {
            super(data.getBytes());
        }

        final int mark() {
            return this.pos;
        }

        final String getData() {
            return new String(this.buf);
        }

        final void reset(int p) {
            this.pos = p;
        }

        final void unread() {
            if (this.pos > 0) {
                --this.pos;
            }
        }
    }

    public static class SimpleClassTypeSignature {
        public String identifier;
        public TypeArgument[] typeArguments;

        public SimpleClassTypeSignature(String identifier) {
            this.identifier = identifier;
            this.typeArguments = new TypeArgument[0];
        }

        public SimpleClassTypeSignature(String identifier, TypeArgument[] args) {
            this.identifier = identifier;
            this.typeArguments = args;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append(this.identifier);
            if (this.typeArguments.length > 0) {
                sb.append("<");
                int i = 0;
                while (i < this.typeArguments.length) {
                    sb.append(this.typeArguments[i].toString());
                    ++i;
                }
                sb.append(">");
            }
            return sb.toString();
        }
    }

    public static class TypeArgument {
        public boolean isWildcard = false;
        public boolean isPlus = false;
        public boolean isMinus = false;
        public FieldTypeSignature signature;

        public TypeArgument() {
            this.isWildcard = true;
        }

        public TypeArgument(boolean plus, boolean minus, FieldTypeSignature aSig) {
            this.isPlus = plus;
            this.isMinus = minus;
            this.signature = aSig;
        }

        public String toString() {
            if (this.isWildcard) {
                return "*";
            }
            StringBuffer sb = new StringBuffer();
            if (this.isPlus) {
                sb.append("+");
            }
            if (this.isMinus) {
                sb.append("-");
            }
            sb.append(this.signature.toString());
            return sb.toString();
        }
    }

    public static abstract class TypeSignature {
        public boolean isBaseType() {
            return false;
        }
    }

    public static class TypeVariableSignature
    extends FieldTypeSignature {
        public String typeVariableName;

        public TypeVariableSignature(String typeVarToken) {
            this.typeVariableName = typeVarToken.substring(1);
        }

        public boolean isTypeVariableSignature() {
            return true;
        }

        public String toString() {
            return "T" + this.typeVariableName + ";";
        }
    }
}

