/*
 * Decompiled with CFR 0.152.
 */
package simple.http;

import java.io.IOException;
import java.io.OutputStream;
import simple.http.ResponseChannel;

final class ResponseStream
extends OutputStream {
    private byte[] buf = new byte[0];
    private byte[] swap = new byte[1];
    private ResponseChannel resp;
    private OutputStream out;
    private int count;
    private boolean open;

    public ResponseStream(ResponseChannel resp) {
        this.resp = resp;
        this.open = true;
    }

    public synchronized void write(int octet) throws IOException {
        this.swap[0] = (byte)octet;
        this.write(this.swap, 0, 1);
    }

    public synchronized void write(byte[] b, int off, int len) throws IOException {
        this.ensureOpen();
        if (this.count + len > this.buf.length) {
            this.flushBuffer();
        }
        if (len > this.buf.length) {
            this.out.write(b, off, len);
        } else {
            System.arraycopy(b, off, this.buf, this.count, len);
            this.count += len;
        }
    }

    public synchronized void ensureCapacity(int min) {
        if (this.buf.length < min) {
            int size = this.buf.length * 2;
            int max = Math.max(min, size);
            byte[] temp = new byte[max];
            System.arraycopy(this.buf, 0, temp, 0, this.count);
            this.buf = temp;
        }
    }

    public synchronized void reset() {
        if (!this.resp.isCommitted()) {
            this.count = 0;
        }
    }

    public synchronized void flush() throws IOException {
        this.flushBuffer();
        this.out.flush();
    }

    private void flushBuffer() throws IOException {
        this.ensureOpen();
        if (!this.isConfigured()) {
            this.out = this.getOutputStream();
        }
        if (this.count > 0) {
            this.out.write(this.buf, 0, this.count);
            this.count = 0;
        }
    }

    public boolean isConfigured() {
        if (!this.resp.isCommitted()) {
            return false;
        }
        return this.out != null;
    }

    private void setConnection() {
        if (this.resp.isChunked()) {
            this.resp.setClose(false);
        } else if (this.resp.getContentLength() < 0) {
            if (this.resp.isChunkable()) {
                this.resp.setChunked(true);
            } else {
                this.resp.setClose(true);
            }
        }
    }

    private OutputStream getOutputStream() throws IOException {
        if (this.resp.isKeepAlive()) {
            this.setConnection();
        }
        return this.resp.getOutputChannel();
    }

    private void ensureOpen() throws IOException {
        if (!this.open) {
            throw new IOException("Stream closed");
        }
    }

    private void ensureCommit() {
        if (!this.resp.isCommitted()) {
            this.resp.setContentLength(this.count);
        }
    }

    public synchronized void close() throws IOException {
        if (this.open) {
            this.ensureCommit();
            this.flushBuffer();
            this.out.close();
            this.open = false;
        }
    }
}

