/*
 * Decompiled with CFR 0.152.
 */
package simple.http;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.InetAddress;
import simple.http.Attributes;
import simple.http.ChunkedOutputStream;
import simple.http.CloseOutputStream;
import simple.http.FixedOutputStream;
import simple.http.NullOutputStream;
import simple.http.OutputMonitor;
import simple.http.Pipeline;
import simple.http.PlainAttributes;
import simple.http.Request;
import simple.http.ResponseChannel;
import simple.http.ResponseHeader;
import simple.http.ResponseStream;
import simple.http.State;
import simple.util.net.ContentType;
import simple.util.net.Cookie;
import simple.util.parse.ContentParser;

final class MonitoredResponse
extends ResponseHeader
implements ResponseChannel {
    private ResponseStream buf;
    private OutputMonitor mon;
    private OutputStream out;
    private Attributes local;
    private Pipeline pipe;
    private Request req;
    private boolean committed;
    private int length = -1;

    public MonitoredResponse(Request req, Pipeline pipe, OutputMonitor mon) throws IOException {
        this.out = pipe.getOutputStream();
        this.buf = new ResponseStream(this);
        this.pipe = pipe;
        this.req = req;
        this.mon = mon;
    }

    public boolean isCommitted() {
        return this.committed;
    }

    public void reset() {
        if (!this.committed) {
            this.buf.reset();
        }
    }

    private void ensureCommit() throws IOException {
        if (!this.committed) {
            this.commit();
        }
    }

    private boolean hasBody() {
        if (this.req.getMethod().equals("HEAD")) {
            return false;
        }
        if (this.getCode() == 204) {
            return false;
        }
        return this.getCode() != 304;
    }

    public boolean isKeepAlive() {
        if (this.contains("Connection")) {
            return !this.contains("Connection", "close");
        }
        return this.req.isKeepAlive();
    }

    public boolean isChunked() {
        return this.contains("Transfer-Encoding", "chunked");
    }

    public boolean isChunkable() {
        if (this.req.getMajor() > 1) {
            return true;
        }
        if (this.req.getMajor() == 1) {
            return this.req.getMinor() > 0;
        }
        return false;
    }

    public void setChunked(boolean chunked) {
        if (!chunked && this.contains("Transfer-Encoding")) {
            this.removeAll("Transfer-Encoding");
        } else if (chunked) {
            this.set("Transfer-Encoding", "chunked");
        }
    }

    public int getContentLength() {
        if (this.length >= 0) {
            return this.length;
        }
        try {
            this.length = this.parseLength();
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return this.length;
    }

    private int parseLength() throws NumberFormatException {
        int index = this.indexOf("Content-Length");
        if (index >= 0) {
            String text = this.getValue(index);
            return Integer.parseInt(text);
        }
        return -1;
    }

    public void setContentLength(int length) {
        this.length = length;
        if (length > 0) {
            this.set("Content-Length", String.valueOf(length));
        }
    }

    public void setClose(boolean close) {
        this.set("Connection", close ? "close" : "keep-alive");
    }

    private void setCookies(State state) {
        Cookie[] list = state.getSetCookies();
        int i = 0;
        while (i < list.length) {
            this.add("Set-Cookie", list[i].toString());
            ++i;
        }
    }

    private ContentType getContentType() {
        int index = this.indexOf("Content-Type");
        if (index >= 0) {
            String text = this.getValue(index);
            return new ContentParser(text);
        }
        return null;
    }

    private String getCharset() {
        ContentType type = this.getContentType();
        if (type == null) {
            return "iso-8859-1";
        }
        if (type.getCharset() == null) {
            return "iso-8859-1";
        }
        return type.getCharset();
    }

    public Attributes getAttributes() {
        if (this.local == null) {
            this.local = new PlainAttributes(this.pipe);
        }
        return this.local;
    }

    public Object getAttribute(String name) {
        return this.getAttributes().get(name);
    }

    public InetAddress getInetAddress() {
        return this.pipe.getInetAddress();
    }

    public OutputStream getOutputStream() {
        return this.buf;
    }

    public OutputStream getOutputStream(int size) {
        this.buf.ensureCapacity(size);
        return this.buf;
    }

    public PrintStream getPrintStream() throws IOException {
        return this.getPrintStream(0, this.getCharset());
    }

    public PrintStream getPrintStream(int size) throws IOException {
        return this.getPrintStream(size, this.getCharset());
    }

    private PrintStream getPrintStream(int size, String charset) throws IOException {
        return new PrintStream(this.getOutputStream(size), false, charset);
    }

    public void commit() throws IOException {
        if (!this.committed) {
            this.setCookies(this.req.getState());
            String head = this.toString();
            try {
                this.out.write(head.getBytes("iso-8859-1"));
            }
            catch (IOException cause) {
                this.mon.notifyError(this.out);
                throw cause;
            }
            this.doConfigure();
            this.committed = true;
        }
    }

    private void doConfigure() throws IOException {
        int size = this.getContentLength();
        boolean hasBody = this.hasBody();
        this.out = hasBody && !this.isKeepAlive() ? new CloseOutputStream(this.out, this.mon) : (hasBody && this.isChunked() ? new ChunkedOutputStream(this.out, this.mon) : (hasBody && size > 0 ? new FixedOutputStream(this.out, this.mon, size) : new NullOutputStream(this.out, this.mon)));
    }

    public OutputStream getOutputChannel() throws IOException {
        this.ensureCommit();
        return this.out;
    }

    protected void finalize() throws Throwable {
        if (!this.committed) {
            this.mon.notifyError(this.out);
        } else {
            this.buf.close();
        }
    }
}

