/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.detector.simple.response;

import java.io.BufferedReader;
import java.io.IOException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.opennms.core.utils.LogUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultilineOrientedResponse {
    private BufferedReader m_in;
    private List<String> m_responseList;

    public MultilineOrientedResponse() {
        this.setResponseList(new ArrayList<String>());
    }

    public void addLine(String line) {
        this.getResponseList().add(line);
    }

    public void receive(BufferedReader in) {
        this.m_in = in;
    }

    public boolean startsWith(String prefix) {
        for (String line : this.getResponseList()) {
            if (line.startsWith(prefix)) continue;
            return false;
        }
        return true;
    }

    public boolean expectedCodeRange(int beginCodeRange, int endCodeRange) {
        for (String line : this.getResponseList()) {
            if (this.validateCodeRange(this.getCode(line), beginCodeRange, endCodeRange)) continue;
            return false;
        }
        return true;
    }

    private String getCode(String firstResponseLine) {
        String codeString = firstResponseLine.substring(0, 3);
        return codeString;
    }

    public boolean containedInHTTP(String pattern, String url, boolean isCheckCode, int maxRetCode) {
        block7: {
            try {
                String response = this.getEntireResponse(this.m_in);
                LogUtils.infof((Object)this, (String)"Checking http response, pattern: %s  URL: %s  isCheckCode: %s  MaxRetCode: %s\n", (Object[])new Object[]{pattern, url, isCheckCode, maxRetCode});
                if (response == null || !response.contains(pattern)) break block7;
                LogUtils.infof((Object)this, (String)("Return from server was: " + response), (Object[])new Object[0]);
                if (isCheckCode) {
                    if ("/".equals(url) || !isCheckCode) {
                        maxRetCode = 600;
                    }
                    StringTokenizer t = new StringTokenizer(response);
                    t.nextToken();
                    String codeString = t.nextToken();
                    if (this.validateCodeRange(codeString, 99, maxRetCode)) {
                        LogUtils.infof((Object)this, (String)"RetCode Passed", (Object[])new Object[0]);
                        return true;
                    }
                    break block7;
                }
                LogUtils.infof((Object)this, (String)"isAServer", (Object[])new Object[0]);
                return true;
            }
            catch (SocketException e) {
                return false;
            }
            catch (NumberFormatException e) {
                return false;
            }
            catch (IOException e) {
                return false;
            }
        }
        return false;
    }

    private String getEntireResponse(BufferedReader in) throws IOException {
        StringBuffer response;
        block3: {
            char[] cbuf = new char[1024];
            int chars = 0;
            response = new StringBuffer();
            try {
                while ((chars = in.read(cbuf, 0, 1024)) != -1) {
                    String line = new String(cbuf, 0, chars);
                    response.append(line);
                }
            }
            catch (SocketTimeoutException timeoutEx) {
                if (timeoutEx.bytesTransferred <= 0) break block3;
                String line = new String(cbuf, 0, timeoutEx.bytesTransferred);
                response.append(line);
            }
        }
        return response.toString();
    }

    private boolean validateCodeRange(String codeString, int beginCodeRange, int endCodeRange) {
        try {
            int code = Integer.parseInt(codeString);
            return code >= beginCodeRange && code <= endCodeRange;
        }
        catch (Exception e) {
            return false;
        }
    }

    public String toString() {
        return this.getResponseList().isEmpty() ? "MultilineOrientedResponse" : String.format("Response: %s", this.getResponseList().toArray());
    }

    public void setResponseList(List<String> responseList) {
        this.m_responseList = responseList;
    }

    public List<String> getResponseList() {
        return this.m_responseList;
    }
}

