/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.detector.simple.response;

import java.util.regex.Pattern;
import org.opennms.netmgt.provision.detector.simple.response.MultilineOrientedResponse;

public class MultilineHttpResponse
extends MultilineOrientedResponse {
    public boolean validateResponse(String pattern, String url, boolean isCheckCode, int maxRetCode) throws Exception {
        String httpResponse;
        String codeStr = Integer.toString(maxRetCode);
        String[] codeArray = codeStr.split("");
        if (codeArray.length < 3) {
            throw new Exception("Max Ret Code is too Short");
        }
        String REGEX = String.format("([H][T][T][P+]/[1].[0-1]) ([0-%s][0-2][0-%s]) ([a-zA-Z ]+)\r\n", codeArray[1], codeArray[3]);
        if (!isCheckCode) {
            REGEX = "([H][T][T][P+]/[1].[0-1]) ([0-6]+) ([a-zA-Z ]+)\r\n";
        }
        if (Pattern.matches(REGEX, httpResponse = (String)this.getResponseList().toArray()[0])) {
            return this.getResponseListAsString(this.getResponseList().toArray()).contains(pattern);
        }
        return false;
    }

    public String toString() {
        return this.getResponseList().isEmpty() ? "MultilineHttpResponse" : String.format("Response: %s", this.getResponseListAsString(this.getResponseList().toArray()));
    }

    private String getResponseListAsString(Object[] array) {
        StringBuffer retVal = new StringBuffer();
        for (int i = 0; i < array.length; ++i) {
            retVal.append((String)array[i]);
        }
        return retVal.toString();
    }

    protected String getResponse() {
        return this.getResponseList().toArray().toString();
    }
}

